/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.uncompress;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIOUncompressVisitor;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUncompress;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.progress.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsUncompress
implements NutsUncompress {
    private NutsLogger LOG;
    private boolean skipRoot = false;
    private boolean safe = true;
    private String format = "zip";
    private NutsWorkspace ws;
    private NutsStreamOrPath source;
    private NutsStreamOrPath target;
    private NutsSession session;
    private NutsProgressFactory progressFactory;
    private Set<NutsPathOption> options = new LinkedHashSet<NutsPathOption>();

    public DefaultNutsUncompress(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsUncompress.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public String getFormat() {
        return this.format;
    }

    public NutsUncompress setFormat(String format) {
        this.checkSession();
        if (NutsBlankable.isBlank((String)format)) {
            format = "zip";
        }
        switch (format) {
            case "zip": 
            case "gzip": 
            case "gz": {
                this.format = format;
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported compression format %s", (Object[])new Object[]{format}));
            }
        }
        return this;
    }

    public Object getSource() {
        return this.source;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public NutsUncompress setSource(InputStream source) {
        this.checkSession();
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.getSession());
        return this;
    }

    public NutsUncompress setSource(NutsPath source) {
        this.checkSession();
        this.source = source == null ? null : NutsStreamOrPath.of(source);
        return this;
    }

    public NutsUncompress setSource(File source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.session);
        return this;
    }

    public NutsUncompress setSource(Path source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.session);
        return this;
    }

    public NutsUncompress setSource(URL source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.session);
        return this;
    }

    public NutsUncompress setTarget(Path target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target, this.session);
        return this;
    }

    public NutsUncompress setTarget(String target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target, this.session);
        return this;
    }

    public NutsUncompress setTarget(File target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target, this.session);
        return this;
    }

    public NutsUncompress setTarget(NutsPath target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target);
        return this;
    }

    public NutsUncompress from(String source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.session);
        return this;
    }

    public NutsUncompress to(String target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target, this.session);
        return this;
    }

    public NutsUncompress from(NutsPath source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source);
        return this;
    }

    public NutsUncompress to(NutsPath target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target);
        return this;
    }

    public Object getTarget() {
        return this.target;
    }

    public NutsUncompress from(InputStream source) {
        return this.setSource(source);
    }

    public NutsUncompress from(File source) {
        return this.setSource(source);
    }

    public NutsUncompress from(Path source) {
        return this.setSource(source);
    }

    public NutsUncompress from(URL source) {
        return this.setSource(source);
    }

    public NutsUncompress to(File target) {
        return this.setTarget(target);
    }

    public NutsUncompress to(Path target) {
        return this.setTarget(target);
    }

    public boolean isSafe() {
        return this.safe;
    }

    public DefaultNutsUncompress setSafe(boolean value) {
        this.safe = value;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsUncompress setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public NutsUncompress run() {
        NutsStreamOrPath _source;
        this.checkSession();
        String format = this.getFormat();
        if (NutsBlankable.isBlank((String)format)) {
            format = "zip";
        }
        if ((_source = this.source) == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing source", (Object[])new Object[0]));
        }
        if (this.target == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing target", (Object[])new Object[0]));
        }
        if (!this.target.isPath() || !this.target.getPath().isFile()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid target %s", (Object[])new Object[]{this.target.getValue()}));
        }
        if (this.options.contains(NutsPathOption.LOG) || this.options.contains(NutsPathOption.TRACE) || this.getProgressFactory() != null) {
            NutsInputStreamMonitor monitor = NutsInputStreamMonitor.of((NutsSession)this.session);
            monitor.setOrigin(_source.getValue());
            monitor.setLogProgress(this.options.contains(NutsPathOption.LOG));
            monitor.setTraceProgress(this.options.contains(NutsPathOption.TRACE));
            monitor.setProgressFactory(this.getProgressFactory());
            if (_source.isInputStream()) {
                monitor.setSource(_source.getInputStream());
            } else {
                monitor.setSource(_source.getPath());
            }
            _source = NutsStreamOrPath.of(monitor.create(), this.session);
        }
        this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"uncompress {0} to {1}", (Object[])new Object[]{_source, this.target}));
        Path folder = this.target.getPath().toFile();
        NutsPath.of((Path)folder, (NutsSession)this.session).mkdirs();
        switch (format) {
            case "zip": {
                this.runZip();
                break;
            }
            case "gzip": 
            case "gz": {
                this.runGZip();
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported format %s", (Object[])new Object[]{format}));
            }
        }
        return this;
    }

    public NutsUncompress visit(NutsIOUncompressVisitor visitor) {
        NutsStreamOrPath _source;
        this.checkSession();
        String format = this.getFormat();
        if (NutsBlankable.isBlank((String)format)) {
            format = "zip";
        }
        if ((_source = this.source) == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing source", (Object[])new Object[0]));
        }
        if (this.target == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing target", (Object[])new Object[0]));
        }
        if (!this.target.isPath() || !this.target.getPath().isFile()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid target %s", (Object[])new Object[]{this.target.getValue()}));
        }
        if (this.options.contains(NutsPathOption.LOG) || this.options.contains(NutsPathOption.TRACE) || this.getProgressFactory() != null) {
            NutsInputStreamMonitor monitor = NutsInputStreamMonitor.of((NutsSession)this.session);
            monitor.setOrigin(_source.getValue());
            monitor.setLogProgress(this.options.contains(NutsPathOption.LOG));
            monitor.setTraceProgress(this.options.contains(NutsPathOption.TRACE));
            monitor.setProgressFactory(this.getProgressFactory());
            if (_source.isInputStream()) {
                monitor.setSource(_source.getInputStream());
            } else {
                monitor.setSource(_source.getPath());
            }
            _source = NutsStreamOrPath.of(monitor.create(), this.session);
        }
        this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"uncompress {0} to {1}", (Object[])new Object[]{_source, this.target}));
        Path folder = this.target.getPath().toFile();
        NutsPath.of((Path)folder, (NutsSession)this.session).mkdirs();
        switch (format) {
            case "zip": {
                this.visitZip(visitor);
                break;
            }
            case "gzip": 
            case "gz": {
                this.visitGZip(visitor);
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)("unsupported format %s" + format), (Object[])new Object[0]));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runZip() {
        this.checkSession();
        NutsStreamOrPath _source = this.source;
        try {
            byte[] buffer = new byte[1024];
            Path folder = this.target.getPath().toFile();
            try (InputStream _in = _source.getInputStream();
                 ZipInputStream zis = new ZipInputStream(_in);){
                ZipEntry ze = zis.getNextEntry();
                String root = null;
                while (ze != null) {
                    Path newFile;
                    String fileName = ze.getName();
                    if (this.skipRoot) {
                        if (root == null) {
                            if (fileName.endsWith("/")) {
                                root = fileName;
                                ze = zis.getNextEntry();
                                continue;
                            }
                            throw new IOException("tot a single root zip");
                        }
                        if (fileName.startsWith(root)) {
                            fileName = fileName.substring(root.length());
                        } else {
                            throw new IOException("tot a single root zip");
                        }
                    }
                    if (fileName.endsWith("/")) {
                        newFile = folder.resolve(fileName);
                        NutsPath.of((Path)newFile, (NutsSession)this.session).mkdirs();
                    } else {
                        newFile = folder.resolve(fileName);
                        this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"file unzip : {0}", (Object[])new Object[]{newFile}));
                        if (newFile.getParent() != null) {
                            NutsPath.of((Path)newFile, (NutsSession)this.session).mkParentDirs();
                        }
                        try (OutputStream fos = Files.newOutputStream(newFile, new OpenOption[0]);){
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error uncompressing {0} to {1} : {2}", (Object[])new Object[]{_source.getValue(), this.target.getValue(), ex}));
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitZip(NutsIOUncompressVisitor visitor) {
        this.checkSession();
        NutsStreamOrPath _source = this.source;
        try (InputStream _in = _source.getInputStream();
             final ZipInputStream zis = new ZipInputStream(_in);){
            ZipEntry ze = zis.getNextEntry();
            String root = null;
            while (ze != null) {
                String fileName = ze.getName();
                if (this.skipRoot) {
                    if (root == null) {
                        if (fileName.endsWith("/")) {
                            root = fileName;
                            ze = zis.getNextEntry();
                            continue;
                        }
                        throw new IOException("tot a single root zip");
                    }
                    if (fileName.startsWith(root)) {
                        fileName = fileName.substring(root.length());
                    } else {
                        throw new IOException("tot a single root zip");
                    }
                }
                if (fileName.endsWith("/") ? !visitor.visitFolder(fileName) : !visitor.visitFile(fileName, new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return zis.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        return zis.read(b, off, len);
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return zis.read(b);
                    }
                })) break;
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error uncompressing {0} to {1} : {2}", (Object[])new Object[]{_source.getValue(), this.target.getValue(), ex}));
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGZip() {
        NutsStreamOrPath _source = this.source;
        try {
            String baseName = _source.getName();
            byte[] buffer = new byte[1024];
            Path folder = this.target.getPath().toFile();
            try (InputStream _in = _source.getInputStream();
                 GZIPInputStream zis = new GZIPInputStream(_in);){
                String n = NutsPath.of((String)(baseName == null ? "" : baseName), (NutsSession)this.session).getName();
                if (n.endsWith(".gz")) {
                    n = n.substring(0, n.length() - 3);
                }
                if (n.isEmpty()) {
                    n = "data";
                }
                Path newFile = folder.resolve(n);
                this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"file unzip : {0}", (Object[])new Object[]{newFile}));
                if (newFile.getParent() != null) {
                    NutsPath.of((Path)newFile, (NutsSession)this.session).mkParentDirs();
                }
                try (OutputStream fos = Files.newOutputStream(newFile, new OpenOption[0]);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error uncompressing {0} to {1} : {2}", (Object[])new Object[]{_source.getValue(), this.target.getValue(), ex}));
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitGZip(NutsIOUncompressVisitor visitor) {
        NutsStreamOrPath _source = this.source;
        try {
            String baseName = _source.getName();
            byte[] buffer = new byte[1024];
            try (InputStream _in = _source.getInputStream();
                 final GZIPInputStream zis = new GZIPInputStream(_in);){
                String n = NutsPath.of((String)(baseName == null ? "" : baseName), (NutsSession)this.session).getName();
                if (n.endsWith(".gz")) {
                    n = n.substring(0, n.length() - 3);
                }
                if (n.isEmpty()) {
                    n = "data";
                }
                visitor.visitFile(n, new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return zis.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        return zis.read(b, off, len);
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return zis.read(b);
                    }
                });
            }
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error uncompressing {0} to {1} : {2}", (Object[])new Object[]{_source.getValue(), this.target.getValue(), ex}));
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public NutsProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    public NutsUncompress setProgressFactory(NutsProgressFactory value) {
        this.progressFactory = value;
        return this;
    }

    public NutsUncompress setProgressMonitor(NutsProgressMonitor value) {
        this.progressFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    public NutsUncompress progressMonitor(NutsProgressMonitor value) {
        return this.setProgressMonitor(value);
    }

    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    public NutsUncompress setSkipRoot(boolean value) {
        this.skipRoot = true;
        return this;
    }

    public NutsUncompress setFormatOption(String option, Object value) {
        return this;
    }

    public Object getFormatOption(String option) {
        return null;
    }

    public NutsUncompress addOptions(NutsPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NutsPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.add(o);
            }
        }
        return this;
    }

    public NutsUncompress removeOptions(NutsPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NutsPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.remove(o);
            }
        }
        return this;
    }

    public NutsUncompress clearOptions() {
        this.options.clear();
        return this;
    }

    public Set<NutsPathOption> getOptions() {
        return new LinkedHashSet<NutsPathOption>(this.options);
    }
}

