/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.tmp;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.StringBuilder2;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsTmp
implements NutsTmp {
    private NutsWorkspace ws;
    private String repositoryId;
    private NutsSession session;

    public DefaultNutsTmp(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public NutsTmp setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsTmp setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public NutsPath createTempFile(String name) {
        return this.createTempFile(name, false);
    }

    public NutsPath createTempFolder(String name) {
        return this.createTempFile(name, true);
    }

    public NutsPath createTempFile() {
        return this.createTempFile(null);
    }

    public NutsPath createTempFolder() {
        return this.createTempFolder(null);
    }

    public NutsPath createTempFile(String name, boolean folder) {
        NutsPath rootFolder = null;
        NutsRepository repositoryById = null;
        if (this.repositoryId == null) {
            rootFolder = this.getSession().locations().setSession(this.getSession()).getStoreLocation(NutsStoreLocation.TEMP);
        } else {
            repositoryById = this.getSession().repos().setSession(this.getSession()).getRepository(this.repositoryId);
            rootFolder = repositoryById.config().setSession(this.getSession()).getStoreLocation(NutsStoreLocation.TEMP);
        }
        NutsId appId = this.getSession().getAppId();
        if (appId == null) {
            appId = this.getSession().getWorkspace().getRuntimeId();
        }
        if (appId != null) {
            rootFolder = rootFolder.resolve("id").resolve(this.getSession().locations().getDefaultIdBasedir(appId));
        }
        if (name == null) {
            name = "";
        }
        rootFolder.mkdirs();
        StringBuilder2 ext = new StringBuilder2(CoreIOUtils.getFileExtension(name, true, true));
        StringBuilder2 prefix = new StringBuilder2(ext.length() > 0 ? name.substring(0, name.length() - ext.length()) : name);
        if (ext.isEmpty() && prefix.isEmpty()) {
            prefix.append("nuts-");
            if (!folder) {
                ext.append(".tmp");
            }
        } else if (ext.isEmpty()) {
            if (!folder) {
                ext.append("-tmp");
            }
        } else if (prefix.isEmpty()) {
            prefix.append(ext);
            ext.clear();
            ext.append("-tmp");
        }
        if (!prefix.endsWith("-")) {
            prefix.append('-');
        }
        if (prefix.length() < 3 && prefix.length() < 3) {
            prefix.append('A');
            if (prefix.length() < 3) {
                prefix.append('B');
            }
        }
        if (folder) {
            for (int i = 0; i < 15; ++i) {
                File temp = null;
                try {
                    temp = File.createTempFile(prefix.toString(), ext.toString(), rootFolder.toFile().toFile());
                    if (!temp.delete() || !temp.mkdir()) continue;
                    return NutsPath.of((Path)temp.toPath(), (NutsSession)this.session);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new NutsIOException(this.session, NutsMessage.cstyle((String)"could not create temp directory: %s*%s", (Object[])new Object[]{rootFolder + File.separator + prefix, ext}));
        }
        try {
            return NutsPath.of((Path)File.createTempFile(prefix.toString(), ext.toString(), rootFolder.toFile().toFile()).toPath(), (NutsSession)this.session);
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }
}

