/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.throwables;

import java.io.PrintStream;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import net.thevpc.nuts.NutsApplicationExceptionHandler;
import net.thevpc.nuts.NutsApplications;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsBootException;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExceptionBase;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.boot.NutsApiUtils;
import net.thevpc.nuts.runtime.standalone.log.NutsLogUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsApplicationExceptionHandler
implements NutsApplicationExceptionHandler {
    public int processThrowable(String[] args, Throwable throwable, NutsSession session) {
        String m;
        NutsExceptionBase neb;
        boolean bot;
        NutsApiUtils.checkSession((NutsSession)session);
        NutsBootOptions bo = null;
        bo = session.boot().getBootOptions().builder().toBootOptions();
        if (!session.env().isGraphicalDesktopEnvironment()) {
            bo.setGui(Boolean.valueOf(false));
        }
        boolean showGui = !(bot = bo.isBot()) && bo.isGui();
        boolean showTrace = bo.getDebug() != null;
        if (!(showTrace |= bo.getLogConfig() != null && bo.getLogConfig().getLogTermLevel() != null && bo.getLogConfig().getLogTermLevel().intValue() < Level.INFO.intValue())) {
            showTrace = NutsApiUtils.getSysBoolNutsProperty((String)"debug", (boolean)false);
        }
        if (bot) {
            showTrace = false;
            showGui = false;
        }
        NutsBootException nbe = (neb = NutsExceptionBase.detectExceptionBase((Throwable)throwable)) != null ? null : NutsBootException.detectBootException((Throwable)throwable);
        int errorCode = 204;
        if (nbe != null) {
            errorCode = nbe.getExitCode();
        } else if (neb instanceof NutsExecutionException) {
            NutsExecutionException ex2 = (NutsExecutionException)throwable;
            errorCode = ex2.getExitCode();
        }
        if (errorCode == 0) {
            return 0;
        }
        NutsString fm = null;
        if (neb != null) {
            fm = neb.getFormattedString();
        }
        if ((m = throwable.getMessage()) == null || m.length() < 5) {
            m = throwable.toString();
        }
        NutsPrintStream fout = null;
        try {
            fout = session.config().getSystemTerminal().getErr();
            fm = fm != null ? NutsTexts.of((NutsSession)session).ofStyled(fm, NutsTextStyle.error()) : NutsTexts.of((NutsSession)session).ofStyled(m, NutsTextStyle.error());
        }
        catch (Exception ex2) {
            NutsLoggerOp.of(NutsApplications.class, (NutsSession)session).level(Level.FINE).error((Throwable)ex2).log(NutsMessage.jstyle((String)"unable to get system terminal", (Object[])new Object[0]));
        }
        boolean showMessage = true;
        if (fout != null) {
            if (session.getOutputFormat() == NutsContentType.PLAIN) {
                if (fm != null) {
                    fout.println(fm);
                } else {
                    fout.println(m);
                }
                if (showTrace) {
                    throwable.printStackTrace(fout.asPrintStream());
                }
                fout.flush();
            } else {
                NutsArrayElementBuilder e;
                if (fm != null) {
                    session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("app-id", session.getAppId() == null ? "" : session.getAppId().toString()).set("error", fm.filteredText()).build());
                    if (showTrace) {
                        session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("errorTrace", (NutsElement)NutsElements.of((NutsSession)session).ofArray().addAll(NutsLogUtils.stacktraceToArray(throwable)).build()).build());
                    }
                    if ((e = session.eout()).size() > 0) {
                        fout.printlnf((Object)e.build());
                        e.clear();
                    }
                    fout.flush();
                } else {
                    session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("app-id", session.getAppId() == null ? "" : session.getAppId().toString()).set("error", m).build());
                    if (showTrace) {
                        session.eout().add((NutsElement)NutsElements.of((NutsSession)session).ofObject().set("errorTrace", (NutsElement)NutsElements.of((NutsSession)session).ofArray().addAll(NutsLogUtils.stacktraceToArray(throwable)).build()).build());
                    }
                    if ((e = session.eout()).size() > 0) {
                        fout.printlnf((Object)e.build());
                        e.clear();
                    }
                    fout.flush();
                }
                fout.flush();
            }
        } else {
            PrintStream out = System.err;
            if (fm != null) {
                out.println(fm);
            } else {
                out.println(m);
            }
            if (showTrace) {
                throwable.printStackTrace(out);
            }
            out.flush();
        }
        if (showGui) {
            StringBuilder sb = new StringBuilder();
            if (fm != null) {
                sb.append(fm.filteredText());
            } else {
                sb.append(m);
            }
            if (showTrace && sb.length() > 0) {
                sb.append("\n");
                sb.append(NutsLogUtils.stacktrace(throwable));
            }
            String title = "Nuts Package Manager - Error";
            try {
                JOptionPane.showMessageDialog(null, NutsMessage.plain((String)sb.toString()).toString());
            }
            catch (UnsatisfiedLinkError e) {
                System.err.printf("[Graphical Environment Unsupported] %s%n", title);
            }
        }
        return errorCode;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 1;
    }
}

