/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.rm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.logging.Level;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRm;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.xtra.rm.AbstractNutsRm;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsRm
extends AbstractNutsRm {
    private Exception error;

    public DefaultNutsRm(NutsSession ws) {
        super(ws);
    }

    private void grabException(IOException e) {
        this.error = e;
        if (this.isFailFast()) {
            throw new NutsIOException(this.getSession(), (Throwable)e);
        }
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public static Path _toPath(Object t) {
        if (t instanceof Path) {
            return (Path)t;
        }
        if (t instanceof File) {
            return ((File)t).toPath();
        }
        if (t instanceof String) {
            return Paths.get((String)t, new String[0]);
        }
        return null;
    }

    public NutsRm run() {
        block8: {
            this.checkSession();
            Path t = DefaultNutsRm._toPath(this.getTarget());
            if (t == null) {
                if (this.getTarget() == null) {
                    throw new NutsException(this.getSession(), NutsMessage.formatted((String)"missing target to delete"));
                }
                throw new NutsException(this.getSession(), NutsMessage.cstyle((String)"unsupported target to delete: %s", (Object[])new Object[]{this.getTarget()}));
            }
            if (!Files.exists(t, new LinkOption[0])) {
                this.grabException(new FileNotFoundException(t.toString()));
                return this;
            }
            if (Files.isRegularFile(t, new LinkOption[0])) {
                try {
                    Files.delete(t);
                }
                catch (IOException e) {
                    this.grabException(e);
                    return this;
                }
                return this;
            }
            final int[] deleted = new int[]{0, 0, 0};
            final NutsLogger LOG = NutsLogger.of(CoreIOUtils.class, (NutsSession)this.getSession());
            try {
                Files.walkFileTree(t, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Files.delete(file);
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsRm.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"delete file {0}", (Object[])new Object[]{file}));
                            }
                            deleted[0] = deleted[0] + 1;
                        }
                        catch (IOException e) {
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsRm.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"failed deleting file : {0}", (Object[])new Object[]{file}));
                            }
                            deleted[2] = deleted[2] + 1;
                            DefaultNutsRm.this.grabException(e);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        try {
                            Files.delete(dir);
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsRm.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"delete folder {0}", (Object[])new Object[]{dir}));
                            }
                            deleted[1] = deleted[1] + 1;
                        }
                        catch (IOException e) {
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsRm.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"failed deleting folder : {0}", (Object[])new Object[]{dir}));
                            }
                            deleted[2] = deleted[2] + 1;
                            DefaultNutsRm.this.grabException(e);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                if (this.error == null) break block8;
                this.grabException(e);
            }
        }
        return this;
    }
}

