/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsProcessInfo;
import net.thevpc.nuts.NutsPs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.stream.NutsEmptyStream;
import net.thevpc.nuts.runtime.standalone.stream.NutsIteratorStream;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.ps.DefaultNutsProcessInfo;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsPs
implements NutsPs {
    private String processType;
    private NutsWorkspace ws;
    private NutsSession session;
    private boolean failFast;

    public DefaultNutsPs(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public NutsPs setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public boolean isSupportedKillProcess() {
        this.checkSession();
        NutsOsFamily f = this.getSession().env().getOsFamily();
        return f == NutsOsFamily.LINUX || f == NutsOsFamily.MACOS || f == NutsOsFamily.UNIX;
    }

    public boolean killProcess(String processId) {
        this.checkSession();
        return this.getSession().exec().addCommand(new String[]{"kill", "-9", processId}).getResult() == 0;
    }

    public NutsPs failFast(boolean failFast) {
        return this.setFailFast(failFast);
    }

    public NutsPs failFast() {
        return this.failFast(true);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsPs setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public String getType() {
        return this.processType;
    }

    public NutsPs setType(String processType) {
        this.processType = processType;
        return this;
    }

    public NutsPs type(String processType) {
        return this.setType(processType);
    }

    private static String getJpsJavaHome(String version, NutsSession session) {
        NutsPlatformLocation[] availableJava;
        ArrayList<String> detectedJavaHomes = new ArrayList<String>();
        String jh = System.getProperty("java.home");
        detectedJavaHomes.add(jh);
        String v = DefaultNutsPs.getJpsJavaHome(jh);
        if (v != null) {
            return v;
        }
        NutsVersionFilter nvf = NutsBlankable.isBlank((String)version) ? null : NutsVersion.of((String)version, (NutsSession)session).filter();
        for (NutsPlatformLocation java2 : availableJava = session.env().platforms().setSession(session).findPlatforms(NutsPlatformFamily.JAVA, java -> "jdk".equals(java.getPackaging()) && (nvf == null || nvf.acceptVersion(NutsVersion.of((String)java.getVersion(), (NutsSession)session), session)))) {
            detectedJavaHomes.add(java2.getPath());
            v = DefaultNutsPs.getJpsJavaHome(java2.getPath());
            if (v == null) continue;
            return v;
        }
        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to resolve a valid jdk installation. Either run nuts with a valid JDK/SDK (not JRE) or register a valid one using 'nuts settings' command. All the followings are invalid : \n%s", (Object[])new Object[]{String.join((CharSequence)"\n", detectedJavaHomes)}), 10);
    }

    private static String getJpsJavaHome(String base) {
        File jh = new File(base);
        if (new File(jh, ".." + File.separator + "bin" + File.separator + "jps").exists()) {
            return jh.getParent();
        }
        if (new File(jh, "bin" + File.separator + "jps").exists()) {
            return jh.getPath();
        }
        return null;
    }

    public NutsStream<NutsProcessInfo> getResultList() {
        this.checkSession();
        String processType = NutsUtilStrings.trim((String)this.getType());
        if (processType.toLowerCase().startsWith("java#")) {
            return this.getResultListJava(processType.substring("java#".length()));
        }
        if (processType.toLowerCase().equals("java")) {
            return this.getResultListJava("");
        }
        if (this.isFailFast()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported list processes of type : %s", (Object[])new Object[]{processType}));
        }
        return new NutsEmptyStream<NutsProcessInfo>(this.getSession(), "process-" + processType);
    }

    private NutsStream<NutsProcessInfo> getResultListJava(String version) {
        this.checkSession();
        NutsIterator it = IteratorBuilder.ofSupplier(() -> {
            String cmd = "jps";
            NutsExecCommand b = null;
            boolean mainArgs = true;
            boolean vmArgs = true;
            String jdkHome = DefaultNutsPs.getJpsJavaHome(version, this.session);
            if (jdkHome != null) {
                cmd = jdkHome + File.separator + "bin" + File.separator + cmd;
            }
            b = this.getSession().exec().setExecutionType(NutsExecutionType.SYSTEM).addCommand(new String[]{cmd}).addCommand(new String[]{"-l" + (mainArgs ? "m" : "") + (vmArgs ? "v" : "")}).setRedirectErrorStream(true).grabOutputString().setFailFast(this.isFailFast());
            b.getResult();
            if (b.getResult() == 0) {
                String out = b.getOutputString();
                String[] split = out.split("\n");
                return Arrays.asList(split).iterator();
            }
            return IteratorBuilder.emptyIterator();
        }, e -> e.ofString("jps"), this.session).map(NutsFunction.of(line -> {
            int s1 = line.indexOf(32);
            int s2 = line.indexOf(32, s1 + 1);
            String pid = line.substring(0, s1).trim();
            String cls = line.substring(s1 + 1, s2 < 0 ? line.length() : s2).trim();
            String args = s2 >= 0 ? line.substring(s2 + 1).trim() : "";
            return new DefaultNutsProcessInfo(pid, cls, null, args);
        }, (String)"processInfo")).build();
        return new NutsIteratorStream<NutsProcessInfo>(this.getSession(), "process-" + this.getType(), it);
    }
}

