/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializer;

public class NanoDBTableFile<T>
implements Iterable<T>,
AutoCloseable {
    public static final String NANODB_TABLE_0_8_1 = "nanodb-table-0.8.1";
    private final Object tableLock = new Object();
    private final NanoDBSerializer<T> serializer;
    private final Map<String, IndexInfo> indexDefinitions = new HashMap<String, IndexInfo>();
    private final File dir;
    private final String tableName;
    private final NanoDB db;
    private final NutsSession session0;
    private NanoDBOutputStream writeStream;
    private NanoDBInputStream readStream;
    private FileChannel readChannel;
    private Class<T> rowType;

    public NanoDBTableFile(Class<T> rowType, File dir, String tableName, NanoDBSerializer<T> serializer, NanoDB db, NanoDBIndexDefinition<T>[] indexDefinitions, NutsSession session0) {
        this.session0 = session0;
        this.rowType = rowType;
        this.dir = dir;
        this.db = db;
        this.tableName = tableName;
        this.serializer = serializer;
        for (NanoDBIndexDefinition<T> indexDefinition : indexDefinitions) {
            this.indexDefinitions.put(indexDefinition.getIndexName(), new IndexInfo(indexDefinition));
        }
    }

    public static int getUTFLength(String s, NutsSession session) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        int init = 0;
        try {
            DataOutputStream r = new DataOutputStream(o);
            r.flush();
            init = o.toByteArray().length;
            r.writeUTF(s);
            r.flush();
        }
        catch (IOException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
        return o.toByteArray().length - init;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long position, NutsSession session) {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.readStream == null) {
                try {
                    FileInputStream readStreamFIS = new FileInputStream(this.getTableFile());
                    this.readChannel = readStreamFIS.getChannel();
                    this.readStream = new NanoDBDefaultInputStream(readStreamFIS, session);
                }
                catch (FileNotFoundException e) {
                    throw new NutsIOException(session, (Throwable)e);
                }
            }
            try {
                this.readChannel.position(position);
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
            return this.serializer.read(this.readStream, this.rowType, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(T a, NutsSession session) {
        Object object = this.tableLock;
        synchronized (object) {
            File tableFile = this.getTableFile();
            boolean writeHeader = false;
            long len = 0L;
            if (!tableFile.exists() || tableFile.length() == 0L) {
                writeHeader = true;
            } else {
                len = tableFile.length();
            }
            if (this.writeStream == null) {
                try {
                    this.writeStream = new NanoDBDefaultOutputStream(new FileOutputStream(tableFile, true), session);
                }
                catch (FileNotFoundException e) {
                    throw new NutsIOException(session, (Throwable)e);
                }
            }
            if (writeHeader) {
                this.writeStream.writeUTF(NANODB_TABLE_0_8_1);
                this.writeStream.flush();
                len = this.writeStream.getPosition();
            }
            this.serializer.write(a, this.writeStream, session);
            this.updateIndices(a, len, session);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(NutsSession session) {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.writeStream != null) {
                this.writeStream.flush();
            }
            for (IndexInfo value : this.indexDefinitions.values()) {
                value.flushIfDirty(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.tableLock;
        synchronized (object) {
            this.flush(this.session0);
            if (this.writeStream != null) {
                this.writeStream.flush();
                this.writeStream.close();
                this.writeStream = null;
            }
            if (this.readStream != null) {
                this.readStream.close();
                this.readStream = null;
            }
            if (this.readChannel != null) {
                this.readChannel = null;
            }
        }
    }

    public NutsStream<T> stream(NutsSession session) {
        return NutsStream.of(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(session), 16), false), (NutsSession)session);
    }

    public Iterable<T> items(final NutsSession s) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return NanoDBTableFile.this.iterator(s);
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.session0);
    }

    public Iterator<T> iterator(final NutsSession session) {
        return new Iterator<T>(){
            T nextValue;
            private NanoDBInputStream is;
            private boolean closed;
            private String header;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.closed) {
                    return false;
                }
                Object object = NanoDBTableFile.this.tableLock;
                synchronized (object) {
                    if (this.is == null && NanoDBTableFile.this.getTableFile().exists()) {
                        try {
                            this.is = new NanoDBDefaultInputStream(new FileInputStream(NanoDBTableFile.this.getTableFile()), session);
                        }
                        catch (IOException ex) {
                            throw new NutsIOException(session, (Throwable)ex);
                        }
                        this.header = this.is.readUTF();
                    }
                    if (this.is != null) {
                        try {
                            this.nextValue = NanoDBTableFile.this.serializer.read(this.is, NanoDBTableFile.this.rowType, session);
                            return this.nextValue != null;
                        }
                        catch (Exception ex) {
                            try {
                                this.is.close();
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                this.is = null;
                                this.closed = true;
                            }
                            if (ex instanceof UncheckedIOException && ex.getCause() instanceof EOFException) {
                                return false;
                            }
                            if (ex instanceof NutsIOException) {
                                if (ex.getCause() instanceof EOFException) {
                                    return false;
                                }
                                throw (NutsIOException)((Object)ex);
                            }
                            throw new NutsIOException(session, (Throwable)ex);
                        }
                    }
                    return false;
                }
            }

            @Override
            public T next() {
                return this.nextValue;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndices(T a, long objectId, NutsSession session) {
        Object object = this.tableLock;
        synchronized (object) {
            for (IndexInfo value : this.indexDefinitions.values()) {
                NanoDBIndex fi = value.getData(session);
                fi.put(value.getDefinition().getIndexedValue(a), objectId, session);
                value.dirty = true;
            }
        }
    }

    private File getTableFile() {
        return new File(this.dir, this.tableName + ".table");
    }

    public NutsStream<T> findByIndex(String indexName, Object value, NutsSession session) {
        return NutsStream.of(this.resolveIndexInfo(indexName).getData(session).get(value, session).mapToObj(pos -> this.get(pos, session)), (NutsSession)session);
    }

    public <T> NutsStream<T> findIndexValues(String indexName, NutsSession session) {
        return NutsStream.of(this.resolveIndexInfo(indexName).getData(session).findAll(session), (NutsSession)session);
    }

    public long getFileLength() {
        return this.getTableFile().length();
    }

    private IndexInfo resolveIndexInfo(String name) {
        IndexInfo y = this.indexDefinitions.get(name);
        if (y == null) {
            throw new IllegalArgumentException("not found index: " + name);
        }
        return y;
    }

    private class IndexInfo {
        NanoDBIndexDefinition def;
        NanoDBIndex data;
        boolean dirty;

        public IndexInfo(NanoDBIndexDefinition def) {
            this.def = def;
        }

        public NanoDBIndexDefinition getDefinition() {
            return this.def;
        }

        public void flushIfDirty(NutsSession session) {
            if (this.dirty) {
                this.flush(session);
                this.dirty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(NutsSession session) {
            Object object = NanoDBTableFile.this.tableLock;
            synchronized (object) {
                this.data.flush(session);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NanoDBIndex getData(NutsSession session) {
            Object object = NanoDBTableFile.this.tableLock;
            synchronized (object) {
                if (this.data != null) {
                    return this.data;
                }
                NanoDBIndex fi = NanoDBTableFile.this.db.createIndexFor(this.def.getIndexType(), NanoDBTableFile.this.db.getSerializers().findSerializer(this.def.getIndexType(), this.def.isNullable()), this.getIndexFile(), session);
                fi.load(session);
                this.data = fi;
                return fi;
            }
        }

        private File getIndexFile() {
            return new File(NanoDBTableFile.this.dir, NanoDBTableFile.this.tableName + "." + this.getIndexName() + ".index");
        }

        private String getIndexName() {
            return this.def.getIndexName();
        }
    }
}

