/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializer;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForBoolean;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForDouble;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForEnumByName;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForInstant;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForInteger;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForLong;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForNullable;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializerForString;

public class NanoDBSerializers {
    private Map<Class, NanoDBSerializer> config = new HashMap<Class, NanoDBSerializer>();
    private Map<ClassWithNullable, NanoDBSerializer> cache = new HashMap<ClassWithNullable, NanoDBSerializer>();

    public NanoDBSerializer of(Class clz, boolean nullable) {
        NanoDBSerializer u = this.findSerializer(clz, nullable);
        if (u != null) {
            return u;
        }
        ClassWithNullable id = new ClassWithNullable(clz, nullable);
        throw new IllegalArgumentException("missing serializer for " + id);
    }

    public void setSerializer(Class clz, Supplier<NanoDBSerializer> nonNullSerializer) {
        NanoDBSerializer old = this.config.get(clz);
        if (old != null) {
            return;
        }
        if (nonNullSerializer == null) {
            return;
        }
        NanoDBSerializer nonNullSerInstance = nonNullSerializer.get();
        if (nonNullSerInstance != null) {
            this.config.put(clz, nonNullSerInstance);
        }
    }

    public void setSerializer(Class clz, NanoDBSerializer ser) {
        NanoDBSerializer old = this.config.get(clz);
        if (old != null) {
            this.invalidateCache(clz);
        }
        if (ser == null) {
            if (old != null) {
                this.config.remove(clz);
            }
            return;
        }
        this.config.put(clz, ser);
    }

    private void invalidateCache(Class clz) {
        for (boolean nullable : new boolean[]{false, true}) {
            this.cache.remove(new ClassWithNullable(clz, nullable));
        }
    }

    public NanoDBSerializer findSerializer(Class clz) {
        return this.findSerializer(clz, !clz.isPrimitive());
    }

    public NanoDBSerializer findSerializer(Class clz, boolean nullable) {
        ClassWithNullable id = new ClassWithNullable(clz, nullable);
        NanoDBSerializer t = this.cache.get(id);
        if (t != null) {
            return t;
        }
        t = this.config.get(clz);
        if (t == null) {
            t = this.findDefaultSerializer(id);
        }
        if (nullable) {
            if (t != null) {
                t = new NanoDBSerializerForNullable(t);
                this.cache.put(id, t);
            }
        } else if (t != null) {
            this.cache.put(id, t);
        }
        return t;
    }

    private NanoDBSerializer findDefaultSerializer(ClassWithNullable id) {
        switch (id.getCls().getName()) {
            case "int": 
            case "java.lang.Integer": {
                return new NanoDBSerializerForInteger();
            }
            case "long": 
            case "java.lang.Long": {
                return new NanoDBSerializerForLong();
            }
            case "double": 
            case "java.lang.Double": {
                return new NanoDBSerializerForDouble();
            }
            case "boolean": 
            case "java.lang.boolean": {
                return new NanoDBSerializerForBoolean();
            }
            case "java.lang.String": {
                return new NanoDBSerializerForString();
            }
            case "java.time.Instant": {
                return new NanoDBSerializerForInstant();
            }
        }
        if (id.getCls().isEnum()) {
            return new NanoDBSerializerForEnumByName();
        }
        return null;
    }

    private static class ClassWithNullable {
        private final Class cls;
        private final boolean nullable;

        public ClassWithNullable(Class cls, boolean nullable) {
            this.cls = cls;
            this.nullable = nullable;
        }

        public Class getCls() {
            return this.cls;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public int hashCode() {
            return Objects.hash(this.cls, this.nullable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassWithNullable that = (ClassWithNullable)o;
            return this.nullable == that.nullable && Objects.equals(this.cls, that.cls);
        }

        public String toString() {
            if (this.cls.isPrimitive()) {
                if (this.nullable) {
                    return "nullable-" + this.cls.getName();
                }
                return this.cls.getName();
            }
            if (!this.nullable) {
                return "non-nullable-" + this.cls.getName();
            }
            return this.cls.getName();
        }
    }
}

