/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBOutputStreamCounter;

public class NanoDBDefaultOutputStream
implements NanoDBOutputStream {
    private DataOutputStream dos;
    private NanoDBOutputStreamCounter counter;
    private NutsSession session;

    public NanoDBDefaultOutputStream(OutputStream out, NutsSession session) {
        this.counter = new NanoDBOutputStreamCounter(out);
        this.dos = new DataOutputStream(this.counter);
        this.session = session;
    }

    @Override
    public void writeLob(String name, InputStream in) {
        try {
            byte[] x = new byte[12288];
            while (true) {
                int v;
                if ((v = in.read(x)) <= 0) {
                    this.dos.writeInt(-1);
                    break;
                }
                this.dos.writeInt(v);
                this.dos.write(v);
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public long getPosition() {
        return this.counter.getCounter();
    }

    @Override
    public void writeBoolean(boolean val) {
        try {
            this.dos.writeBoolean(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeByte(int val) {
        try {
            this.dos.writeByte(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeShort(int val) {
        try {
            this.dos.writeShort(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeChar(int val) {
        try {
            this.dos.writeChar(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeInt(int val) {
        try {
            this.dos.writeInt(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeLong(long val) {
        try {
            this.dos.writeLong(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeFloat(float val) {
        try {
            this.dos.writeFloat(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeDouble(double val) {
        try {
            this.dos.writeDouble(val);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeBytes(String str) {
        try {
            this.dos.writeBytes(str);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeChars(String str) {
        try {
            this.dos.writeChars(str);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void writeUTF(String str) {
        try {
            this.dos.writeUTF(str);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void close() {
        try {
            this.dos.close();
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    @Override
    public void flush() {
        try {
            this.dos.flush();
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }
}

