/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStore;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStoreFactory;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBAbstractIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializer;

public class NanoDBDefaultIndex<T>
extends NanoDBAbstractIndex<T> {
    public static final String NANODB_INDEX_0_8_1 = "nanodb-index-0.8.1";
    private Map<T, DBIndexValueStore> index = new HashMap<T, DBIndexValueStore>();
    private DBIndexValueStoreFactory storeFactory;
    private File file;
    private Class<T> keyType;

    public NanoDBDefaultIndex(Class<T> keyType, NanoDBSerializer<T> ser, DBIndexValueStoreFactory storeFactory, Map<T, DBIndexValueStore> index, File file) {
        super(ser);
        this.keyType = keyType;
        this.index = index;
        this.storeFactory = storeFactory;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void load(NutsSession session) {
        if (this.file.exists()) {
            this.load(this.file, session);
        }
    }

    @Override
    public void flush(NutsSession session) {
        this.file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(this.file);){
            this.store(new NanoDBDefaultOutputStream(out, session), session);
        }
        catch (IOException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    @Override
    public void put(T s, long position, NutsSession session) {
        DBIndexValueStore store = this.index.get(s);
        if (store == null) {
            store = this.storeFactory.create(this, s);
            this.index.put(s, store);
        }
        store.add(position, session);
    }

    @Override
    public LongStream get(T s, NutsSession session) {
        DBIndexValueStore store = this.index.get(s);
        return store == null ? Arrays.stream(new long[0]) : store.stream(session);
    }

    @Override
    public void clear(NutsSession session) {
        this.index.clear();
    }

    @Override
    public Stream<T> findAll(NutsSession session) {
        return this.index.keySet().stream();
    }

    public void storeKey(T k, NanoDBOutputStream dos, NutsSession session) throws IOException {
        this.ser.write(k, dos, session);
    }

    public void store(NanoDBOutputStream dos, NutsSession session) {
        try {
            dos.writeUTF(NANODB_INDEX_0_8_1);
            dos.writeLong(this.index.size());
            for (Map.Entry<T, DBIndexValueStore> e : this.index.entrySet()) {
                this.storeKey(e.getKey(), dos, session);
                DBIndexValueStore store = e.getValue();
                boolean mem = store.isMem();
                if (mem) {
                    long[] pos = store.stream(session).toArray();
                    dos.writeByte(0);
                    dos.writeInt(pos.length);
                    for (long po : pos) {
                        dos.writeLong(po);
                    }
                    continue;
                }
                dos.writeByte(1);
                store.flush(session);
            }
            dos.flush();
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public void load(NanoDBInputStream in, NutsSession session) {
        try {
            String header = in.readUTF();
            if (!NANODB_INDEX_0_8_1.equals(header)) {
                throw new NutsIOException(session, NutsMessage.cstyle((String)"unsupported index file %s", (Object[])new Object[]{header}));
            }
            long r = in.readLong();
            this.index = new HashMap<T, DBIndexValueStore>(r <= 10L ? 10 : (int)r);
            for (long i = 0L; i < r; ++i) {
                T o = this.readKey(in, session);
                byte type = in.readByte();
                if (type == 0) {
                    int len = in.readInt();
                    long[] pos = new long[len];
                    for (int j = 0; j < len; ++j) {
                        pos[j] = in.readLong();
                    }
                    this.index.put(o, this.storeFactory.load(this, o, pos));
                    continue;
                }
                if (type == 1) {
                    this.index.put(o, this.storeFactory.loadExternal(this, o));
                    continue;
                }
                this.index.put(o, this.storeFactory.loadExternal(this, o));
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    protected T readKey(NanoDBInputStream in, NutsSession session) throws IOException {
        return this.ser.read(in, this.keyType, session);
    }

    public void store(File stream, NutsSession session) throws IOException {
        try (FileOutputStream out = new FileOutputStream(stream);){
            this.store(new NanoDBDefaultOutputStream(out, session), session);
        }
    }

    public void load(File stream, NutsSession session) {
        try (FileInputStream out = new FileInputStream(stream);){
            this.load(new NanoDBDefaultInputStream(out, session), session);
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }
}

