/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStoreDefaultFactory;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializer;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializers;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableDefinitionBuilderFromBean;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableFile;

public class NanoDB
implements AutoCloseable {
    private Map<String, NanoDBTableFile> tables = new HashMap<String, NanoDBTableFile>();
    private File dir;
    private NanoDBSerializers serializers = new NanoDBSerializers();

    public NanoDB(File dir) {
        this.dir = dir;
        dir.mkdirs();
    }

    public void flush(NutsSession session) {
        for (NanoDBTableFile value : this.tables.values()) {
            value.flush(session);
        }
    }

    @Override
    public void close() {
        for (NanoDBTableFile value : this.tables.values()) {
            value.close();
        }
    }

    public NanoDBSerializers getSerializers() {
        return this.serializers;
    }

    public NanoDBTableFile findTable(String name, NutsSession session) {
        return this.tables.get(name);
    }

    public NanoDBTableFile getTable(String name, NutsSession session) {
        NanoDBTableFile tableFile = this.tables.get(name);
        if (tableFile == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"table does not exists: %s", (Object[])new Object[]{name}));
        }
        return tableFile;
    }

    public <T> NanoDBTableDefinitionBuilderFromBean<T> tableBuilder(Class<T> type, NutsSession session) {
        return new NanoDBTableDefinitionBuilderFromBean<T>(type, this, session);
    }

    public <T> NanoDBTableFile<T> createTable(NanoDBTableDefinition<T> def, NutsSession session) {
        return this.createTable(def, false, session);
    }

    public <T> NanoDBTableFile<T> getOrCreateTable(NanoDBTableDefinition<T> def, NutsSession session) {
        return this.createTable(def, true, session);
    }

    public <T> NanoDBTableFile<T> createTable(NanoDBTableDefinition<T> def, boolean getOrCreate, NutsSession session) {
        if (def == null) {
            throw new IllegalArgumentException("null table definition");
        }
        String name = def.getName();
        if (getOrCreate) {
            NanoDBTableFile oldTable = this.tables.get(name);
            if (this.tables.containsKey(name)) {
                return oldTable;
            }
        }
        if (NutsBlankable.isBlank((String)name)) {
            throw new IllegalArgumentException("invalid table definition: null name");
        }
        NanoDBSerializer serializer = def.getSerializer();
        Class<T> serSupportedType = serializer != null ? serializer.getSupportedType() : null;
        Class<T> defType = def.getType();
        if (defType == null) {
            defType = serSupportedType;
        }
        if (serSupportedType == null) {
            serSupportedType = defType;
        }
        if (defType == null || serSupportedType == null) {
            throw new IllegalArgumentException("invalid table definition: invalid type");
        }
        if (serializer == null) {
            serializer = this.getSerializers().of(defType, true);
        }
        if (!serSupportedType.isAssignableFrom(defType)) {
            throw new IllegalArgumentException("invalid table definition: invalid type: " + defType.getName() + "; unsupported by a serializer for " + serSupportedType.getName());
        }
        if (this.tables.containsKey(name)) {
            throw new IllegalArgumentException("table already defined: " + name);
        }
        NanoDBIndexDefinition<T>[] indices = def.getIndices();
        if (indices == null) {
            indices = new NanoDBIndexDefinition[]{};
        }
        for (NanoDBIndexDefinition<T> index : indices) {
            if (index != null) continue;
            throw new IllegalArgumentException("invalid table definition: null index");
        }
        NanoDBTableFile<T> f = new NanoDBTableFile<T>(def.getType(), this.dir, name, serializer, this, indices, session);
        this.tables.put(name, f);
        return f;
    }

    public boolean containsTable(String tableName, NutsSession session) {
        return this.tables.containsKey(tableName);
    }

    public <T> NanoDBIndex<T> createIndexFor(Class<T> type, NanoDBSerializer<T> ser, File file, NutsSession session) {
        return new NanoDBDefaultIndex<T>(type, ser, new DBIndexValueStoreDefaultFactory(), new HashMap(), file);
    }
}

