/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb;

import java.io.File;
import java.util.Arrays;
import java.util.stream.LongStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueFileStore;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStore;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndex;

public class DBIndexValueMemStore
implements DBIndexValueStore {
    private long[] val;
    private File file;
    private final int max = 1000;
    private final NanoDBIndex index;
    private final Object indexKey;
    private DBIndexValueFileStore fallback;

    public DBIndexValueMemStore(NanoDBIndex index, Object indexKey, long[] val) {
        this.index = index;
        this.indexKey = indexKey;
        this.val = val;
    }

    @Override
    public void add(long position, NutsSession session) {
        if (this.fallback == null && this.val.length + 1 < 1000) {
            if (this.val.length == 0) {
                this.val = new long[]{position};
            } else {
                long[] t2 = new long[this.val.length + 1];
                System.arraycopy(this.val, 0, t2, 0, this.val.length);
                t2[this.val.length] = position;
                this.val = t2;
            }
        } else {
            if (this.fallback == null) {
                this.fallback = new DBIndexValueFileStore(this.index, this.indexKey);
                this.fallback.addAll(this.val, session);
                this.val = null;
            }
            this.fallback.add(position, session);
        }
    }

    @Override
    public void addAll(long[] position, NutsSession session) {
        if (this.fallback == null && this.val.length + position.length < 1000) {
            if (this.val.length == 0) {
                this.val = Arrays.copyOf(position, position.length);
            } else {
                long[] t2 = new long[this.val.length + position.length];
                System.arraycopy(this.val, 0, t2, 0, this.val.length);
                System.arraycopy(position, 0, t2, this.val.length, position.length);
                this.val = t2;
            }
        } else {
            if (this.fallback == null) {
                this.fallback = new DBIndexValueFileStore(this.index, this.indexKey);
                this.fallback.addAll(this.val, session);
                this.val = null;
            }
            this.fallback.addAll(position, session);
        }
    }

    @Override
    public LongStream stream(NutsSession session) {
        if (this.fallback == null) {
            return Arrays.stream(this.val);
        }
        return this.fallback.stream(session);
    }

    @Override
    public boolean isMem() {
        return this.fallback == null;
    }

    @Override
    public void flush(NutsSession session) {
        if (this.fallback != null) {
            this.fallback.flush(session);
        }
    }
}

