/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.hashname;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsHashName;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsHashName
implements NutsHashName {
    private NutsSession session;
    private Object source;
    private String sourceType;

    public DefaultNutsHashName(NutsSession session) {
        this.session = session;
    }

    public String getWorkspaceHashName(String path) {
        String p;
        String n;
        if (path == null) {
            path = "";
        }
        if (path.contains("\\") || path.contains("/") || path.equals(".") || path.equals("..")) {
            Path pp = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            n = pp.getFileName().toString();
            p = pp.getParent() == null ? null : pp.getParent().toString();
        } else {
            n = path;
            p = "";
        }
        if (p == null) {
            return ("Root " + n).trim();
        }
        Path root = Paths.get(NutsUtilPlatforms.getWorkspaceLocation(null, (boolean)false, null), new String[0]).getParent().getParent();
        if (p.equals(root.toString())) {
            return n;
        }
        return (this.getHashName(p) + " " + n).trim();
    }

    public String getHashName(Object source) {
        return this.getHashName(source, null);
    }

    public String getHashName(Object source, String sourceType) {
        if (source == null) {
            return "default";
        }
        if (source instanceof String) {
            if ("workspace".equalsIgnoreCase(sourceType)) {
                return this.getWorkspaceHashName(source.toString());
            }
            if (source.toString().isEmpty()) {
                return "empty";
            }
            return this.getHashName(source.hashCode());
        }
        if (source instanceof NutsPath) {
            if ("workspace".equalsIgnoreCase(sourceType)) {
                return this.getWorkspaceHashName(source.toString());
            }
            return this.getHashName(source.hashCode());
        }
        if (source instanceof NutsWorkspace) {
            NutsPath location = ((NutsWorkspace)source).getLocation();
            return this.getWorkspaceHashName(location == null ? null : location.toString());
        }
        if (source instanceof NutsSession) {
            NutsPath location = ((NutsSession)source).getWorkspace().getLocation();
            return this.getWorkspaceHashName(location == null ? null : location.toString());
        }
        if (source instanceof Integer) {
            int i = (Integer)source;
            return CoreNutsUtils.COLOR_NAMES[Math.abs(i) % CoreNutsUtils.COLOR_NAMES.length];
        }
        return this.getHashName(source.hashCode());
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

