/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.glob;

import java.util.regex.Pattern;
import net.thevpc.nuts.NutsBlankable;

public class GlobUtils {
    public static final Pattern PATTERN_ALL = Pattern.compile(".*");

    public static Pattern ofExact(String pattern) {
        if (NutsBlankable.isBlank((String)pattern)) {
            return PATTERN_ALL;
        }
        return Pattern.compile(GlobUtils.simpexpToRegexp(pattern, false));
    }

    public static Pattern ofContains(String pattern) {
        if (NutsBlankable.isBlank((String)pattern)) {
            return PATTERN_ALL;
        }
        return Pattern.compile(GlobUtils.simpexpToRegexp(pattern, true));
    }

    private static String simpexpToRegexp(String pattern, boolean contains) {
        if (pattern == null) {
            pattern = "*";
        }
        char[] cc = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < cc.length; ++i) {
            char c = cc[i];
            switch (c) {
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\').append(c);
                    continue block4;
                }
                case '*': {
                    sb.append(".*");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (!contains) {
            sb.insert(0, '^');
            sb.append('$');
        }
        return sb.toString();
    }

    public static Pattern glob(String o, String separators) {
        if (separators == null || separators.length() == 0) {
            separators = "/";
        }
        for (char s : separators.toCharArray()) {
            switch (s) {
                case '(': 
                case ')': 
                case '*': 
                case '<': 
                case '>': 
                case '?': 
                case '{': 
                case '}': {
                    throw new IllegalArgumentException("unsupported glob separator " + s);
                }
            }
        }
        char s = separators.charAt(0);
        while (true) {
            if (o.endsWith(s + "**" + s + "*")) {
                o = o.substring(0, o.length() - 5);
                continue;
            }
            if (o.endsWith(s + "**")) {
                o = o.substring(0, o.length() - 3);
                continue;
            }
            if (!o.endsWith(s + "*")) break;
            o = o.substring(0, o.length() - 2);
        }
        if (o.isEmpty()) {
            return Pattern.compile(".*");
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = o.toCharArray();
        String escapedSeparators = GlobUtils.escapeSeparators(separators);
        block10: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '.': 
                case '<': 
                case '>': 
                case '{': 
                case '}': {
                    sb.append('\\');
                    sb.append(c);
                    continue block10;
                }
                case '*': {
                    if (i + 1 < chars.length && chars[i + 1] == '*') {
                        if (i + 2 < chars.length && chars[i + 2] == s) {
                            if (++i + 3 < chars.length) {
                                sb.append(".*[" + escapedSeparators + "]");
                                continue block10;
                            }
                            sb.append(".*");
                            continue block10;
                        }
                        ++i;
                        sb.append(".*");
                        continue block10;
                    }
                    sb.append("[^" + escapedSeparators + "]*");
                    continue block10;
                }
                case '?': {
                    sb.append("[^").append(escapedSeparators).append("]?");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return Pattern.compile(sb.toString());
    }

    private static String escapeSeparators(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

