/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.glob;

import java.io.File;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsGlob;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsGlob
implements NutsGlob {
    private final NutsSession session;
    private String separator;

    public DefaultNutsGlob(NutsSession session) {
        this.session = session;
        this.separator = File.separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public NutsGlob setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public boolean isGlob(String pattern) {
        if (pattern == null) {
            return false;
        }
        for (char c : pattern.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': 
                case '[': 
                case ']': {
                    return true;
                }
            }
        }
        return false;
    }

    public Pattern toPattern(String pattern) {
        if (NutsBlankable.isBlank((String)pattern)) {
            return GlobUtils.PATTERN_ALL;
        }
        return GlobUtils.glob(pattern, this.getSeparator());
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

