/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.io.StringReader;
import java.util.ArrayList;
import net.thevpc.nuts.NutsExpr;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultFctNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultLiteralNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultOpNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultVarNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NutsExprWithCache;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NutsToken;
import net.thevpc.nuts.runtime.standalone.xtra.expr.TokenIterator;

public class SyntaxParser {
    TokenIterator tokens;
    NutsExpr evaluator;
    NutsExprWithCache withCache;

    public SyntaxParser(String anyStr, NutsExprWithCache withCache) {
        this(new TokenIterator(new StringReader(anyStr == null ? "" : anyStr), withCache.getEvaluator().getSession()), withCache);
    }

    public SyntaxParser(TokenIterator tokens, NutsExprWithCache withCache) {
        this.tokens = tokens;
        this.withCache = withCache;
        this.evaluator = withCache.getEvaluator();
    }

    public NutsExpr.Node parse() {
        NutsExpr.Node e = this.nextExpr();
        if (this.tokens.peek() != null) {
            throw new NutsIllegalArgumentException(this.evaluator.getSession(), NutsMessage.cstyle((String)"unexpected token %s, after reading %s", (Object[])new Object[]{this.tokens.peek(), e}));
        }
        return e;
    }

    private NutsExpr.Node nextExpr() {
        return this.nextNonTerminal(0);
    }

    String opName(NutsToken t) {
        if (t == null) {
            return null;
        }
        switch (t.ttype) {
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -1: 
            case 10: 
            case 40: 
            case 41: {
                return null;
            }
        }
        String s = t.sval;
        if (s == null) {
            s = String.valueOf((char)t.ttype);
        }
        return s;
    }

    boolean isOp(NutsToken t, NutsExpr.OpType opType, int precedenceIndex) {
        if (t == null) {
            return false;
        }
        switch (t.ttype) {
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -1: 
            case 10: 
            case 40: 
            case 41: {
                return false;
            }
        }
        String s = t.sval;
        if (s == null) {
            s = String.valueOf((char)t.ttype);
        }
        return this.withCache.isOp(s, opType, precedenceIndex);
    }

    private NutsExpr.Node nextNonTerminal(int precedenceIndex) {
        if (precedenceIndex == this.withCache.precedences.length) {
            return this.nextTerminal();
        }
        NutsToken t = this.tokens.peek();
        if (t == null) {
            return null;
        }
        NutsExpr.Node first = null;
        if (this.isOp(t, NutsExpr.OpType.PREFIX, precedenceIndex)) {
            this.tokens.next();
            NutsExpr.Node q = this.nextNonTerminal(precedenceIndex);
            if (q == null) {
                throw new NutsIllegalArgumentException(this.evaluator.getSession(), NutsMessage.cstyle((String)"expected expression", (Object[])new Object[0]));
            }
            first = new DefaultOpNode(this.opName(t), NutsExpr.OpType.PREFIX, this.withCache.precedences[precedenceIndex], new NutsExpr.Node[]{q});
        } else {
            first = this.nextNonTerminal(precedenceIndex + 1);
        }
        if (first == null) {
            throw new NutsIllegalArgumentException(this.evaluator.getSession(), NutsMessage.cstyle((String)"expected expression", (Object[])new Object[0]));
        }
        NutsToken infixOp = this.tokens.peek();
        if (this.isOp(infixOp, NutsExpr.OpType.INFIX, precedenceIndex)) {
            this.tokens.next();
            NutsExpr.Node q = this.nextNonTerminal(precedenceIndex + 1);
            if (q == null) {
                throw new NutsIllegalArgumentException(this.evaluator.getSession(), NutsMessage.cstyle((String)"expected expression", (Object[])new Object[0]));
            }
            first = new DefaultOpNode(this.opName(infixOp), NutsExpr.OpType.INFIX, this.withCache.precedences[precedenceIndex], new NutsExpr.Node[]{first, q});
            infixOp = this.tokens.peek();
            while (infixOp != null && this.isOp(infixOp, NutsExpr.OpType.INFIX, precedenceIndex)) {
                this.tokens.next();
                q = this.nextNonTerminal(precedenceIndex + 1);
                if (q == null) {
                    throw new NutsIllegalArgumentException(this.evaluator.getSession(), NutsMessage.cstyle((String)"expected expression", (Object[])new Object[0]));
                }
                first = new DefaultOpNode(this.opName(infixOp), NutsExpr.OpType.INFIX, this.withCache.precedences[precedenceIndex], new NutsExpr.Node[]{first, q});
                infixOp = this.tokens.peek();
            }
            return first;
        }
        if (this.isOp(infixOp, NutsExpr.OpType.POSTFIX, precedenceIndex)) {
            this.tokens.next();
            return new DefaultOpNode(this.opName(infixOp), NutsExpr.OpType.POSTFIX, this.withCache.precedences[precedenceIndex], new NutsExpr.Node[]{first});
        }
        return first;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NutsExpr.Node nextTerminal() {
        NutsToken t = this.tokens.peek();
        if (t == null) {
            return null;
        }
        switch (t.ttype) {
            case 40: {
                this.tokens.next();
                t = this.tokens.peek();
                if (t.ttype == 41) {
                    throw new IllegalArgumentException("empty par");
                }
                NutsExpr.Node e = this.nextExpr();
                if (e != null) return e;
                throw new IllegalArgumentException("expected expr");
            }
            case -3: {
                String n = t.sval;
                this.tokens.next();
                t = this.tokens.peek();
                if (t.ttype != 40) return new DefaultVarNode(n);
                ArrayList<NutsExpr.Node> functionParams = new ArrayList<NutsExpr.Node>();
                this.tokens.next();
                t = this.tokens.peek();
                if (t.ttype == 41) {
                    this.tokens.next();
                    return new DefaultFctNode(n, functionParams.toArray(new NutsExpr.Node[0]));
                } else {
                    NutsExpr.Node e = this.nextExpr();
                    if (e == null) {
                        throw new IllegalArgumentException("expected expr");
                    }
                    functionParams.add(e);
                    while (true) {
                        t = this.tokens.peek();
                        if (t.ttype == 41) {
                            this.tokens.next();
                            return new DefaultFctNode(n, functionParams.toArray(new NutsExpr.Node[0]));
                        }
                        if (t.ttype != 44) throw new IllegalArgumentException("expected ',' or ')'");
                        this.tokens.next();
                        e = this.nextExpr();
                        if (e == null) {
                            throw new IllegalArgumentException("expected expr");
                        }
                        functionParams.add(e);
                    }
                }
            }
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -5: 
            case -4: {
                this.tokens.next();
                return new DefaultLiteralNode(t.nval);
            }
            case -10: {
                this.tokens.next();
                return new DefaultLiteralNode(t.sval);
            }
        }
        throw new NutsIllegalArgumentException(this.evaluator.getSession(), NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{t}));
    }
}

