/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsSession;

public class StringMapParser {
    private final String eqSeparators;
    private final String entrySeparators;

    public StringMapParser(String eqSeparators, String entrySeparators) {
        this.eqSeparators = eqSeparators;
        this.entrySeparators = entrySeparators;
    }

    private static int readToken(Reader reader, String stopTokens, StringBuilder result) throws IOException {
        int r;
        block10: while ((r = reader.read()) != -1) {
            if (r == 34 || r == 39) {
                char s = (char)r;
                block11: while (true) {
                    if ((r = reader.read()) == -1) {
                        throw new RuntimeException("Expected \"");
                    }
                    if (r == s) continue block10;
                    if (r == 92) {
                        r = reader.read();
                        if (r == -1) {
                            throw new RuntimeException("Expected \"");
                        }
                        switch ((char)r) {
                            case 'n': {
                                result.append('\n');
                                continue block11;
                            }
                            case 'r': {
                                result.append('\r');
                                continue block11;
                            }
                            case 'f': {
                                result.append('\f');
                                continue block11;
                            }
                        }
                        result.append((char)r);
                        continue;
                    }
                    char cr = (char)r;
                    result.append(cr);
                }
            }
            char cr = (char)r;
            if (cr == '\\') {
                r = reader.read();
                if (r == -1) {
                    result.append(cr);
                    return -1;
                }
                switch ((char)r) {
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    case 'f': {
                        result.append('\f');
                        break;
                    }
                    default: {
                        result.append((char)r);
                    }
                }
            }
            if (stopTokens != null && stopTokens.indexOf(cr) >= 0) {
                return cr;
            }
            result.append(cr);
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> parseMap(String text, NutsSession session) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        StringReader reader = new StringReader(text == null ? "" : text);
        while (true) {
            StringBuilder key = new StringBuilder();
            int r = 0;
            try {
                r = StringMapParser.readToken(reader, this.eqSeparators + this.entrySeparators, key);
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
            String t = key.toString();
            if (r == -1) {
                if (t.isEmpty()) return m;
                m.put(t, null);
                return m;
            }
            char c = (char)r;
            if (this.eqSeparators.indexOf(c) < 0) continue;
            StringBuilder value = new StringBuilder();
            try {
                r = StringMapParser.readToken(reader, this.entrySeparators, value);
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
            m.put(t, value.toString());
            if (r == -1) return m;
        }
    }

    public String encode(String str, boolean forceQuote, QuoteType quoteType) {
        if (str == null) {
            str = "";
        }
        if (quoteType == null) {
            quoteType = QuoteType.SIMPLE;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c < ' ') {
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                    }
                }
                continue;
            }
            if (c == '\'') {
                if (forceQuote) {
                    if (quoteType == QuoteType.SIMPLE) {
                        sb.append('\'');
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (sb.length() == 0) {
                    forceQuote = true;
                }
                sb.append('\'');
                continue;
            }
            if (c == '\"') {
                if (forceQuote) {
                    if (quoteType == QuoteType.DOUBLE) {
                        sb.append('\"');
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (sb.length() == 0) {
                    forceQuote = true;
                }
                sb.append('\"');
                continue;
            }
            if (c == '\\') {
                sb.append('\\').append(c);
                continue;
            }
            if (this.eqSeparators.indexOf(c) >= 0 || this.entrySeparators.indexOf(c) >= 0) {
                if (forceQuote) {
                    sb.append(c);
                    continue;
                }
                sb.append('\\');
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (forceQuote) {
            if (quoteType == QuoteType.DOUBLE) {
                sb.insert(0, '\"');
                sb.append('\"');
            } else {
                sb.insert(0, '\'');
                sb.append('\'');
            }
        }
        return sb.toString();
    }

    public static enum When {
        QUOTE_ALWAYS,
        QUOTE_REQUIRED,
        QUOTE_NEVER;

    }

    public static enum QuoteType {
        DOUBLE,
        SIMPLE;

    }
}

