/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.thevpc.nuts.NutsExpr;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNutsExpr;

class NutsExprWithCache {
    NutsExpr evaluator;
    int[] precedences;
    Map<Integer, Set<String>> prefixOpByName = new HashMap<Integer, Set<String>>();
    Map<Integer, Set<String>> infixOpByName = new HashMap<Integer, Set<String>>();
    Map<Integer, Set<String>> postfixOpByName = new HashMap<Integer, Set<String>>();

    public NutsExprWithCache(DefaultNutsExpr evaluator) {
        this.evaluator = evaluator;
        TreeSet<Integer> precedences = new TreeSet<Integer>();
        for (NutsExpr.OpType opType : NutsExpr.OpType.values()) {
            Map<Integer, Set<String>> byName = this.getByName(opType);
            for (String f : evaluator.getOperatorNames(opType)) {
                NutsExpr.Op ff = evaluator.getOperator(f, opType);
                if (ff == null) continue;
                int p = ff.getPrecedence();
                precedences.add(p);
                Set<String> li = byName.get(p);
                if (li == null) {
                    li = new TreeSet<String>();
                    byName.put(p, li);
                }
                li.add(f);
            }
        }
        this.precedences = precedences.stream().mapToInt(Integer::intValue).toArray();
    }

    public NutsExpr getEvaluator() {
        return this.evaluator;
    }

    private Map<Integer, Set<String>> getByName(NutsExpr.OpType opType) {
        return opType == NutsExpr.OpType.PREFIX ? this.prefixOpByName : (opType == NutsExpr.OpType.INFIX ? this.infixOpByName : this.postfixOpByName);
    }

    public boolean isOp(String str, NutsExpr.OpType opType, int precIndex) {
        return str != null && this.getAt(opType, precIndex).contains(str);
    }

    public Set<String> getAt(NutsExpr.OpType opType, int precIndex) {
        Set<String> q;
        if (precIndex < this.precedences.length && (q = this.getByName(opType).get(this.precedences[precIndex])) != null) {
            return q;
        }
        return Collections.emptySet();
    }

    public String toString() {
        return "NutsExprWithCache{evaluator=" + this.evaluator + ", precedences=" + Arrays.toString(this.precedences) + ", prefixOpByName=" + this.prefixOpByName + ", infixOpByName=" + this.infixOpByName + ", postfixOpByName=" + this.postfixOpByName + '}';
    }
}

