/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsExpr;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNutsExpr;

public class DefaultOpNode
implements NutsExpr.Node {
    private final String name;
    private final NutsExpr.Node[] args;
    private final NutsExpr.OpType op;
    private final int precedence;

    public DefaultOpNode(String name, NutsExpr.OpType type, int precedence, NutsExpr.Node[] args) {
        this.op = type;
        this.name = name;
        this.precedence = precedence;
        this.args = args;
    }

    public NutsExpr.Node getArg(int index) {
        if (index >= this.args.length) {
            throw new IllegalArgumentException("Missing argument " + (index + 1) + " for " + this.name);
        }
        return this.args[index];
    }

    public NutsExpr.Node[] getArgs() {
        return this.args;
    }

    public NutsExpr.NodeType getType() {
        return NutsExpr.NodeType.OPERATOR;
    }

    public NutsExpr.Node[] getChildren() {
        return this.args;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        switch (this.op) {
            case PREFIX: {
                return this.name + " " + DefaultNutsExpr.wrapPars(this.args[0]);
            }
            case POSTFIX: {
                return DefaultNutsExpr.wrapPars(this.args[0]) + this.name;
            }
            case INFIX: {
                if (this.args.length == 2) {
                    return DefaultNutsExpr.wrapPars(this.args[0]) + " " + this.name + " " + DefaultNutsExpr.wrapPars(this.args[1]);
                }
                if (this.args.length <= 2) break;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        sb.append(" ").append(this.name).append(" ");
                    }
                    sb.append(DefaultNutsExpr.wrapPars(this.args[i]));
                }
                return sb.toString();
            }
        }
        return this.name + "(" + Arrays.stream(this.args).map(Object::toString).collect(Collectors.joining(",")) + ')';
    }

    public Object eval(NutsExpr context) {
        NutsExpr.Fct f = context.getFunction(this.getName());
        if (f != null) {
            return f.eval(this.getName(), this.getArgs(), context.newChild());
        }
        throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"function not found %s", (Object[])new Object[]{this.getName()}));
    }
}

