/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsExpr;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultLiteralNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultOpNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultVarNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.EvalUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NutsExprWithCache;
import net.thevpc.nuts.runtime.standalone.xtra.expr.OpImpl;
import net.thevpc.nuts.runtime.standalone.xtra.expr.SyntaxParser;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsExpr
implements NutsExpr {
    static final Map<String, NutsExpr.Fct> defaultFunctions = new HashMap<String, NutsExpr.Fct>();
    static final Map<String, NutsExpr.Op> defaultPrefixOps = new HashMap<String, NutsExpr.Op>();
    static final Map<String, NutsExpr.Op> defaultInfixOps = new HashMap<String, NutsExpr.Op>();
    static final Map<String, NutsExpr.Op> defaultPostOps = new HashMap<String, NutsExpr.Op>();
    private final NutsSession session;
    private final Map<String, NutsExpr.Fct> userFunctions = new LinkedHashMap<String, NutsExpr.Fct>();
    private final Map<String, Boolean> userFunctionsFlag = new HashMap<String, Boolean>();
    private final Map<String, NutsExpr.Op> prefixOps = new LinkedHashMap<String, NutsExpr.Op>();
    private final Map<String, Boolean> prefixOpsFlag = new HashMap<String, Boolean>();
    private final Map<String, NutsExpr.Op> infixOps = new LinkedHashMap<String, NutsExpr.Op>();
    private final Map<String, Boolean> infixOpsFlag = new HashMap<String, Boolean>();
    private final Map<String, NutsExpr.Op> postfixOps = new LinkedHashMap<String, NutsExpr.Op>();
    private final Map<String, Boolean> postfixOpsFlag = new HashMap<String, Boolean>();
    private final Map<String, NutsExpr.Var> userVars = new LinkedHashMap<String, NutsExpr.Var>();
    private final Map<String, Boolean> userVarsFlag = new HashMap<String, Boolean>();
    private NutsExpr parent;

    public DefaultNutsExpr(NutsSession session) {
        DefaultNutsExpr.addDefaultOp(new AndFctNode(), "and", "&", "&&");
        DefaultNutsExpr.addDefaultOp(new OrFctNode(), "or", "|", "||");
        DefaultNutsExpr.addDefaultOp(new NotFctNode(), "not", "!");
        DefaultNutsExpr.addDefaultOp(new LTFctNode(), "lt", "<");
        DefaultNutsExpr.addDefaultOp(new LTEFctNode(), "lte", "<=");
        DefaultNutsExpr.addDefaultOp(new GTFctNode(), "gt", ">");
        DefaultNutsExpr.addDefaultOp(new GTEFctNode(), "gte", ">=");
        DefaultNutsExpr.addDefaultOp(new EQFctNode(), "eq", "=", "==");
        DefaultNutsExpr.addDefaultOp(new NEQFctNode(), "neq", "!=", "!==", "<>");
        DefaultNutsExpr.addDefaultOp(new PlusFctNode(), "plus", "+");
        DefaultNutsExpr.addDefaultOp(new MinusFctNode(), "minus", "-");
        DefaultNutsExpr.addDefaultOp(new MulFctNode(), "multiply", "mul", "*");
        DefaultNutsExpr.addDefaultOp(new DivFctNode(), "divide", "div", "/");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return EvalUtils.castToString(o);
            }
        }, "string");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return EvalUtils.castToBoolean(o);
            }
        }, "boolean");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return EvalUtils.castToDouble(o);
            }
        }, "double");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return EvalUtils.castToLong(o);
            }
        }, "long");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return (int)EvalUtils.castToLong(o);
            }
        }, "int");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return Float.valueOf((float)EvalUtils.castToDouble(o));
            }
        }, "float");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return EvalUtils.isNumber(o);
            }
        }, "isNumber");
        DefaultNutsExpr.addDefaultFct(new NutsExpr.Fct(){

            public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
                Object o = args[0].eval(context);
                return EvalUtils.isBoolean(o);
            }
        }, "isBoolean");
        this.session = session;
    }

    public DefaultNutsExpr(NutsExpr parent) {
        DefaultNutsExpr.addDefaultOp(new AndFctNode(), "and", "&", "&&");
        DefaultNutsExpr.addDefaultOp(new OrFctNode(), "or", "|", "||");
        DefaultNutsExpr.addDefaultOp(new NotFctNode(), "not", "!");
        DefaultNutsExpr.addDefaultOp(new LTFctNode(), "lt", "<");
        DefaultNutsExpr.addDefaultOp(new LTEFctNode(), "lte", "<=");
        DefaultNutsExpr.addDefaultOp(new GTFctNode(), "gt", ">");
        DefaultNutsExpr.addDefaultOp(new GTEFctNode(), "gte", ">=");
        DefaultNutsExpr.addDefaultOp(new EQFctNode(), "eq", "=", "==");
        DefaultNutsExpr.addDefaultOp(new NEQFctNode(), "neq", "!=", "!==", "<>");
        DefaultNutsExpr.addDefaultOp(new PlusFctNode(), "plus", "+");
        DefaultNutsExpr.addDefaultOp(new MinusFctNode(), "minus", "-");
        DefaultNutsExpr.addDefaultOp(new MulFctNode(), "multiply", "mul", "*");
        DefaultNutsExpr.addDefaultOp(new DivFctNode(), "divide", "div", "/");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "string");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "boolean");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "double");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "long");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "int");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "float");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "isNumber");
        DefaultNutsExpr.addDefaultFct(new /* invalid duplicate definition of identical inner class */, "isBoolean");
        this.session = parent.getSession();
        this.parent = parent;
    }

    private static void addDefaultFct(NutsExpr.Fct fct, String ... names) {
        for (String name : names) {
            defaultFunctions.put(name, fct);
        }
    }

    private static void addDefaultOp(AbstractOp op, String ... names) {
        for (String name : names) {
            OpImpl opImpl = new OpImpl(name, op.type, op.precedence, op.rightAssociative, op);
            DefaultNutsExpr.getStaticOps(op.type).put(name, opImpl);
        }
    }

    public static String wrapPars(NutsExpr.Node n) {
        if (n instanceof DefaultLiteralNode) {
            String s = n.toString();
            if (s.charAt(0) == '-' || s.charAt(0) == '+') {
                return "(" + s + ")";
            }
            return s;
        }
        if (n instanceof DefaultVarNode) {
            return n.toString();
        }
        if (n instanceof DefaultOpNode) {
            String s = n.toString();
            switch (s.charAt(0)) {
                case '!': 
                case '+': 
                case '-': {
                    return "(" + s + ")";
                }
            }
            return s;
        }
        return "(" + n + ")";
    }

    public static Map<String, NutsExpr.Op> getStaticOps(NutsExpr.OpType type) {
        return type == NutsExpr.OpType.PREFIX ? defaultPrefixOps : (type == NutsExpr.OpType.INFIX ? defaultInfixOps : defaultPostOps);
    }

    public NutsExpr.Node parse(String expression) {
        return new SyntaxParser(expression, this.getEvalWithCache()).parse();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsExpr.Var getVar(String name) {
        NutsExpr.Var f = this.userVars.get(name);
        if (f != null) {
            return f;
        }
        Boolean s = this.userVarsFlag.get(name);
        if (s != null && !s.booleanValue()) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.getVar(name);
        }
        return null;
    }

    public void setFunction(String name, NutsExpr.Fct impl) {
        if (!NutsBlankable.isBlank((String)name)) {
            if (impl == null) {
                if (this.userFunctions.containsKey(name)) {
                    this.userFunctions.remove(name);
                } else {
                    this.userFunctionsFlag.put(name, false);
                }
            } else {
                this.userFunctions.remove(name);
            }
        } else {
            this.userFunctions.put(name, impl);
        }
    }

    public void unsetFunction(String name) {
        this.setFunction(name, null);
    }

    public NutsExpr.Fct getFunction(String name) {
        NutsExpr.Fct f = this.userFunctions.get(name);
        if (f != null) {
            return f;
        }
        Boolean s = this.userFunctionsFlag.get(name);
        if (s != null && !s.booleanValue()) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.getFunction(name);
        }
        return defaultFunctions.get(name);
    }

    public String[] getFunctionNames() {
        LinkedHashSet<Object> all = new LinkedHashSet<Object>();
        for (Map.Entry<String, NutsExpr.Fct> e : this.userFunctions.entrySet()) {
            all.add(e.getKey());
        }
        if (this.parent != null) {
            for (String f : this.parent.getFunctionNames()) {
                Boolean s = this.userFunctionsFlag.get(f);
                if (s != null && !s.booleanValue()) continue;
                all.add(f);
            }
        } else {
            for (String f : defaultFunctions.keySet()) {
                Boolean s = this.userFunctionsFlag.get(f);
                if (s != null && !s.booleanValue()) continue;
                all.add(f);
            }
        }
        return all.toArray(new String[0]);
    }

    public Object evalFunction(String fctName, Object ... args) {
        NutsExpr.Fct f = this.getFunction(fctName);
        if (f == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"function not found %s", (Object[])new Object[]{fctName}));
        }
        return f.eval(fctName, (NutsExpr.Node[])Arrays.stream(args).map(DefaultLiteralNode::new).toArray(NutsExpr.Node[]::new), this.newChild());
    }

    public void setOperator(String name, NutsExpr.OpType type, int precedence, boolean rightAssociative, NutsExpr.Fct fct) {
        if (NutsBlankable.isBlank((String)name)) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"empty operator", (Object[])new Object[0]));
        }
        if (fct == null) {
            NutsExpr.OpType[] allTypes;
            NutsExpr.OpType[] opTypeArray;
            if (type == null) {
                opTypeArray = NutsExpr.OpType.values();
            } else {
                NutsExpr.OpType[] opTypeArray2 = new NutsExpr.OpType[1];
                opTypeArray = opTypeArray2;
                opTypeArray2[0] = type;
            }
            for (NutsExpr.OpType type0 : allTypes = opTypeArray) {
                Map<String, NutsExpr.Op> ops = this.getOps(type0);
                Map<String, Boolean> opsFlag = this.getOpsFlag(type0);
                if (ops.containsKey(name)) {
                    ops.remove(name);
                    continue;
                }
                opsFlag.put(name, false);
            }
        } else {
            if (type == null) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing op type", (Object[])new Object[0]));
            }
            Map<String, NutsExpr.Op> ops = this.getOps(type);
            ops.put(name, new OpImpl(name, type, precedence, rightAssociative, fct));
        }
    }

    public NutsExpr.Op getOperator(String opName, NutsExpr.OpType type) {
        NutsExpr.Op f = this.getOps(type).get(opName);
        if (f != null) {
            return f;
        }
        Boolean b = this.getOpsFlag(type).get(opName);
        if (b != null && !b.booleanValue()) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.getOperator(opName, type);
        }
        return DefaultNutsExpr.getStaticOps(type).get(opName);
    }

    public void unsetOperator(String name, NutsExpr.OpType type) {
        this.setOperator(name, type, -1, false, null);
    }

    public String[] getOperatorNames(NutsExpr.OpType type) {
        if (type == null) {
            LinkedHashSet<String> all = new LinkedHashSet<String>();
            for (NutsExpr.OpType value : NutsExpr.OpType.values()) {
                all.addAll(Arrays.asList(this.getOperatorNames(value)));
            }
            return all.toArray(new String[0]);
        }
        LinkedHashSet<Object> all = new LinkedHashSet<Object>();
        Map<String, NutsExpr.Op> ops = this.getOps(type);
        Map<String, Boolean> opsFlag = this.getOpsFlag(type);
        for (Map.Entry<String, NutsExpr.Op> e : ops.entrySet()) {
            all.add(e.getKey());
        }
        if (this.parent != null) {
            for (String f : this.parent.getFunctionNames()) {
                Boolean s = opsFlag.get(f);
                if (s != null && !s.booleanValue()) continue;
                all.add(f);
            }
        } else {
            for (String f : DefaultNutsExpr.getStaticOps(type).keySet()) {
                Boolean s = opsFlag.get(f);
                if (s != null && !s.booleanValue()) continue;
                all.add(f);
            }
        }
        return all.toArray(new String[0]);
    }

    public void setVar(String name, NutsExpr.Var impl) {
        if (!NutsBlankable.isBlank((String)name)) {
            if (impl == null) {
                if (this.userVars.containsKey(name)) {
                    this.userVars.remove(name);
                } else {
                    this.userVarsFlag.put(name, false);
                }
            } else {
                this.userVars.remove(name);
            }
        } else {
            this.userVars.put(name, impl);
        }
    }

    public Object evalVar(String fctName) {
        NutsExpr.Var f = this.getVar(fctName);
        if (f == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"var not found %s", (Object[])new Object[]{fctName}));
        }
        return f.get(fctName, (NutsExpr)this);
    }

    public NutsExpr newChild() {
        return new DefaultNutsExpr(this);
    }

    public Object evalNode(NutsExpr.Node node) {
        return node.eval((NutsExpr)this);
    }

    private NutsExprWithCache getEvalWithCache() {
        return new NutsExprWithCache(this);
    }

    private Map<String, Boolean> getOpsFlag(NutsExpr.OpType type) {
        return type == NutsExpr.OpType.PREFIX ? this.prefixOpsFlag : (type == NutsExpr.OpType.INFIX ? this.infixOpsFlag : this.postfixOpsFlag);
    }

    private Map<String, NutsExpr.Op> getOps(NutsExpr.OpType type) {
        return type == NutsExpr.OpType.PREFIX ? this.prefixOps : (type == NutsExpr.OpType.INFIX ? this.infixOps : this.postfixOps);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    private class DivFctNode
    extends BinArithFctNode {
        public DivFctNode() {
            super("divide", 120);
        }

        @Override
        protected long evalOrdinal(long a, long b) {
            return a / b;
        }

        @Override
        protected double evalFloat(double a, double b) {
            return a / b;
        }

        @Override
        protected BigDecimal evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.divide(b, RoundingMode.HALF_EVEN);
        }

        @Override
        protected BigInteger evalBigInteger(BigInteger a, BigInteger b) {
            return a.divide(b);
        }
    }

    private class MulFctNode
    extends BinArithFctNode {
        public MulFctNode() {
            super("multiply", 120);
        }

        @Override
        protected long evalOrdinal(long a, long b) {
            return a * b;
        }

        @Override
        protected double evalFloat(double a, double b) {
            return a * b;
        }

        @Override
        protected BigDecimal evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.multiply(b);
        }

        @Override
        protected BigInteger evalBigInteger(BigInteger a, BigInteger b) {
            return a.multiply(b);
        }
    }

    private class MinusFctNode
    extends BinArithFctNode {
        public MinusFctNode() {
            super("minus", 110);
        }

        @Override
        protected long evalOrdinal(long a, long b) {
            return a - b;
        }

        @Override
        protected double evalFloat(double a, double b) {
            return a - b;
        }

        @Override
        protected BigDecimal evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.subtract(b);
        }

        @Override
        protected BigInteger evalBigInteger(BigInteger a, BigInteger b) {
            return a.subtract(b);
        }
    }

    private class PlusFctNode
    extends BinArithFctNode {
        public PlusFctNode() {
            super("plus", 110);
        }

        @Override
        protected long evalOrdinal(long a, long b) {
            return a + b;
        }

        @Override
        protected double evalFloat(double a, double b) {
            return a + b;
        }

        @Override
        protected BigDecimal evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.add(b);
        }

        @Override
        protected BigInteger evalBigInteger(BigInteger a, BigInteger b) {
            return a.add(b);
        }
    }

    private class NEQFctNode
    extends BinCompareFctNode {
        public NEQFctNode() {
            super("neq", 80);
        }

        @Override
        protected boolean evalOrdinal(long a, long b) {
            return a != b;
        }

        @Override
        protected boolean evalFloat(double a, double b) {
            return a != b;
        }

        @Override
        protected boolean evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.compareTo(b) != 0;
        }

        @Override
        protected boolean evalBigInteger(BigInteger a, BigInteger b) {
            return a.compareTo(b) != 0;
        }
    }

    private class EQFctNode
    extends BinCompareFctNode {
        public EQFctNode() {
            super("eq", 80);
        }

        @Override
        protected boolean evalOrdinal(long a, long b) {
            return a == b;
        }

        @Override
        protected boolean evalFloat(double a, double b) {
            return a == b;
        }

        @Override
        protected boolean evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.compareTo(b) == 0;
        }

        @Override
        protected boolean evalBigInteger(BigInteger a, BigInteger b) {
            return a.compareTo(b) == 0;
        }
    }

    private class GTEFctNode
    extends BinCompareFctNode {
        public GTEFctNode() {
            super("gte", 90);
        }

        @Override
        protected boolean evalOrdinal(long a, long b) {
            return a >= b;
        }

        @Override
        protected boolean evalFloat(double a, double b) {
            return a >= b;
        }

        @Override
        protected boolean evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.compareTo(b) >= 0;
        }

        @Override
        protected boolean evalBigInteger(BigInteger a, BigInteger b) {
            return a.compareTo(b) >= 0;
        }
    }

    private class GTFctNode
    extends BinCompareFctNode {
        public GTFctNode() {
            super("gt", 90);
        }

        @Override
        protected boolean evalOrdinal(long a, long b) {
            return a > b;
        }

        @Override
        protected boolean evalFloat(double a, double b) {
            return a > b;
        }

        @Override
        protected boolean evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.compareTo(b) > 0;
        }

        @Override
        protected boolean evalBigInteger(BigInteger a, BigInteger b) {
            return a.compareTo(b) > 0;
        }
    }

    private class LTEFctNode
    extends BinCompareFctNode {
        public LTEFctNode() {
            super("lte", 90);
        }

        @Override
        protected boolean evalOrdinal(long a, long b) {
            return a <= b;
        }

        @Override
        protected boolean evalFloat(double a, double b) {
            return a <= b;
        }

        @Override
        protected boolean evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.compareTo(b) <= 0;
        }

        @Override
        protected boolean evalBigInteger(BigInteger a, BigInteger b) {
            return a.compareTo(b) <= 0;
        }
    }

    private class LTFctNode
    extends BinCompareFctNode {
        public LTFctNode() {
            super("lt", 90);
        }

        @Override
        protected boolean evalOrdinal(long a, long b) {
            return a < b;
        }

        @Override
        protected boolean evalFloat(double a, double b) {
            return a < b;
        }

        @Override
        protected boolean evalBigDecimal(BigDecimal a, BigDecimal b) {
            return a.compareTo(b) < 0;
        }

        @Override
        protected boolean evalBigInteger(BigInteger a, BigInteger b) {
            return a.compareTo(b) < 0;
        }
    }

    private class NotFctNode
    extends AbstractOp {
        public NotFctNode() {
            super("!", 130, true, NutsExpr.OpType.PREFIX);
        }

        public Object eval(String name, NutsExpr.Node[] args, NutsExpr e) {
            return !EvalUtils.castToBoolean(args[0].eval(e));
        }
    }

    private class OrFctNode
    extends AbstractOp {
        public OrFctNode() {
            super("or", 30, false, NutsExpr.OpType.INFIX);
        }

        public Object eval(String name, NutsExpr.Node[] args, NutsExpr e) {
            for (NutsExpr.Node arg : args) {
                if (!EvalUtils.castToBoolean(arg.eval(e))) continue;
                return true;
            }
            return false;
        }
    }

    private class AndFctNode
    extends AbstractOp {
        public AndFctNode() {
            super("&&", 40, false, NutsExpr.OpType.INFIX);
        }

        public Object eval(String name, NutsExpr.Node[] args, NutsExpr context) {
            for (NutsExpr.Node arg : args) {
                if (EvalUtils.castToBoolean(arg.eval(context))) continue;
                return false;
            }
            return true;
        }
    }

    private abstract class AbstractOp
    implements NutsExpr.Fct {
        private final NutsExpr.OpType type;
        private final String name;
        private final int precedence;
        private final boolean rightAssociative;

        public AbstractOp(String name, int precedence, boolean rightAssociative, NutsExpr.OpType type) {
            this.name = name;
            this.type = type;
            this.precedence = precedence;
            this.rightAssociative = rightAssociative;
        }

        public NutsExpr.OpType getOpType() {
            return this.type;
        }

        public int getPrecedence() {
            return this.precedence;
        }
    }

    private abstract class BinArithFctNode
    extends AbstractOp {
        public BinArithFctNode(String name, int precedence) {
            super(name, precedence, false, NutsExpr.OpType.INFIX);
        }

        public Object eval(String name, NutsExpr.Node[] args, NutsExpr e) {
            Object a = args[0].eval(e);
            Object b = args[1].eval(e);
            if (EvalUtils.isNumber(a) && EvalUtils.isNumber(b)) {
                return this.evalAny(EvalUtils.castToNumber(a).doubleValue(), EvalUtils.castToNumber(b).doubleValue());
            }
            if (EvalUtils.isBoolean(a) && EvalUtils.isBoolean(b)) {
                return this.evalAny(EvalUtils.castToNumber(a).doubleValue(), EvalUtils.castToNumber(b).doubleValue());
            }
            String aa = EvalUtils.castToString(a);
            String bb = EvalUtils.castToString(b);
            if (aa == null) {
                aa = "";
            }
            if (bb == null) {
                bb = "";
            }
            return this.evalAny(aa.length(), bb.length());
        }

        protected final Number evalAny(Number a, Number b) {
            if (EvalUtils.isBig(a) || EvalUtils.isBig(b)) {
                if (EvalUtils.isFloat(a) || EvalUtils.isFloat(b)) {
                    BigDecimal aa = a instanceof BigDecimal ? (BigDecimal)a : new BigDecimal(a.toString());
                    BigDecimal bb = b instanceof BigDecimal ? (BigDecimal)b : new BigDecimal(b.toString());
                    return this.evalBigDecimal(aa, bb);
                }
                BigInteger aa = a instanceof BigInteger ? (BigInteger)a : new BigInteger(a.toString());
                BigInteger bb = b instanceof BigInteger ? (BigInteger)b : new BigInteger(b.toString());
                return this.evalBigInteger(aa, bb);
            }
            if (EvalUtils.isFloat(a) || EvalUtils.isFloat(b)) {
                double aa = a.doubleValue();
                double bb = b.doubleValue();
                return this.evalFloat(aa, bb);
            }
            long aa = a.longValue();
            long bb = b.longValue();
            return this.evalOrdinal(aa, bb);
        }

        protected abstract long evalOrdinal(long var1, long var3);

        protected abstract double evalFloat(double var1, double var3);

        protected abstract BigDecimal evalBigDecimal(BigDecimal var1, BigDecimal var2);

        protected abstract BigInteger evalBigInteger(BigInteger var1, BigInteger var2);
    }

    private abstract class BinCompareFctNode
    extends AbstractOp {
        public BinCompareFctNode(String name, int precedence) {
            super(name, precedence, false, NutsExpr.OpType.INFIX);
        }

        public Object eval(String name, NutsExpr.Node[] args, NutsExpr e) {
            Object a = args[0].eval(e);
            Object b = args[1].eval(e);
            if (EvalUtils.isNumber(a) && EvalUtils.isNumber(b)) {
                return this.compare(EvalUtils.castToNumber(a).doubleValue(), EvalUtils.castToNumber(b).doubleValue());
            }
            if (EvalUtils.isBoolean(a) && EvalUtils.isBoolean(b)) {
                return this.compare(EvalUtils.castToNumber(a).doubleValue(), EvalUtils.castToNumber(b).doubleValue());
            }
            String aa = EvalUtils.castToString(a);
            String bb = EvalUtils.castToString(b);
            if (aa == null) {
                aa = "";
            }
            if (bb == null) {
                bb = "";
            }
            return this.compare(aa.length(), bb.length());
        }

        protected final boolean compare(Number a, Number b) {
            if (EvalUtils.isBig(a) || EvalUtils.isBig(b)) {
                if (EvalUtils.isFloat(a) || EvalUtils.isFloat(b)) {
                    BigDecimal aa = a instanceof BigDecimal ? (BigDecimal)a : new BigDecimal(a.toString());
                    BigDecimal bb = b instanceof BigDecimal ? (BigDecimal)b : new BigDecimal(b.toString());
                    return this.evalBigDecimal(aa, bb);
                }
                BigInteger aa = a instanceof BigInteger ? (BigInteger)a : new BigInteger(a.toString());
                BigInteger bb = b instanceof BigInteger ? (BigInteger)b : new BigInteger(b.toString());
                return this.evalBigInteger(aa, bb);
            }
            if (EvalUtils.isFloat(a) || EvalUtils.isFloat(b)) {
                double aa = a.doubleValue();
                double bb = b.doubleValue();
                return this.evalFloat(aa, bb);
            }
            long aa = a.longValue();
            long bb = b.longValue();
            return this.evalOrdinal(aa, bb);
        }

        protected abstract boolean evalOrdinal(long var1, long var3);

        protected abstract boolean evalFloat(double var1, double var3);

        protected abstract boolean evalBigDecimal(BigDecimal var1, BigDecimal var2);

        protected abstract boolean evalBigInteger(BigInteger var1, BigInteger var2);
    }
}

