/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsExpr;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;

public class DefaultFctNode
implements NutsExpr.Node {
    private final String name;
    private final NutsExpr.Node[] args;

    public DefaultFctNode(String name, NutsExpr.Node[] args) {
        this.name = name;
        this.args = args;
    }

    public NutsExpr.Node getArg(int index) {
        if (index >= this.args.length) {
            throw new IllegalArgumentException("Missing argument " + (index + 1) + " for " + this.name);
        }
        return this.args[index];
    }

    public NutsExpr.Node[] getArgs() {
        return this.args;
    }

    public NutsExpr.NodeType getType() {
        return NutsExpr.NodeType.FUNCTION;
    }

    public NutsExpr.Node[] getChildren() {
        return new NutsExpr.Node[0];
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + "(" + Arrays.stream(this.args).map(Object::toString).collect(Collectors.joining(",")) + ')';
    }

    public Object eval(NutsExpr context) {
        NutsExpr.Fct f = context.getFunction(this.getName());
        if (f != null) {
            return f.eval(this.getName(), this.getArgs(), context.newChild());
        }
        throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"function not found %s", (Object[])new Object[]{this.getName()}));
    }
}

