/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.execentries;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsExecutionEntries;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamVisitor;
import net.thevpc.nuts.runtime.standalone.io.util.SimpleClassStream;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.execentries.DefaultNutsExecutionEntry;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsExecutionEntries
implements NutsExecutionEntries {
    private final NutsWorkspace ws;
    private NutsSession session;

    public DefaultNutsExecutionEntries(NutsSession session) {
        this.ws = session.getWorkspace();
        this.session = session;
    }

    public static MainClassType getMainClassType(InputStream stream, NutsSession session) {
        final NutsRef mainClass = new NutsRef();
        final NutsRef nutsApp = new NutsRef();
        final NutsRef nutsAppVer = new NutsRef();
        final NutsRef className = new NutsRef();
        SimpleClassStream.Visitor cl = new SimpleClassStream.Visitor(){

            @Override
            public void visitClassDeclaration(int access, String name, String superName, String[] interfaces) {
                if (superName != null && superName.equals("net/thevpc/nuts/NutsApplication")) {
                    nutsApp.set((Object)true);
                    nutsAppVer.set((Object)"0.8.0");
                } else if (superName != null && superName.equals("net/vpc/app/nuts/NutsApplication")) {
                    nutsApp.set((Object)true);
                    nutsAppVer.set((Object)"0.7.0");
                }
                if (interfaces != null) {
                    for (String anInterface : interfaces) {
                        if (anInterface == null || !anInterface.equals("net/thevpc/nuts/NutsApplication")) continue;
                        nutsApp.set((Object)true);
                        nutsAppVer.set((Object)"0.8.1");
                    }
                }
                className.set((Object)name.replace('/', '.'));
            }

            @Override
            public void visitMethod(int access, String name, String desc) {
                if (name.equals("main") && desc.equals("([Ljava/lang/String;)V") && Modifier.isPublic(access) && Modifier.isStatic(access)) {
                    mainClass.set((Object)true);
                }
            }
        };
        SimpleClassStream classReader = new SimpleClassStream(new BufferedInputStream(stream), cl, session);
        if (mainClass.isSet() || nutsApp.isSet()) {
            return new MainClassType((String)className.get(), mainClass.isSet(), nutsApp.isSet());
        }
        return null;
    }

    public NutsExecutionEntry[] parse(File file) {
        return this.parse(file.toPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsExecutionEntry[] parse(Path file) {
        if (file.getFileName().toString().toLowerCase().endsWith(".jar")) {
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                NutsExecutionEntry[] nutsExecutionEntryArray = this.parse(in, "java", file.toAbsolutePath().normalize().toString());
                return nutsExecutionEntryArray;
            }
            catch (IOException ex) {
                throw new NutsIOException(this.session, (Throwable)ex);
            }
        }
        if (!file.getFileName().toString().toLowerCase().endsWith(".class")) return new NutsExecutionEntry[0];
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            NutsExecutionEntry[] nutsExecutionEntryArray = this.parse(in, "class", file.toAbsolutePath().normalize().toString());
            return nutsExecutionEntryArray;
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public NutsExecutionEntry[] parse(InputStream inputStream, String type, String sourceName) {
        if ("java".equals(type)) {
            return DefaultNutsExecutionEntries.parseJarExecutionEntries(inputStream, sourceName, this.session);
        }
        if ("class".equals(type)) {
            NutsExecutionEntry[] nutsExecutionEntryArray;
            NutsExecutionEntry u = DefaultNutsExecutionEntries.parseClassExecutionEntry(inputStream, sourceName, this.getSession());
            if (u == null) {
                nutsExecutionEntryArray = new NutsExecutionEntry[]{};
            } else {
                NutsExecutionEntry[] nutsExecutionEntryArray2 = new NutsExecutionEntry[1];
                nutsExecutionEntryArray = nutsExecutionEntryArray2;
                nutsExecutionEntryArray2[0] = u;
            }
            return nutsExecutionEntryArray;
        }
        return new NutsExecutionEntry[0];
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsExecutionEntries setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public static NutsExecutionEntry parseClassExecutionEntry(InputStream classStream, String sourceName, NutsSession session) {
        MainClassType mainClass = null;
        try {
            mainClass = DefaultNutsExecutionEntries.getMainClassType(classStream, session);
        }
        catch (Exception ex) {
            NutsLoggerOp.of(CorePlatformUtils.class, (NutsSession)session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"invalid file format {0}", (Object[])new Object[]{sourceName}));
        }
        if (mainClass != null) {
            return new DefaultNutsExecutionEntry(mainClass.getName(), false, mainClass.isApp() && mainClass.isMain());
        }
        return null;
    }

    public static NutsExecutionEntry[] parseJarExecutionEntries(InputStream jarStream, String sourceName, final NutsSession session) {
        if (!(jarStream instanceof BufferedInputStream)) {
            jarStream = new BufferedInputStream(jarStream);
        }
        final ArrayList classes = new ArrayList();
        final ArrayList manifestClass = new ArrayList();
        try {
            ZipUtils.visitZipStream(jarStream, new Predicate<String>(){

                @Override
                public boolean test(String path) {
                    return path.endsWith(".class") || path.equals("META-INF/MANIFEST.MF");
                }
            }, new InputStreamVisitor(){

                @Override
                public boolean visit(String path, InputStream inputStream) throws IOException {
                    if (path.endsWith(".class")) {
                        NutsExecutionEntry mainClass = DefaultNutsExecutionEntries.parseClassExecutionEntry(inputStream, path, session);
                        if (mainClass != null) {
                            classes.add(mainClass);
                        }
                    } else {
                        String v;
                        Manifest manifest = new Manifest(inputStream);
                        Attributes a = manifest.getMainAttributes();
                        if (a != null && a.containsKey("Main-Class") && !NutsBlankable.isBlank((String)(v = a.getValue("Main-Class")))) {
                            manifestClass.add(v);
                        }
                    }
                    return true;
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
        ArrayList<NutsExecutionEntry> entries = new ArrayList<NutsExecutionEntry>();
        String defaultEntry = null;
        if (manifestClass.size() > 0) {
            defaultEntry = (String)manifestClass.get(0);
        }
        boolean defaultFound = false;
        for (NutsExecutionEntry entry : classes) {
            if (defaultEntry != null && defaultEntry.equals(entry.getName())) {
                entries.add(new DefaultNutsExecutionEntry(entry.getName(), true, entry.isApp()));
                defaultFound = true;
                continue;
            }
            entries.add(entry);
        }
        if (defaultEntry != null && !defaultFound) {
            NutsLoggerOp.of(CorePlatformUtils.class, (NutsSession)session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)("invalid default entry " + defaultEntry + " in " + sourceName), (Object[])new Object[0]));
        }
        return entries.toArray(new NutsExecutionEntry[0]);
    }

    public static class MainClassType {
        private final String name;
        private final boolean app;
        private final boolean main;

        public MainClassType(String name, boolean main, boolean app) {
            this.name = name;
            this.app = app;
            this.main = main;
        }

        public String getName() {
            return this.name;
        }

        public boolean isApp() {
            return this.app;
        }

        public boolean isMain() {
            return this.main;
        }
    }
}

