/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.download;

import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.standalone.io.SimpleHttpClient;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.spi.NutsTransportComponent;
import net.thevpc.nuts.spi.NutsTransportConnection;
import net.thevpc.nuts.spi.NutsTransportParamPart;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class DefaultHttpTransportComponent
implements NutsTransportComponent {
    public static final NutsTransportComponent INSTANCE = new DefaultHttpTransportComponent();
    private NutsSession session;

    public int getSupportLevel(NutsSupportLevelContext url) {
        this.session = url.getSession();
        return 10;
    }

    public NutsTransportConnection open(String url) throws UncheckedIOException {
        try {
            return new DefaultNutsTransportConnection(new URL(url), this.session);
        }
        catch (MalformedURLException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    private static class DefaultNutsTransportConnection
    implements NutsTransportConnection {
        private final URL url;
        private final NutsSession session;

        public DefaultNutsTransportConnection(URL url, NutsSession session) {
            this.url = url;
            this.session = session;
        }

        public InputStream open() {
            return new SimpleHttpClient(this.url, this.session).openStream();
        }

        public NutsPath getPath() {
            return NutsPath.of((URL)this.url, (NutsSession)this.session);
        }

        public InputStream upload(NutsTransportParamPart ... parts) {
            throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"upload unsupported", (Object[])new Object[0]));
        }

        public String toString() {
            return String.valueOf(this.url);
        }
    }
}

