/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.digest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;

public class NutsDigestUtils {
    public static byte[] evalMD5(String input, NutsSession session) {
        byte[] bytesOfMessage = input.getBytes(StandardCharsets.UTF_8);
        return NutsDigestUtils.evalMD5(bytesOfMessage, session);
    }

    public static String evalMD5Hex(Path path, NutsSession session) {
        return NutsUtilStrings.toHexString((byte[])NutsDigestUtils.evalMD5(path, session));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] evalMD5(Path path, NutsSession session) {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            byte[] byArray = NutsDigestUtils.evalMD5(is, session);
            return byArray;
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    public static String evalMD5Hex(InputStream input, NutsSession session) {
        return NutsUtilStrings.toHexString((byte[])NutsDigestUtils.evalMD5(input, session));
    }

    public static byte[] evalHash(InputStream input, String algo, NutsSession session) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    md.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NutsIOException(session, (Throwable)new IOException(e));
        }
    }

    public static byte[] evalMD5(InputStream input, NutsSession session) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    md.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    public static byte[] evalMD5(byte[] bytesOfMessage, NutsSession session) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytesOfMessage);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String evalSHA1Hex(NutsPath file, NutsSession session) {
        try (InputStream is = file.getInputStream();){
            String string = NutsDigestUtils.evalSHA1Hex(is, true, session);
            return string;
        }
        catch (IOException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    public static String evalSHA1(File file, NutsSession session) {
        try {
            return NutsDigestUtils.evalSHA1Hex(new FileInputStream(file), true, session);
        }
        catch (FileNotFoundException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    public static char[] evalSHA1(char[] input, NutsSession session) {
        byte[] bytes = CoreIOUtils.charsToBytes(input);
        char[] r = NutsDigestUtils.evalSHA1HexChars(new ByteArrayInputStream(bytes), true, session);
        Arrays.fill(bytes, (byte)0);
        return r;
    }

    public static String evalSHA1(String input, NutsSession session) {
        return NutsDigestUtils.evalSHA1Hex(new ByteArrayInputStream(input.getBytes()), true, session);
    }

    public static String evalSHA1Hex(InputStream input, boolean closeStream, NutsSession session) {
        return NutsUtilStrings.toHexString((byte[])NutsDigestUtils.evalSHA1(input, closeStream, session));
    }

    public static char[] evalSHA1HexChars(InputStream input, boolean closeStream, NutsSession session) {
        return NutsUtilStrings.toHexString((byte[])NutsDigestUtils.evalSHA1(input, closeStream, session)).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] evalSHA1(InputStream input, boolean closeStream, NutsSession session) {
        try {
            MessageDigest sha1 = null;
            try {
                sha1 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new NutsIOException(session, (Throwable)ex);
            }
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    sha1.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
            byte[] byArray = sha1.digest();
            return byArray;
        }
        finally {
            if (closeStream && input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    throw new NutsIOException(session, (Throwable)ex);
                }
            }
        }
    }
}

