/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.digest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDigest;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NutsDigestUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsDigest
implements NutsDigest {
    private final NutsWorkspace ws;
    private NutsStreamOrPath source;
    private String algorithm;
    private NutsSession session;

    public DefaultNutsDigest(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public NutsDigest setSource(InputStream source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.session);
        return this;
    }

    public NutsDigest setSource(File source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.getSession());
        return this;
    }

    public NutsDigest setSource(Path source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.getSession());
        return this;
    }

    public NutsDigest setSource(NutsPath source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source);
        return this;
    }

    public NutsDigest setSource(byte[] source) {
        this.checkSession();
        this.source = source == null ? null : NutsStreamOrPath.ofAnyInputOrNull(new ByteArrayInputStream(source), this.session);
        return null;
    }

    public NutsDigest setSource(NutsDescriptor source) {
        this.checkSession();
        this.source = source == null ? null : NutsStreamOrPath.ofSpecial(source, NutsStreamOrPath.Type.DESCRIPTOR, this.session);
        return this;
    }

    public String computeString() {
        return NutsUtilStrings.toHexString((byte[])this.computeBytes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] computeBytes() {
        if (this.source == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing Source", (Object[])new Object[0]));
        }
        this.checkSession();
        switch (this.source.getType()) {
            case INPUT_STREAM: {
                return NutsDigestUtils.evalHash(this.source.getInputStream(), this.getValidAlgo(), this.session);
            }
            case PATH: {
                try (BufferedInputStream is = new BufferedInputStream(this.source.getInputStream());){
                    byte[] byArray = NutsDigestUtils.evalHash(is, this.getValidAlgo(), this.session);
                    return byArray;
                }
                catch (IOException ex) {
                    throw new NutsIOException(this.session, (Throwable)ex);
                }
            }
            case DESCRIPTOR: {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                ((NutsDescriptor)this.source.getValue()).formatter().setSession(this.session).compact().setSession(this.session).print((Writer)new OutputStreamWriter(o));
                try (ByteArrayInputStream is = new ByteArrayInputStream(o.toByteArray());){
                    byte[] byArray = NutsDigestUtils.evalHash(is, this.getValidAlgo(), this.session);
                    return byArray;
                }
                catch (IOException ex) {
                    throw new NutsIOException(this.session, (Throwable)ex);
                }
            }
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported type %s", (Object[])new Object[]{this.source.getType()}));
    }

    public NutsDigest writeHash(OutputStream out) {
        try {
            out.write(this.computeBytes());
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
        return this;
    }

    public NutsDigest md5() {
        return this.setAlgorithm("MD5");
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsDigest setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public NutsDigest sha1() {
        return this.setAlgorithm("SHA1");
    }

    public NutsDigest sha256() {
        return this.setAlgorithm("SHA256");
    }

    public NutsDigest algorithm(String algorithm) {
        return this.setAlgorithm(algorithm);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public NutsDigest setAlgorithm(String algorithm) {
        if (NutsBlankable.isBlank((String)algorithm)) {
            algorithm = null;
        }
        try {
            MessageDigest.getInstance(algorithm);
            this.algorithm = algorithm;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve algo: %s", (Object[])new Object[]{algorithm}), (Throwable)ex);
        }
        return this;
    }

    protected String getValidAlgo() {
        if (this.algorithm == null) {
            return "SHA1";
        }
        return this.algorithm;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

