/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.cp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsIOCopyValidationException;
import net.thevpc.nuts.NutsIOCopyValidator;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsProgressEvent;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.progress.DefaultNutsProgressEvent;
import net.thevpc.nuts.runtime.standalone.io.progress.NutsProgressUtils;
import net.thevpc.nuts.runtime.standalone.io.progress.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.InterruptException;
import net.thevpc.nuts.runtime.standalone.io.util.Interruptible;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.cp.MiddleTransferException;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsCp
implements NutsCp {
    private final NutsWorkspace ws;
    private NutsLogger LOG;
    private NutsIOCopyValidator checker;
    private boolean skipRoot = false;
    private int maxRepeatCount = 3;
    private NutsStreamOrPath source;
    private NutsStreamOrPath target;
    private NutsSession session;
    private NutsProgressFactory progressMonitorFactory;
    private boolean interrupted;
    private boolean recursive;
    private boolean mkdirs;
    private Interruptible interruptibleInstance;
    private Object sourceOrigin;
    private String sourceTypeName;
    private NutsMessage actionMessage;
    private Set<NutsPathOption> options = new LinkedHashSet<NutsPathOption>();

    public DefaultNutsCp(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    private static Path transformPath(Path f, Path sourceBase, Path targetBase) {
        String bs;
        String fs = f.toString();
        if (fs.startsWith(bs = sourceBase.toString())) {
            String relative = fs.substring(bs.length());
            if (!relative.startsWith(File.separator)) {
                relative = File.separator + relative;
            }
            String x = targetBase + relative;
            return Paths.get(x, new String[0]);
        }
        throw new RuntimeException("Invalid path " + f);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsCp.class, (NutsSession)session);
        }
        return this.LOG;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public Object getSource() {
        return this.source;
    }

    public NutsCp setSource(NutsPath source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source);
        return this;
    }

    public NutsCp setSource(InputStream source) {
        this.checkSession();
        this.source = source == null ? null : NutsStreamOrPath.of(source, this.session);
        return this;
    }

    public NutsCp setSource(File source) {
        this.checkSession();
        this.source = source == null ? null : NutsStreamOrPath.of(NutsPath.of((File)source, (NutsSession)this.session));
        return this;
    }

    public NutsCp setSource(Path source) {
        this.source = source == null ? null : NutsStreamOrPath.of(NutsPath.of((Path)source, (NutsSession)this.session));
        return this;
    }

    public NutsCp setSource(URL source) {
        this.source = source == null ? null : NutsStreamOrPath.of(NutsPath.of((URL)source, (NutsSession)this.session));
        return this;
    }

    public NutsCp setSource(String source) {
        this.source = source == null ? null : NutsStreamOrPath.of(NutsPath.of((String)source, (NutsSession)this.session));
        return this;
    }

    public NutsCp setSource(byte[] source) {
        this.checkSession();
        this.source = source == null ? null : NutsStreamOrPath.of(new ByteArrayInputStream(source), this.session);
        return this;
    }

    public NutsCp from(String source) {
        this.source = source == null ? null : NutsStreamOrPath.of(NutsPath.of((String)source, (NutsSession)this.session));
        return this;
    }

    public NutsCp from(NutsPath source) {
        this.source = source == null ? null : NutsStreamOrPath.of(source);
        return this;
    }

    public NutsCp from(InputStream source) {
        return this.setSource(source);
    }

    public NutsCp from(File source) {
        return this.setSource(source);
    }

    public NutsCp from(Path source) {
        return this.setSource(source);
    }

    public NutsCp from(URL source) {
        return this.setSource(source);
    }

    public NutsCp from(byte[] source) {
        return this.setSource(source);
    }

    public Object getTarget() {
        return this.target;
    }

    public NutsCp setTarget(OutputStream target) {
        this.checkSession();
        this.target = target == null ? null : NutsStreamOrPath.ofAnyOutputOrErr(target, this.session);
        return this;
    }

    public NutsCp setTarget(NutsPrintStream target) {
        this.target = target == null ? null : NutsStreamOrPath.ofAnyOutputOrErr(target, this.session);
        return this;
    }

    public NutsCp setTarget(NutsPath target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target);
        return this;
    }

    public NutsCp setTarget(Path target) {
        this.target = target == null ? null : NutsStreamOrPath.of(NutsPath.of((Path)target, (NutsSession)this.session));
        return this;
    }

    public NutsCp setTarget(String target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target, this.session);
        return this;
    }

    public NutsCp setTarget(File target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target, this.session);
        return this;
    }

    public NutsCp to(OutputStream target) {
        return this.setTarget(target);
    }

    public NutsCp to(NutsPrintStream target) {
        return this.setTarget(target);
    }

    public NutsCp to(String target) {
        return this.setTarget(target);
    }

    public NutsCp to(Path target) {
        return this.setTarget(target);
    }

    public NutsCp to(File target) {
        return this.setTarget(target);
    }

    public NutsCp to(NutsPath target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target);
        return this;
    }

    public NutsCp addOptions(NutsPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NutsPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.add(o);
            }
        }
        return this;
    }

    public NutsCp removeOptions(NutsPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NutsPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.remove(o);
            }
        }
        return this;
    }

    public NutsCp clearOptions() {
        this.options.clear();
        return this;
    }

    public Set<NutsPathOption> getOptions() {
        return new LinkedHashSet<NutsPathOption>(this.options);
    }

    public NutsIOCopyValidator getValidator() {
        return this.checker;
    }

    public DefaultNutsCp setValidator(NutsIOCopyValidator checker) {
        this.checker = checker;
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public NutsCp setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isMkdirs() {
        return this.mkdirs;
    }

    public NutsCp setMkdirs(boolean mkdirs) {
        this.mkdirs = mkdirs;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsCp setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public byte[] getByteArrayResult() {
        this.checkSession();
        NutsMemoryPrintStream b = NutsPrintStream.ofInMemory((NutsSession)this.session);
        this.to((NutsPrintStream)b);
        this.removeOptions(NutsPathOption.SAFE);
        this.run();
        return b.getBytes();
    }

    public NutsCp run() {
        this.checkSession();
        NutsStreamOrPath _source = this.source;
        if (_source == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"missing source"));
        }
        if (this.target == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"missing target"));
        }
        if (_source.isPath() && _source.getPath().isDirectory()) {
            if (!this.target.isPath()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported copy of directory to %s", (Object[])new Object[]{this.target}));
            }
            Path fromPath = _source.getPath().toFile();
            Path toPath = this.target.getPath().toFile();
            CopyData cd = new CopyData();
            if (this.options.contains(NutsPathOption.LOG) || this.options.contains(NutsPathOption.TRACE) || this.getProgressFactory() != null) {
                this.prepareCopyFolder(fromPath, cd);
                this.copyFolderWithMonitor(fromPath, toPath, cd);
            } else {
                this.copyFolderNoMonitor(fromPath, toPath, cd);
            }
            return this;
        }
        this.copyStream();
        return this;
    }

    public NutsProgressFactory getProgressFactory() {
        return this.progressMonitorFactory;
    }

    public NutsCp setProgressFactory(NutsProgressFactory value) {
        this.progressMonitorFactory = value;
        return this;
    }

    public NutsCp setProgressMonitor(NutsProgressMonitor value) {
        this.progressMonitorFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    public NutsCp setSkipRoot(boolean skipRoot) {
        this.skipRoot = skipRoot;
        return this;
    }

    public NutsCp interrupt() {
        if (this.interruptibleInstance != null) {
            this.interruptibleInstance.interrupt();
        }
        this.interrupted = true;
        return this;
    }

    public Object getSourceOrigin() {
        return this.sourceOrigin;
    }

    public NutsCp setSourceOrigin(Object sourceOrigin) {
        this.sourceOrigin = sourceOrigin;
        return this;
    }

    public NutsMessage getActionMessage() {
        return this.actionMessage;
    }

    public DefaultNutsCp setActionMessage(NutsMessage actionMessage) {
        this.actionMessage = actionMessage;
        return this;
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public NutsCp setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
        return this;
    }

    private void checkInterrupted() {
        if (this.interrupted) {
            throw new NutsIOException(this.session, (Throwable)new InterruptException());
        }
    }

    private void prepareCopyFolder(Path d, final CopyData f) {
        try {
            Files.walkFileTree(d, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    DefaultNutsCp.this.checkInterrupted();
                    ++f.folders;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    DefaultNutsCp.this.checkInterrupted();
                    ++f.files;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    DefaultNutsCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    DefaultNutsCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new NutsIOException(this.session, (Throwable)exc);
        }
    }

    private void copyFolderWithMonitor(final Path srcBase, final Path targetBase, final CopyData f) {
        this.checkSession();
        final NutsSession session = this.getSession();
        final long start = System.currentTimeMillis();
        Object origin = this.getSourceOrigin();
        final NutsProgressMonitor m = NutsProgressUtils.createProgressMonitor(NutsProgressUtils.MonitorType.DEFAULT, srcBase, origin, session, this.options.contains(NutsPathOption.LOG), this.options.contains(NutsPathOption.TRACE), this.getProgressFactory());
        final NutsText srcBaseMessage = NutsTexts.of((NutsSession)session).toText((Object)srcBase);
        m.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, 0L, 0L, 0L, 0L, f.files + f.folders, null, session, false));
        try {
            final NutsSession finalSession = session;
            Files.walkFileTree(srcBase, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsCp.this.checkInterrupted();
                    ++f.doneFolders;
                    NutsPath.of((Path)DefaultNutsCp.transformPath(dir, srcBase, targetBase), (NutsSession)session).mkdirs();
                    m.onProgress((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, f.doneFiles + f.doneFolders, System.currentTimeMillis() - start, 0L, 0L, f.files + f.folders, null, finalSession, false));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsCp.this.checkInterrupted();
                    ++f.doneFiles;
                    DefaultNutsCp.this.copy(file, DefaultNutsCp.transformPath(file, srcBase, targetBase), (Set<NutsPathOption>)DefaultNutsCp.this.options);
                    m.onProgress((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, f.doneFiles + f.doneFolders, System.currentTimeMillis() - start, 0L, 0L, f.files + f.folders, null, finalSession, false));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    DefaultNutsCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    DefaultNutsCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new NutsIOException(session, (Throwable)exc);
        }
        finally {
            m.onComplete((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, f.files + f.folders, System.currentTimeMillis() - start, 0L, 0L, f.files + f.folders, null, session, false));
        }
    }

    public Path copy(Path source, Path target, Set<NutsPathOption> options) throws IOException {
        if (options.contains(NutsPathOption.INTERRUPTIBLE)) {
            if (Files.exists(target, new LinkOption[0]) && !options.contains(NutsPathOption.REPLACE_EXISTING)) {
                return null;
            }
            try (InputStream in = CoreIOUtils.toInterruptible(Files.newInputStream(source, new OpenOption[0]));){
                this.interruptibleInstance = (Interruptible)((Object)in);
                try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                    this.transferTo(in, out);
                }
            }
            return target;
        }
        return Files.copy(source, target, CoreIOUtils.asCopyOptions(options).toArray(new CopyOption[0]));
    }

    public long copy(InputStream in, Path target, Set<NutsPathOption> options) throws IOException {
        if (options.contains(NutsPathOption.INTERRUPTIBLE)) {
            in = CoreIOUtils.toInterruptible(in);
            this.interruptibleInstance = (Interruptible)((Object)in);
            try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                long l = this.transferTo(in, out);
                return l;
            }
        }
        return Files.copy(in, target, CoreIOUtils.asCopyOptions(options).toArray(new CopyOption[0]));
    }

    public long copy(InputStream in, OutputStream out, Set<NutsPathOption> options) throws IOException {
        if (options.contains(NutsPathOption.INTERRUPTIBLE)) {
            in = CoreIOUtils.toInterruptible(in);
            this.interruptibleInstance = (Interruptible)((Object)in);
            return this.transferTo(in, out);
        }
        return CoreIOUtils.copy(in, out, this.session);
    }

    public long copy(Path source, OutputStream out) throws IOException {
        if (this.options.contains(NutsPathOption.INTERRUPTIBLE)) {
            Throwable throwable = null;
            try (InputStream in = CoreIOUtils.toInterruptible(Files.newInputStream(source, new OpenOption[0]));){
                this.interruptibleInstance = (Interruptible)((Object)in);
                try {
                    long l = this.transferTo(in, out);
                    return l;
                }
                catch (IOException ex) {
                    try {
                        throw new MiddleTransferException(ex);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        return Files.copy(source, out);
    }

    private long transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        int DEFAULT_BUFFER_SIZE = 8192;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        while ((read = in.read(buffer, 0, DEFAULT_BUFFER_SIZE)) >= 0) {
            this.checkInterrupted();
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    private void copyFolderNoMonitor(final Path srcBase, final Path targetBase, final CopyData f) {
        try {
            Files.walkFileTree(srcBase, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsCp.this.checkInterrupted();
                    ++f.doneFolders;
                    NutsPath.of((Path)DefaultNutsCp.transformPath(dir, srcBase, targetBase), (NutsSession)DefaultNutsCp.this.session).mkdirs();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsCp.this.checkInterrupted();
                    ++f.doneFiles;
                    DefaultNutsCp.this.copy(file, DefaultNutsCp.transformPath(file, srcBase, targetBase), (Set<NutsPathOption>)DefaultNutsCp.this.options);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    DefaultNutsCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    DefaultNutsCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new NutsIOException(this.session, (Throwable)exc);
        }
    }

    private void copyStream() {
        this.checkSession();
        NutsStreamOrPath _source = this.source;
        if (_source == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.plain((String)"missing source"));
        }
        if (this.target == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.plain((String)"missing target"));
        }
        boolean safe = this.options.contains(NutsPathOption.SAFE);
        if (safe) {
            this.copyStreamSafe(this.source, this.target);
        } else {
            this.copyStreamOnce(this.source, this.target);
        }
    }

    private void copyStreamSafe(NutsStreamOrPath source, NutsStreamOrPath target) {
        if (source.isMultiRead()) {
            this.copyStreamMulti(source, target);
        } else {
            this.copyStreamOnce(source, target);
        }
    }

    private void copyStreamMulti(NutsStreamOrPath source, NutsStreamOrPath target) {
        int repeatCount = 1;
        int maxRepeatCount = this.maxRepeatCount;
        if (maxRepeatCount < 1) {
            maxRepeatCount = 3;
        }
        for (int i = repeatCount; i <= maxRepeatCount; ++i) {
            try {
                NutsLoggerOp lop = this._LOGOP(this.session);
                if (i > 1 && lop.isLoggable(Level.FINEST)) {
                    lop.level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"repeat download #{0} {1}", (Object[])new Object[]{i, source}));
                }
                this.copyStreamOnce(source, target);
                return;
            }
            catch (NutsIOException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SocketException || cause instanceof SocketTimeoutException || cause instanceof MiddleTransferException) continue;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStreamOnce(NutsStreamOrPath source, NutsStreamOrPath target) {
        block130: {
            NutsLoggerOp lop;
            NutsStreamOrPath _source = source;
            if (_source == null) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.plain((String)"missing source"));
            }
            if (target == null) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.plain((String)"missing target"));
            }
            boolean _target_isPath = target.isPath() && target.getPath().isFile();
            boolean safe = this.options.contains(NutsPathOption.SAFE);
            if (this.checker != null && !_target_isPath && !safe) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"unsupported validation if neither safeCopy is armed nor path is defined"));
            }
            NutsString loggedSrc = _source.getStreamMetaData().getFormattedPath();
            NutsString loggedTarget = target.getStreamMetaData().getFormattedPath();
            NutsMessage m = this.getActionMessage();
            if (m == null) {
                m = NutsMessage.plain((String)"copy");
            }
            if (this.options.contains(NutsPathOption.LOG)) {
                this.session.getTerminal().printProgress("%-14s %s to %s", new Object[]{m, loggedSrc, loggedTarget});
            }
            if (this.options.contains(NutsPathOption.LOG) || this.options.contains(NutsPathOption.TRACE) || this.getProgressFactory() != null) {
                NutsInputStreamMonitor monitor = NutsInputStreamMonitor.of((NutsSession)this.session);
                if (_source.isInputStream()) {
                    InputStream inputStream = _source.getInputStream();
                    monitor.setSource(inputStream);
                } else {
                    monitor.setSource(_source.getPath());
                }
                monitor.setLogProgress(this.options.contains(NutsPathOption.LOG));
                monitor.setTraceProgress(this.options.contains(NutsPathOption.TRACE));
                monitor.setOrigin(this.getSourceOrigin());
                monitor.setSourceTypeName(this.getSourceTypeName());
                _source = NutsStreamOrPath.ofAnyInputOrErr(monitor.setProgressFactory(this.getProgressFactory()).setLogProgress(this.options.contains(NutsPathOption.LOG)).create(), this.session);
            }
            if ((lop = this._LOGOP(this.session)).isLoggable(Level.FINEST)) {
                lop.level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"{0} {1} to {2}", (Object[])new Object[]{m, loggedSrc, loggedTarget}));
            }
            try {
                if (safe) {
                    Throwable throwable;
                    Path temp = null;
                    if (_target_isPath) {
                        Path to = target.getPath().toFile();
                        NutsPath.of((Path)to, (NutsSession)this.session).mkParentDirs();
                        temp = to.resolveSibling(to.getFileName() + "~");
                    } else {
                        temp = NutsTmp.of((NutsSession)this.getSession()).createTempFile("temp~").toFile();
                    }
                    if (_source.isPath() && _source.getPath().isFile()) {
                        this.copy(_source.getPath().toFile(), temp, new HashSet<NutsPathOption>(Collections.singletonList(NutsPathOption.REPLACE_EXISTING)));
                    } else {
                        throwable = null;
                        try (InputStream ins = _source.getInputStream();){
                            this.copy(ins, temp, new HashSet<NutsPathOption>(Collections.singletonList(NutsPathOption.REPLACE_EXISTING)));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    this._validate(temp);
                    if (_target_isPath) {
                        try {
                            Files.move(temp, target.getPath().toFile(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (FileSystemException e) {
                            if (CoreIOUtils.compareContent(temp, target.getPath().toFile(), this.session)) {
                                if (temp != null && Files.exists(temp, new LinkOption[0])) {
                                    Files.delete(temp);
                                }
                                return;
                            }
                            throw e;
                        }
                        temp = null;
                        break block130;
                    }
                    OutputStream ops = target.getOutputStream();
                    throwable = null;
                    try {
                        this.copy(temp, ops);
                        break block130;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (temp != null && Files.exists(temp, new LinkOption[0])) {
                            Files.delete(temp);
                        }
                    }
                }
                if (_target_isPath) {
                    Path to = target.getPath().toFile();
                    NutsPath.of((Path)to, (NutsSession)this.session).mkParentDirs();
                    if (_source.isPath() && _source.getPath().isFile()) {
                        this.copy(_source.getPath().toFile(), to, new HashSet<NutsPathOption>(Collections.singletonList(NutsPathOption.REPLACE_EXISTING)));
                    } else {
                        try (InputStream ins = _source.getInputStream();){
                            this.copy(ins, to, new HashSet<NutsPathOption>(Collections.singletonList(NutsPathOption.REPLACE_EXISTING)));
                        }
                    }
                    this._validate(to);
                    break block130;
                }
                ByteArrayOutputStream bos = null;
                if (this.checker != null) {
                    Throwable throwable;
                    bos = new ByteArrayOutputStream();
                    if (_source.isPath() && _source.getPath().isFile()) {
                        this.copy(_source.getPath().toFile(), bos);
                    } else {
                        throwable = null;
                        try (InputStream ins = _source.getInputStream();){
                            this.copy(ins, bos, this.options);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                    throwable = null;
                    try (OutputStream ops = target.getOutputStream();){
                        this.copy((InputStream)new ByteArrayInputStream(bos.toByteArray()), ops, this.options);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    this._validate(bos.toByteArray());
                    break block130;
                }
                if (_source.isPath() && _source.getPath().isFile()) {
                    try (OutputStream ops = target.getOutputStream();){
                        this.copy(_source.getPath().toFile(), ops);
                        break block130;
                    }
                }
                try (InputStream ins = _source.getInputStream();
                     OutputStream ops = target.getOutputStream();){
                    this.copy(ins, ops, this.options);
                }
            }
            catch (IOException ex) {
                lop.level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error copying {0} to {1} : {2}", (Object[])new Object[]{_source.getValue(), target.getValue(), ex}));
                throw new NutsIOException(this.session, (Throwable)ex);
            }
        }
    }

    private void _validate(Path temp) {
        if (this.checker != null) {
            try (InputStream in = Files.newInputStream(temp, new OpenOption[0]);){
                this.checker.validate(in);
            }
            catch (NutsIOCopyValidationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NutsIOCopyValidationException(this.session, NutsMessage.cstyle((String)"validate file %s failed", (Object[])new Object[]{temp}), (Throwable)ex);
            }
        }
    }

    private void _validate(byte[] temp) {
        if (this.checker != null) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(temp);){
                this.checker.validate((InputStream)in);
            }
            catch (NutsIOCopyValidationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NutsIOCopyValidationException(this.session, NutsMessage.cstyle((String)"validate file failed", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    private static class CopyData {
        long files;
        long folders;
        long doneFiles;
        long doneFolders;

        private CopyData() {
        }
    }
}

