/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.contenttype;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import net.thevpc.nuts.NutsContentTypes;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsContentTypeResolver;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsContentTypes
implements NutsContentTypes {
    private final NutsSession session;
    private NutsWorkspace ws;

    public DefaultNutsContentTypes(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public String probeContentType(Path path) {
        return this.probeContentType(path == null ? null : NutsPath.of((Path)path, (NutsSession)this.session));
    }

    public String probeContentType(File path) {
        return this.probeContentType(path == null ? null : NutsPath.of((File)path, (NutsSession)this.session));
    }

    public String probeContentType(URL path) {
        return this.probeContentType(path == null ? null : NutsPath.of((URL)path, (NutsSession)this.session));
    }

    public String probeContentType(NutsPath path) {
        List allSupported = this.session.extensions().createAllSupported(NutsContentTypeResolver.class, (Object)path);
        NutsSupported best = null;
        for (NutsContentTypeResolver r : allSupported) {
            NutsSupported s = r.probeContentType(path, this.session);
            if (s == null || !s.isValid() || best != null && s.getSupportLevel() <= best.getSupportLevel()) continue;
            best = s;
        }
        if (best == null) {
            return null;
        }
        return (String)best.getValue();
    }

    public String probeContentType(InputStream stream) {
        byte[] buffer = CoreIOUtils.readBestEffort(4096, stream, this.session);
        return this.probeContentType(buffer);
    }

    public String probeContentType(byte[] bytes) {
        List allSupported = this.session.extensions().createAllSupported(NutsContentTypeResolver.class, (Object)bytes);
        NutsSupported best = null;
        for (NutsContentTypeResolver r : allSupported) {
            NutsSupported s = r.probeContentType(bytes, this.session);
            if (s == null || !s.isValid() || best != null && s.getSupportLevel() <= best.getSupportLevel()) continue;
            best = s;
        }
        if (best == null) {
            return null;
        }
        return (String)best.getValue();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

