/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.contenttype;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.spi.NutsContentTypeResolver;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsContentTypeResolver
implements NutsContentTypeResolver {
    public NutsSupported<String> probeContentType(NutsPath path, NutsSession session) {
        String contentType = null;
        if (path != null) {
            Path file;
            if (path.isFile() && (file = path.asFile()) != null) {
                try {
                    contentType = Files.probeContentType(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (contentType == null) {
                URL url = path.asURL();
                try {
                    contentType = url.openConnection().getContentType();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (contentType == null) {
                String e;
                String name = path.getName();
                try {
                    contentType = URLConnection.guessContentTypeFromName(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((contentType == null || "text/plain".equals(contentType)) && (e = NutsPath.of((Path)Paths.get(name, new String[0]), (NutsSession)session).getLastExtension()) != null && e.equalsIgnoreCase("ntf")) {
                    return NutsSupported.of((int)20, (Object)"text/x-nuts-text-format");
                }
                if ((contentType == null || "text/plain".equals(contentType)) && (e = NutsPath.of((Path)Paths.get(name, new String[0]), (NutsSession)session).getLastExtension()) != null && e.equalsIgnoreCase("nuts")) {
                    return NutsSupported.of((int)20, (Object)"application/json");
                }
            }
            if (contentType != null) {
                return NutsSupported.of((int)10, (Object)contentType);
            }
        }
        return NutsSupported.invalid();
    }

    public NutsSupported<String> probeContentType(byte[] bytes, NutsSession session) {
        String contentType = null;
        if (bytes != null) {
            try {
                contentType = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(bytes));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (contentType != null) {
            return NutsSupported.of((int)10, contentType);
        }
        return NutsSupported.invalid();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

