/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.compress;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCompress;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.progress.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.NutsStreamOrPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsCompress
implements NutsCompress {
    private final List<NutsStreamOrPath> sources = new ArrayList<NutsStreamOrPath>();
    private final NutsWorkspace ws;
    private NutsLogger LOG;
    private boolean safe = true;
    private NutsStreamOrPath target;
    private NutsSession session;
    private boolean skipRoot;
    private NutsProgressFactory progressFactory;
    private String format = "zip";
    private Set<NutsPathOption> options = new LinkedHashSet<NutsPathOption>();

    public DefaultNutsCompress(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    private static String concatPath(String a, String b) {
        if (a.endsWith("/")) {
            if (b.startsWith("/")) {
                return a + b.substring(1);
            }
            return a + b;
        }
        if (b.startsWith("/")) {
            return a + b;
        }
        return a + "/" + b;
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsCompress.class, (NutsSession)session);
        }
        return this.LOG;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runZip() {
        block47: {
            this.checkSession();
            if (this.sources.isEmpty()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing source", (Object[])new Object[0]));
            }
            if (this.target == null) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing target", (Object[])new Object[0]));
            }
            this._LOG(this.session).with().level(Level.FINEST).verb(NutsLogVerb.START).log(NutsMessage.jstyle((String)"compress {0} to {1}", (Object[])new Object[]{this.sources, this.target}));
            try {
                OutputStream fW = null;
                ZipOutputStream zip = null;
                if (this.target.isPath()) {
                    Path tempPath;
                    block46: {
                        tempPath = null;
                        if (this.isSafe()) {
                            tempPath = NutsTmp.of((NutsSession)this.session).createTempFile("zip").toFile();
                        }
                        if (this.target.isPath()) {
                            this.target.getPath().mkParentDirs();
                        }
                        fW = tempPath == null ? (this.target.isOutputStream() ? this.target.getOutputStream() : this.target.getPath().getOutputStream()) : Files.newOutputStream(tempPath, new OpenOption[0]);
                        try {
                            try {
                                zip = new ZipOutputStream(fW);
                                if (this.skipRoot) {
                                    for (NutsStreamOrPath s : this.sources) {
                                        Item file1 = new Item(s, this);
                                        if (file1.isDirectory()) {
                                            for (Item c : file1.list()) {
                                                this.add("", c, zip);
                                            }
                                            continue;
                                        }
                                        this.add("", file1, zip);
                                    }
                                    break block46;
                                }
                                for (NutsStreamOrPath s : this.sources) {
                                    this.add("", new Item(s, this), zip);
                                }
                            }
                            finally {
                                if (zip != null) {
                                    zip.close();
                                }
                            }
                        }
                        finally {
                            if (fW != null) {
                                fW.close();
                            }
                        }
                    }
                    if (tempPath == null) break block47;
                    if (this.target.isOutputStream()) {
                        CoreIOUtils.copy(Files.newInputStream(tempPath, new OpenOption[0]), this.target.getOutputStream(), this.session);
                        break block47;
                    }
                    if (this.target.isPath() && this.target.getPath().isFile()) {
                        Files.move(tempPath, this.target.getPath().toFile(), StandardCopyOption.REPLACE_EXISTING);
                        break block47;
                    }
                    try (InputStream ii = Files.newInputStream(tempPath, new OpenOption[0]);){
                        OutputStream jj = this.target.getPath().getOutputStream();
                        Object object = null;
                        try {
                            CoreIOUtils.copy(ii, jj, this.session);
                            break block47;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (jj != null) {
                                if (object != null) {
                                    try {
                                        jj.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    jj.close();
                                }
                            }
                        }
                    }
                }
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported target %s", (Object[])new Object[]{this.target}));
            }
            catch (IOException ex) {
                this._LOG(this.session).with().level(Level.CONFIG).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"error compressing {0} to {1} : {2}", (Object[])new Object[]{this.sources, this.target.getValue(), ex}));
                throw new NutsIOException(this.session, (Throwable)ex);
            }
        }
    }

    private void add(String path, Item srcFolder, ZipOutputStream zip) {
        if (srcFolder.isDirectory()) {
            this.addFolderToZip(path, srcFolder, zip);
        } else {
            this.addFileToZip(path, srcFolder, zip, false);
        }
    }

    private void addFolderToZip(String path, Item srcFolder, ZipOutputStream zip) throws UncheckedIOException {
        Item[] dirChildren = srcFolder.list();
        if (dirChildren.length == 0) {
            this.addFileToZip(path, srcFolder, zip, true);
        } else {
            for (Item c : dirChildren) {
                if (path.equals("")) {
                    this.addFileToZip(srcFolder.getName(), c, zip, false);
                    continue;
                }
                this.addFileToZip(DefaultNutsCompress.concatPath(path, c.getName()), c, zip, false);
            }
        }
    }

    private void addFileToZip(String path, Item srcFile, ZipOutputStream zip, boolean flag) throws UncheckedIOException {
        String pathPrefix = path;
        if (!pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix + "/";
        }
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        try {
            if (flag) {
                zip.putNextEntry(new ZipEntry(pathPrefix + srcFile.getName() + "/"));
            } else if (srcFile.isDirectory()) {
                this.addFolderToZip(pathPrefix, srcFile, zip);
            } else {
                int len;
                byte[] buf = new byte[1024];
                InputStream in = srcFile.open();
                zip.putNextEntry(new ZipEntry(pathPrefix + srcFile.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public NutsCompress setFormatOption(String option, Object value) {
        return this;
    }

    public Object getFormatOption(String option) {
        return null;
    }

    public String getFormat() {
        return this.format;
    }

    public NutsCompress setFormat(String format) {
        this.checkSession();
        if (NutsBlankable.isBlank((String)format)) {
            format = "zip";
        }
        switch (format) {
            case "zip": 
            case "gzip": 
            case "gz": {
                this.format = format;
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported compression format %s", (Object[])new Object[]{format}));
            }
        }
        return this;
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public NutsCompress addSource(String source) {
        if (source != null) {
            this.sources.add(NutsStreamOrPath.of(NutsPath.of((String)source, (NutsSession)this.session)));
        }
        return this;
    }

    public NutsCompress addSource(InputStream source) {
        this.checkSession();
        if (source == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.plain((String)"null source"));
        }
        this.sources.add(NutsStreamOrPath.of(source, this.session));
        return this;
    }

    public NutsCompress addSource(File source) {
        this.checkSession();
        if (source == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.plain((String)"null source"));
        }
        this.sources.add(NutsStreamOrPath.of(NutsPath.of((File)source, (NutsSession)this.session)));
        return this;
    }

    public NutsCompress addSource(Path source) {
        if (source == null) {
            this.checkSession();
            throw new NutsIllegalArgumentException(this.session, NutsMessage.plain((String)"null source"));
        }
        this.sources.add(NutsStreamOrPath.of(NutsPath.of((Path)source, (NutsSession)this.session)));
        return this;
    }

    public NutsCompress addSource(URL source) {
        if (source == null) {
            this.checkSession();
            throw new NutsIllegalArgumentException(this.session, NutsMessage.plain((String)"null source"));
        }
        this.sources.add(NutsStreamOrPath.of(NutsPath.of((URL)source, (NutsSession)this.session)));
        return this;
    }

    public NutsCompress addSource(NutsPath source) {
        if (source != null) {
            this.sources.add(NutsStreamOrPath.of(source));
        }
        return this;
    }

    public Object getTarget() {
        return this.target;
    }

    public NutsCompress setTarget(OutputStream target) {
        if (target == null) {
            this.target = null;
        } else {
            this.checkSession();
            this.target = NutsStreamOrPath.of(target, this.session);
        }
        return this;
    }

    public NutsCompress setTarget(Path target) {
        this.target = target == null ? null : NutsStreamOrPath.of(NutsPath.of((Path)target, (NutsSession)this.session));
        return this;
    }

    public NutsCompress setTarget(File target) {
        this.target = target == null ? null : NutsStreamOrPath.of(NutsPath.of((File)target, (NutsSession)this.session));
        return this;
    }

    public NutsCompress setTarget(String target) {
        this.target = target == null ? null : NutsStreamOrPath.of(NutsPath.of((String)target, (NutsSession)this.session));
        return this;
    }

    public NutsCompress setTarget(NutsPath target) {
        this.target = target == null ? null : NutsStreamOrPath.of(target);
        return this;
    }

    public NutsCompress to(NutsPath target) {
        return this.setTarget(target);
    }

    public NutsCompress to(OutputStream target) {
        return this.setTarget(target);
    }

    public NutsCompress to(String target) {
        return this.setTarget(target);
    }

    public NutsCompress to(Path target) {
        return this.setTarget(target);
    }

    public NutsCompress to(File target) {
        return this.setTarget(target);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsCompress setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    public NutsCompress run() {
        this.checkSession();
        switch (this.getFormat()) {
            case "zip": 
            case "gzip": 
            case "gz": {
                this.runZip();
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported compression format %s", (Object[])new Object[]{this.getFormat()}));
            }
        }
        return this;
    }

    public NutsProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    public NutsCompress setProgressFactory(NutsProgressFactory value) {
        this.progressFactory = value;
        return this;
    }

    public NutsCompress setProgressMonitor(NutsProgressMonitor value) {
        this.progressFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public NutsCompress setSafe(boolean value) {
        this.safe = value;
        return this;
    }

    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    public NutsCompress setSkipRoot(boolean value) {
        this.skipRoot = true;
        return this;
    }

    public NutsCompress addOptions(NutsPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NutsPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.add(o);
            }
        }
        return this;
    }

    public NutsCompress removeOptions(NutsPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NutsPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.remove(o);
            }
        }
        return this;
    }

    public NutsCompress clearOptions() {
        this.options.clear();
        return this;
    }

    public Set<NutsPathOption> getOptions() {
        return new LinkedHashSet<NutsPathOption>(this.options);
    }

    private static class Item {
        private final NutsStreamOrPath o;
        private final DefaultNutsCompress c;

        public Item(NutsStreamOrPath value, DefaultNutsCompress c) {
            this.o = value;
            this.c = c;
        }

        public boolean isDirectory() {
            return this.o.isPath() && this.o.getPath().isDirectory();
        }

        private Item[] list() {
            if (this.o.isPath()) {
                NutsPath p = this.o.getPath();
                return (Item[])p.list().map(NutsFunction.of(x -> new Item(NutsStreamOrPath.of(x), this.c), (String)"NutsStreamOrPath::of")).toArray(Item[]::new);
            }
            return new Item[0];
        }

        public InputStream open() {
            if (this.c.options.contains(NutsPathOption.LOG) || this.c.options.contains(NutsPathOption.TRACE) || this.c.getProgressFactory() != null) {
                NutsInputStreamMonitor monitor = NutsInputStreamMonitor.of((NutsSession)this.c.session);
                monitor.setOrigin(this.o.getValue());
                monitor.setLogProgress(this.c.options.contains(NutsPathOption.LOG));
                monitor.setTraceProgress(this.c.options.contains(NutsPathOption.TRACE));
                monitor.setProgressFactory(this.c.getProgressFactory());
                if (this.o.isInputStream()) {
                    monitor.setSource(this.o.getInputStream());
                } else {
                    monitor.setSource(this.o.getPath());
                }
                return monitor.create();
            }
            if (this.o.isInputStream()) {
                return this.o.getInputStream();
            }
            return this.o.getPath().getInputStream();
        }

        public String getName() {
            return this.o.getName();
        }
    }
}

