/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.list;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootOptions;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIdResolver;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspaceListConfig;
import net.thevpc.nuts.NutsWorkspaceListManager;
import net.thevpc.nuts.NutsWorkspaceLocation;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsWorkspaceListManager
implements NutsWorkspaceListManager {
    private final NutsSession defaultSession;
    private String name;
    private Map<String, NutsWorkspaceLocation> workspaces = new LinkedHashMap<String, NutsWorkspaceLocation>();
    private NutsWorkspaceListConfig config;

    public DefaultNutsWorkspaceListManager(NutsSession session) {
        this.defaultSession = session;
        this.setName(null);
        NutsPath file = this.getConfigFile(session);
        if (file.exists()) {
            this.config = (NutsWorkspaceListConfig)NutsElements.of((NutsSession)this.defaultSession).json().parse(file, NutsWorkspaceListConfig.class);
            for (NutsWorkspaceLocation var : this.config.getWorkspaces()) {
                this.workspaces.put(var.getUuid(), var);
            }
        } else {
            this.config = new NutsWorkspaceListConfig().setUuid(UUID.randomUUID().toString()).setName("default-config");
            this.workspaces.put(session.getWorkspace().getUuid(), new NutsWorkspaceLocation().setUuid(session.getWorkspace().getUuid()).setName("default-workspace").setLocation(this.defaultSession.locations().getWorkspaceLocation().toString()));
            this.save(session);
        }
    }

    public DefaultNutsWorkspaceListManager setName(String name) {
        if (NutsBlankable.isBlank((String)name)) {
            name = "default";
        }
        this.name = name.trim();
        return this;
    }

    public String getName() {
        return this.name;
    }

    private NutsPath getConfigFile(NutsSession session) {
        return session.locations().getStoreLocation(NutsIdResolver.of((NutsSession)session).resolveId(DefaultNutsWorkspaceListManager.class), NutsStoreLocation.CONFIG).resolve(this.name + "-nuts-workspace-list.json");
    }

    public List<NutsWorkspaceLocation> getWorkspaces() {
        return new ArrayList<NutsWorkspaceLocation>(this.workspaces.values());
    }

    public NutsWorkspaceLocation getWorkspaceLocation(String uuid) {
        return this.workspaces.get(uuid);
    }

    public NutsWorkspaceListConfig getConfig() {
        return this.config;
    }

    public DefaultNutsWorkspaceListManager setConfig(NutsWorkspaceListConfig config) {
        this.config = config;
        return this;
    }

    public NutsSession addWorkspace(String path, NutsSession session) {
        NutsSession ss = this.createWorkspace(path);
        NutsWorkspaceLocation workspaceLocation = new NutsWorkspaceLocation().setUuid(ss.getWorkspace().getUuid()).setName(ss.locations().getWorkspaceLocation().getName()).setLocation(ss.locations().getWorkspaceLocation().toString());
        this.workspaces.put(ss.getWorkspace().getUuid(), workspaceLocation);
        this.save(session);
        return ss;
    }

    public boolean removeWorkspace(String uuid, NutsSession session) {
        boolean b;
        boolean bl = b = this.workspaces.remove(uuid) != null;
        if (b) {
            this.save(session);
        }
        return b;
    }

    public void save(NutsSession session) {
        this.config.setWorkspaces((List)(this.workspaces.isEmpty() ? null : new ArrayList<NutsWorkspaceLocation>(this.workspaces.values())));
        NutsPath file = this.getConfigFile(session);
        NutsElements.of((NutsSession)this.defaultSession).json().setValue((Object)this.config).setNtf(false).print(file);
    }

    public DefaultNutsWorkspaceListManager setWorkspaces(Map<String, NutsWorkspaceLocation> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    private NutsSession createWorkspace(String path) {
        return Nuts.openWorkspace((NutsBootOptions)NutsWorkspaceOptionsBuilder.of((NutsSession)this.defaultSession).setWorkspace(path).setOpenMode(NutsOpenMode.OPEN_OR_CREATE).setSkipCompanions(Boolean.valueOf(true)).toBootOptions());
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

