/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsStoreLocation;

public class NutsStoreLocationsMap {
    private Map<NutsStoreLocation, String> locations;

    public NutsStoreLocationsMap(Map<NutsStoreLocation, String> locations) {
        this.locations = locations;
    }

    public String get(NutsStoreLocation location) {
        if (this.locations != null && location != null) {
            return this.locations.get(location);
        }
        return null;
    }

    public NutsStoreLocationsMap set(Map<NutsStoreLocation, String> locations) {
        this.set(new NutsStoreLocationsMap(locations));
        return this;
    }

    public NutsStoreLocationsMap set(NutsStoreLocationsMap other) {
        if (other != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = other.get(location);
                if (NutsBlankable.isBlank((String)v)) continue;
                this.set(location, v);
            }
        }
        return this;
    }

    public NutsStoreLocationsMap set(NutsStoreLocation location, String value) {
        if (location != null) {
            if (NutsBlankable.isBlank((String)value)) {
                if (this.locations != null) {
                    this.locations.remove(location);
                }
            } else {
                if (this.locations == null) {
                    this.locations = new HashMap<NutsStoreLocation, String>();
                }
                this.locations.put(location, value);
            }
        }
        return this;
    }

    public Map<NutsStoreLocation, String> toMap() {
        HashMap<NutsStoreLocation, String> map = new HashMap<NutsStoreLocation, String>();
        if (this.locations != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = this.get(location);
                if (NutsBlankable.isBlank((String)v)) continue;
                map.put(location, v);
            }
        }
        return map;
    }

    public Map<NutsStoreLocation, String> toMapOrNull() {
        Map<NutsStoreLocation, String> m = this.toMap();
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }
}

