/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsStoreLocation;

public class NutsHomeLocationsMap {
    private Map<NutsHomeLocation, String> locations;

    public NutsHomeLocationsMap(Map<NutsHomeLocation, String> locations) {
        this.locations = locations;
    }

    public String get(NutsHomeLocation location) {
        if (this.locations != null && location != null) {
            return this.locations.get(location);
        }
        return null;
    }

    public NutsHomeLocationsMap set(Map<NutsHomeLocation, String> locations) {
        return this.set(new NutsHomeLocationsMap(locations));
    }

    public NutsHomeLocationsMap set(NutsHomeLocationsMap other) {
        if (other != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = other.get(NutsHomeLocation.of(null, (NutsStoreLocation)location));
                if (NutsBlankable.isBlank((String)v)) continue;
                this.set(NutsHomeLocation.of(null, (NutsStoreLocation)location), v);
            }
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                for (NutsOsFamily osFamily : NutsOsFamily.values()) {
                    String v = other.get(NutsHomeLocation.of((NutsOsFamily)osFamily, (NutsStoreLocation)location));
                    if (NutsBlankable.isBlank((String)v)) continue;
                    this.set(NutsHomeLocation.of((NutsOsFamily)osFamily, (NutsStoreLocation)location), v);
                }
            }
        }
        return this;
    }

    public NutsHomeLocationsMap set(NutsHomeLocation type, String value) {
        NutsStoreLocation storeLocation = type.getStoreLocation();
        if (storeLocation != null) {
            if (NutsBlankable.isBlank((String)value)) {
                if (this.locations != null) {
                    this.locations.remove(type);
                }
            } else {
                if (this.locations == null) {
                    this.locations = new HashMap<NutsHomeLocation, String>();
                }
                this.locations.put(type, value);
            }
        }
        return this;
    }

    public Map<NutsHomeLocation, String> toMap() {
        HashMap<NutsHomeLocation, String> map = new HashMap<NutsHomeLocation, String>();
        if (this.locations != null) {
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String v = this.get(NutsHomeLocation.of(null, (NutsStoreLocation)location));
                if (NutsBlankable.isBlank((String)v)) continue;
                map.put(NutsHomeLocation.of(null, (NutsStoreLocation)location), v);
            }
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                for (NutsOsFamily osFamily : NutsOsFamily.values()) {
                    String v = this.get(NutsHomeLocation.of((NutsOsFamily)osFamily, (NutsStoreLocation)location));
                    if (NutsBlankable.isBlank((String)v)) continue;
                    map.put(NutsHomeLocation.of((NutsOsFamily)osFamily, (NutsStoreLocation)location), v);
                }
            }
        }
        return map;
    }

    public Map<NutsHomeLocation, String> toMapOrNull() {
        Map<NutsHomeLocation, String> m = this.toMap();
        if (m.isEmpty()) {
            return null;
        }
        return m;
    }
}

