/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsStoreLocationsMap;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsWorkspaceLocationModel {
    private final NutsWorkspace ws;
    private final NutsPath workspaceLocation;

    public DefaultNutsWorkspaceLocationModel(NutsWorkspace ws, String workspaceLocation) {
        this.ws = ws;
        this.workspaceLocation = NutsPath.of((String)workspaceLocation, (NutsSession)NutsWorkspaceUtils.defaultSession(ws));
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    private DefaultNutsWorkspaceConfigModel cfg() {
        return ((DefaultNutsWorkspace)this.ws).getConfigModel();
    }

    public void setHomeLocation(NutsHomeLocation homeType, String location, NutsSession session) {
        this.cfg().onPreUpdateConfig("home-location", session);
        this.cfg().getStoreModelBoot().setHomeLocations(new NutsHomeLocationsMap(this.cfg().getStoreModelBoot().getHomeLocations()).set(homeType, location).toMapOrNull());
        this.cfg().onPostUpdateConfig("home-location", session);
    }

    public NutsPath getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public NutsPath getHomeLocation(NutsStoreLocation folderType, NutsSession session) {
        return this.cfg().current().getHomeLocation(folderType, session);
    }

    public NutsPath getStoreLocation(NutsStoreLocation folderType, NutsSession session) {
        try {
            return this.cfg().current().getStoreLocation(folderType, session);
        }
        catch (IllegalStateException stillInitializing) {
            NutsWorkspaceOptions info = NutsWorkspaceExt.of((NutsWorkspace)this.ws).getModel().bootModel.getBootOptions();
            String h = info.getStoreLocation(folderType);
            return h == null ? null : NutsPath.of((String)h, (NutsSession)session);
        }
    }

    public void setStoreLocation(NutsStoreLocation folderType, String location, NutsSession session) {
        if (folderType == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid store root folder null", (Object[])new Object[0]));
        }
        this.cfg().onPreUpdateConfig("store-location", session);
        this.cfg().getStoreModelBoot().setStoreLocations(new NutsStoreLocationsMap(this.cfg().getStoreModelBoot().getStoreLocations()).set(folderType, location).toMapOrNull());
        this.cfg().onPostUpdateConfig("store-location", session);
    }

    public void setStoreLocationStrategy(NutsStoreLocationStrategy strategy, NutsSession session) {
        if (strategy == null) {
            strategy = NutsStoreLocationStrategy.EXPLODED;
        }
        this.cfg().onPreUpdateConfig("store-location-strategy", session);
        this.cfg().getStoreModelBoot().setStoreLocationStrategy(strategy);
        this.cfg().onPostUpdateConfig("store-location-strategy", session);
    }

    public void setStoreLocationLayout(NutsOsFamily layout, NutsSession session) {
        this.cfg().onPreUpdateConfig("store-location-layout", session);
        this.cfg().getStoreModelBoot().setStoreLocationLayout(layout);
        this.cfg().onPostUpdateConfig("store-location-layout", session);
    }

    public NutsPath getStoreLocation(NutsStoreLocation folderType, String repositoryIdOrName, NutsSession session) {
        if (repositoryIdOrName == null) {
            return this.getStoreLocation(folderType, session);
        }
        NutsRepository repositoryById = session.repos().setSession(session).getRepository(repositoryIdOrName);
        NutsRepositorySPI nutsRepositorySPI = NutsWorkspaceUtils.of(session).repoSPI(repositoryById);
        return nutsRepositorySPI.config().getStoreLocation(folderType);
    }

    public NutsPath getStoreLocation(NutsId id, NutsStoreLocation folderType, String repositoryIdOrName, NutsSession session) {
        if (repositoryIdOrName == null) {
            return this.getStoreLocation(id, folderType, session);
        }
        NutsPath storeLocation = this.getStoreLocation(folderType, repositoryIdOrName, session);
        return storeLocation.resolve("id").resolve(this.getDefaultIdBasedir(id, session));
    }

    public NutsPath getStoreLocation(NutsId id, NutsStoreLocation folderType, NutsSession session) {
        NutsPath storeLocation = this.getStoreLocation(folderType, session);
        if (storeLocation == null) {
            return null;
        }
        return storeLocation.resolve("id").resolve(this.getDefaultIdBasedir(id, session));
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy(NutsSession session) {
        return this.cfg().current().getStoreLocationStrategy();
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy(NutsSession session) {
        return this.cfg().current().getRepositoryStoreLocationStrategy();
    }

    public NutsOsFamily getStoreLocationLayout(NutsSession session) {
        return this.cfg().current().getStoreLocationLayout();
    }

    public Map<NutsStoreLocation, String> getStoreLocations(NutsSession session) {
        return this.cfg().current().getStoreLocations();
    }

    public Map<NutsHomeLocation, String> getHomeLocations(NutsSession session) {
        return this.cfg().current().getHomeLocations();
    }

    public NutsPath getHomeLocation(NutsHomeLocation location, NutsSession session) {
        return this.cfg().current().getHomeLocation(location, session);
    }

    public NutsPath getDefaultIdBasedir(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkShortId(id);
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String plainIdPath = groupId.replace('.', '/') + "/" + artifactId;
        if (id.getVersion().isBlank()) {
            return NutsPath.of((String)plainIdPath, (NutsSession)session);
        }
        String version = id.getVersion().getValue();
        String x = plainIdPath + "/" + version;
        return NutsPath.of((String)x, (NutsSession)session);
    }

    public String getDefaultIdFilename(NutsId id, NutsSession session) {
        String c;
        String classifier = "";
        String ext = this.getDefaultIdExtension(id, session);
        if (!(ext.equals(".nuts") || ext.equals(".pom") || NutsBlankable.isBlank((String)(c = id.getClassifier())))) {
            classifier = "-" + c;
        }
        return id.getArtifactId() + "-" + id.getVersion().getValue() + classifier + ext;
    }

    public String getDefaultIdContentExtension(String packaging, NutsSession session) {
        if (NutsBlankable.isBlank((String)packaging)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported empty packaging", (Object[])new Object[0]));
        }
        switch (packaging) {
            case "jar": 
            case "bundle": 
            case "nuts-extension": 
            case "maven-archetype": 
            case "maven-plugin": 
            case "ejb-client": 
            case "test-jar": 
            case "ejb": 
            case "java-source": 
            case "javadoc": 
            case "eclipse-plugin": {
                return ".jar";
            }
            case "dll": 
            case "so": 
            case "jnilib": {
                return "-natives.jar";
            }
            case "war": {
                return ".war";
            }
            case "ear": {
                return ".ear";
            }
            case "pom": {
                return ".pom";
            }
            case "nuts": {
                return ".nuts";
            }
            case "rar": {
                return ".rar";
            }
            case "zip": 
            case "nbm-application": {
                return ".zip";
            }
        }
        return "." + packaging;
    }

    public String getDefaultIdExtension(NutsId id, NutsSession session) {
        String f;
        Map q = id.getProperties();
        switch (f = NutsUtilStrings.trim((String)((String)q.get("face")))) {
            case "descriptor": {
                return ".nuts";
            }
            case "descriptor-hash": {
                return ".nuts.sha1";
            }
            case "catalog": {
                return ".catalog";
            }
            case "content-hash": {
                return this.getDefaultIdExtension(id.builder().setFaceContent().build(), session) + ".sha1";
            }
            case "content": {
                return this.getDefaultIdContentExtension((String)q.get("packaging"), session);
            }
        }
        if (f.equals("cache") || f.endsWith(".cache")) {
            return "." + f;
        }
        if (NutsBlankable.isBlank((String)f)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing face in %s", (Object[])new Object[]{id}));
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported face %s in %s", (Object[])new Object[]{f, id}));
    }
}

