/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.Map;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceLocationModel;

public class DefaultNutsWorkspaceLocationManager
implements NutsWorkspaceLocationManager {
    private NutsSession session;
    private DefaultNutsWorkspaceLocationModel model;

    public DefaultNutsWorkspaceLocationManager(DefaultNutsWorkspaceLocationModel model) {
        this.model = model;
    }

    public NutsPath getHomeLocation(NutsStoreLocation folderType) {
        this.checkSession();
        return this.model.getHomeLocation(folderType, this.session);
    }

    public DefaultNutsWorkspaceLocationModel getModel() {
        return this.model;
    }

    public NutsPath getStoreLocation(NutsStoreLocation folderType) {
        this.checkSession();
        return this.model.getStoreLocation(folderType, this.session);
    }

    public NutsPath getStoreLocation(NutsId id, NutsStoreLocation folderType) {
        this.checkSession();
        return this.model.getStoreLocation(id, folderType, this.session);
    }

    public NutsPath getStoreLocation(NutsStoreLocation folderType, String repositoryIdOrName) {
        this.checkSession();
        return this.model.getStoreLocation(folderType, repositoryIdOrName, this.session);
    }

    public NutsPath getStoreLocation(NutsId id, NutsStoreLocation folderType, String repositoryIdOrName) {
        this.checkSession();
        return this.model.getStoreLocation(id, folderType, repositoryIdOrName, this.session);
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        this.checkSession();
        return this.model.getStoreLocationStrategy(this.session);
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        this.checkSession();
        return this.model.getRepositoryStoreLocationStrategy(this.session);
    }

    public NutsOsFamily getStoreLocationLayout() {
        this.checkSession();
        return this.model.getStoreLocationLayout(this.session);
    }

    public Map<NutsStoreLocation, String> getStoreLocations() {
        this.checkSession();
        return this.model.getStoreLocations(this.session);
    }

    public String getDefaultIdFilename(NutsId id) {
        this.checkSession();
        return this.model.getDefaultIdFilename(id, this.session);
    }

    public NutsPath getDefaultIdBasedir(NutsId id) {
        this.checkSession();
        return this.model.getDefaultIdBasedir(id, this.session);
    }

    public String getDefaultIdContentExtension(String packaging) {
        this.checkSession();
        return this.model.getDefaultIdContentExtension(packaging, this.session);
    }

    public String getDefaultIdExtension(NutsId id) {
        this.checkSession();
        return this.model.getDefaultIdExtension(id, this.session);
    }

    public Map<NutsHomeLocation, String> getHomeLocations() {
        this.checkSession();
        return this.model.getHomeLocations(this.session);
    }

    public NutsPath getHomeLocation(NutsHomeLocation location) {
        this.checkSession();
        return this.model.getHomeLocation(location, this.session);
    }

    public NutsPath getWorkspaceLocation() {
        return this.model.getWorkspaceLocation();
    }

    public NutsWorkspaceLocationManager setStoreLocation(NutsStoreLocation folderType, String location) {
        this.checkSession();
        this.model.setStoreLocation(folderType, location, this.session);
        return this;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public NutsWorkspaceLocationManager setStoreLocationStrategy(NutsStoreLocationStrategy strategy) {
        this.checkSession();
        this.model.setStoreLocationStrategy(strategy, this.session);
        return this;
    }

    public NutsWorkspaceLocationManager setStoreLocationLayout(NutsOsFamily layout) {
        this.checkSession();
        this.model.setStoreLocationLayout(layout, this.session);
        return this;
    }

    public NutsWorkspaceLocationManager setHomeLocation(NutsHomeLocation homeType, String location) {
        this.checkSession();
        this.model.setHomeLocation(homeType, location, this.session);
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspaceLocationManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }
}

