/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.app.gui.CoreNutsUtilGui;
import net.thevpc.nuts.runtime.standalone.id.DefaultNutsIdParser;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.util.collections.DefaultObservableMap;
import net.thevpc.nuts.runtime.standalone.util.collections.ObservableMap;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;

public class DefaultNutsWorkspaceEnvManagerModel {
    private final Map<NutsPlatformFamily, List<NutsPlatformLocation>> configPlatforms = new LinkedHashMap<NutsPlatformFamily, List<NutsPlatformLocation>>();
    protected ObservableMap<String, Object> userProperties;
    private final NutsWorkspace workspace;
    private final NutsId platform;
    private final NutsId os;
    private NutsOsFamily osFamily;
    private NutsShellFamily shellFamily;
    private NutsId[] desktopEnvironments;
    private NutsDesktopEnvironmentFamily[] osDesktopEnvironmentFamilies;
    private NutsDesktopEnvironmentFamily osDesktopEnvironmentFamily;
    private final NutsId arch;
    private final NutsId osDist;
    private final NutsArchFamily archFamily = NutsArchFamily.getCurrent();

    public DefaultNutsWorkspaceEnvManagerModel(NutsWorkspace ws, NutsSession session) {
        this.workspace = ws;
        this.userProperties = new DefaultObservableMap<String, Object>();
        DefaultNutsIdParser nip = new DefaultNutsIdParser(session);
        this.os = nip.parse(CorePlatformUtils.getPlatformOs(NutsWorkspaceUtils.defaultSession(this.workspace)));
        String platformOsDist = CorePlatformUtils.getPlatformOsDist(NutsWorkspaceUtils.defaultSession(this.workspace));
        if (platformOsDist == null) {
            platformOsDist = "default";
        }
        this.osDist = nip.parse(platformOsDist);
        this.platform = NutsJavaSdkUtils.of(session).createJdkId(System.getProperty("java.version"), session);
        this.arch = NutsId.of((String)System.getProperty("os.arch"), (NutsSession)session);
    }

    public NutsId getArch() {
        return this.arch;
    }

    public NutsArchFamily getArchFamily() {
        return this.archFamily;
    }

    public NutsOsFamily getOsFamily() {
        if (this.osFamily == null) {
            this.osFamily = NutsOsFamily.getCurrent();
        }
        return this.osFamily;
    }

    public NutsShellFamily getShellFamily() {
        if (this.shellFamily == null) {
            this.shellFamily = NutsShellFamily.getCurrent();
        }
        return this.shellFamily;
    }

    public NutsShellFamily[] getShellFamilies() {
        return this.getShellFamilies(true);
    }

    public NutsShellFamily[] getShellFamilies(boolean allEvenNonInstalled) {
        ArrayList shellFamilies = new ArrayList();
        switch (this.getOsFamily()) {
            case UNIX: 
            case LINUX: 
            case MACOS: {
                NutsShellFamily[] all;
                LinkedHashSet<NutsShellFamily> families = new LinkedHashSet<NutsShellFamily>();
                families.add(this.getShellFamily());
                for (NutsShellFamily f : all = new NutsShellFamily[]{NutsShellFamily.SH, NutsShellFamily.BASH, NutsShellFamily.ZSH, NutsShellFamily.CSH, NutsShellFamily.KSH, NutsShellFamily.FISH}) {
                    Path path;
                    if (f == null || !Files.exists(path = Paths.get("/bin", new String[0]).resolve(f.id()), new LinkOption[0])) continue;
                    families.add(f);
                }
                if (allEvenNonInstalled) {
                    families.addAll(Arrays.asList(all));
                }
                shellFamilies.addAll(families);
                break;
            }
            case WINDOWS: {
                LinkedHashSet<NutsShellFamily> families = new LinkedHashSet<NutsShellFamily>();
                families.add(this.getShellFamily());
                families.add(NutsShellFamily.WIN_CMD);
                if (this.getOs().getVersion().compareTo("7") >= 0) {
                    families.add(NutsShellFamily.WIN_POWER_SHELL);
                }
                shellFamilies.addAll(families);
                break;
            }
            default: {
                shellFamilies.add(NutsShellFamily.UNKNOWN);
            }
        }
        return shellFamilies.toArray(new NutsShellFamily[0]);
    }

    public NutsId[] getDesktopEnvironments(NutsSession session) {
        if (this.desktopEnvironments == null) {
            this.desktopEnvironments = this.getDesktopEnvironments0(session);
        }
        return this.desktopEnvironments;
    }

    public boolean isGraphicalDesktopEnvironment() {
        return CoreNutsUtilGui.isGraphicalDesktopEnvironment();
    }

    protected NutsId[] getDesktopEnvironmentsXDGOrEmpty(NutsSession session) {
        String _XDG_SESSION_DESKTOP = System.getenv("XDG_SESSION_DESKTOP");
        String _XDG_CURRENT_DESKTOP = System.getenv("XDG_CURRENT_DESKTOP");
        ArrayList<NutsId> a = new ArrayList<NutsId>();
        if (!NutsBlankable.isBlank((String)_XDG_SESSION_DESKTOP) && !NutsBlankable.isBlank((String)_XDG_SESSION_DESKTOP)) {
            String[] supportedSessions = new LinkedHashSet(Arrays.stream(NutsUtilStrings.trim((String)_XDG_CURRENT_DESKTOP).split(":")).map(x -> x.trim().toLowerCase()).filter(x -> x.length() > 0).collect(Collectors.toList())).toArray(new String[0]);
            String sd = _XDG_SESSION_DESKTOP.toLowerCase();
            for (int i = 0; i < supportedSessions.length; ++i) {
                NutsIdBuilder nb = NutsIdBuilder.of((NutsSession)session).setArtifactId(supportedSessions[i]);
                if ("kde".equals(sd)) {
                    String _KDE_FULL_SESSION = System.getenv("KDE_FULL_SESSION");
                    String _KDE_SESSION_VERSION = System.getenv("KDE_SESSION_VERSION");
                    if (_KDE_FULL_SESSION != null && "true".equals(_KDE_FULL_SESSION.trim())) {
                        nb.setProperty("full", "true");
                    }
                    if (_KDE_SESSION_VERSION != null) {
                        nb.setProperty("version", _KDE_SESSION_VERSION.trim());
                    }
                }
                String _XDG_SESSION_TYPE = System.getenv("XDG_SESSION_TYPE");
                String _XSESSION_IS_UP = System.getenv("XSESSION_IS_UP");
                String _XDG_SESSION_CLASS = System.getenv("XDG_SESSION_CLASS");
                if (_XDG_SESSION_TYPE != null) {
                    nb.setProperty("type", _XDG_SESSION_TYPE.trim().toLowerCase());
                }
                if (_XDG_SESSION_CLASS != null) {
                    nb.setProperty("class", _XDG_SESSION_CLASS.trim().toLowerCase());
                }
                a.add(nb.build());
            }
        }
        return a.toArray(new NutsId[0]);
    }

    protected NutsId[] getDesktopEnvironments0(NutsSession session) {
        if (!this.isGraphicalDesktopEnvironment()) {
            return new NutsId[]{NutsIdBuilder.of((NutsSession)session).setArtifactId(NutsDesktopEnvironmentFamily.HEADLESS.id()).build()};
        }
        switch (session.env().getOsFamily()) {
            case WINDOWS: {
                return new NutsId[]{NutsIdBuilder.of((NutsSession)session).setArtifactId(NutsDesktopEnvironmentFamily.WINDOWS_SHELL.id()).build()};
            }
            case MACOS: {
                return new NutsId[]{NutsIdBuilder.of((NutsSession)session).setArtifactId(NutsDesktopEnvironmentFamily.MACOS_AQUA.id()).build()};
            }
            case UNIX: 
            case LINUX: {
                NutsId[] all = this.getDesktopEnvironmentsXDGOrEmpty(session);
                if (all.length == 0) {
                    return new NutsId[]{NutsIdBuilder.of((NutsSession)session).setArtifactId(NutsDesktopEnvironmentFamily.UNKNOWN.id()).build()};
                }
                return all;
            }
        }
        return new NutsId[]{NutsIdBuilder.of((NutsSession)session).setArtifactId(NutsDesktopEnvironmentFamily.UNKNOWN.id()).build()};
    }

    public NutsDesktopEnvironmentFamily[] getDesktopEnvironmentFamilies(NutsSession session) {
        if (this.osDesktopEnvironmentFamilies == null) {
            this.osDesktopEnvironmentFamilies = this.getDesktopEnvironmentFamilies0(session);
        }
        return this.osDesktopEnvironmentFamilies;
    }

    public NutsDesktopEnvironmentFamily[] getDesktopEnvironmentFamilies0(NutsSession session) {
        NutsId[] desktopEnvironments = this.getDesktopEnvironments(session);
        LinkedHashSet<NutsDesktopEnvironmentFamily> all = new LinkedHashSet<NutsDesktopEnvironmentFamily>();
        for (NutsId desktopEnvironment : desktopEnvironments) {
            all.add(NutsDesktopEnvironmentFamily.parseLenient((String)desktopEnvironment.getShortName()));
        }
        return all.toArray(new NutsDesktopEnvironmentFamily[0]);
    }

    public NutsDesktopEnvironmentFamily getDesktopEnvironmentFamily(NutsSession session) {
        if (this.osDesktopEnvironmentFamily == null) {
            this.osDesktopEnvironmentFamily = this.getDesktopEnvironmentFamily0(session);
        }
        return this.osDesktopEnvironmentFamily;
    }

    public NutsDesktopEnvironmentFamily getDesktopEnvironmentFamily0(NutsSession session) {
        NutsDesktopEnvironmentFamily[] all = this.getDesktopEnvironmentFamilies(session);
        if (all.length == 0) {
            return NutsDesktopEnvironmentFamily.UNKNOWN;
        }
        boolean unknown = false;
        boolean none = false;
        boolean headless = false;
        block5: for (NutsDesktopEnvironmentFamily f : all) {
            switch (f) {
                case UNKNOWN: {
                    unknown = true;
                    continue block5;
                }
                case HEADLESS: {
                    headless = true;
                    continue block5;
                }
                case NONE: {
                    none = true;
                    continue block5;
                }
                default: {
                    return f;
                }
            }
        }
        if (headless) {
            return NutsDesktopEnvironmentFamily.HEADLESS;
        }
        if (none) {
            return NutsDesktopEnvironmentFamily.NONE;
        }
        if (unknown) {
            return NutsDesktopEnvironmentFamily.UNKNOWN;
        }
        return NutsDesktopEnvironmentFamily.UNKNOWN;
    }

    public NutsId getOs() {
        return this.os;
    }

    public NutsId getPlatform(NutsSession session) {
        return this.platform;
    }

    public NutsId getOsDist() {
        return this.osDist;
    }

    public Map<String, Object> getProperties() {
        return this.userProperties;
    }

    public Object getProperty(String property, NutsSession session) {
        return this.userProperties.get(property);
    }

    public NutsElement getPropertyElement(String property, NutsSession session) {
        return NutsElements.of((NutsSession)session).setIndestructibleObjects(x -> !x.isPrimitive() && !Number.class.isAssignableFrom((Class<?>)x) && !Boolean.class.isAssignableFrom((Class<?>)x) && !String.class.isAssignableFrom((Class<?>)x) && !Instant.class.isAssignableFrom((Class<?>)x)).toElement(this.getProperty(property, session));
    }

    public <T> T getOrCreateProperty(Class<T> property, Supplier<T> supplier, NutsSession session) {
        return this.getOrCreateProperty(property.getName(), supplier, session);
    }

    public <T> T getOrCreateProperty(String property, Supplier<T> supplier, NutsSession session) {
        Object o;
        NutsElement a = this.getPropertyElement(property, session);
        Object object = o = a.isCustom() ? a.asCustom().getValue() : a.asPrimitive().getValue();
        if (o != null) {
            return (T)o;
        }
        o = supplier.get();
        this.setProperty(property, o);
        return (T)o;
    }

    public void setProperty(String property, Object value) {
        if (value == null) {
            this.userProperties.remove(property);
        } else {
            this.userProperties.put(property, value);
        }
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public Map<NutsPlatformFamily, List<NutsPlatformLocation>> getConfigPlatforms() {
        return this.configPlatforms;
    }
}

