/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDesktopEnvironmentFamily;
import net.thevpc.nuts.NutsDesktopIntegrationItem;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLauncherOptions;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPlatformManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsShellFamily;
import net.thevpc.nuts.NutsSupportMode;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NdiScriptOptions;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NutsSettingsNdiSubCommand;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.SystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsPlatformManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsPlatformModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceEnvManagerModel;

public class DefaultNutsWorkspaceEnvManager
implements NutsWorkspaceEnvManager {
    public static final Pattern UNIX_USER_DIRS_PATTERN = Pattern.compile("^\\s*(?<k>[A-Z_]+)\\s*=\\s*(?<v>.*)$");
    private final DefaultNutsWorkspaceEnvManagerModel model;
    protected DefaultNutsPlatformModel sdkModel;
    private NutsSession session;

    public DefaultNutsWorkspaceEnvManager(DefaultNutsWorkspaceEnvManagerModel model) {
        this.model = model;
        this.sdkModel = new DefaultNutsPlatformModel(model);
    }

    public Map<String, Object> getProperties() {
        this.checkSession();
        return this.model.getProperties();
    }

    public NutsElement getPropertyElement(String property) {
        this.checkSession();
        return this.model.getPropertyElement(property, this.getSession());
    }

    public Object getProperty(String property) {
        this.checkSession();
        return this.model.getProperty(property, this.getSession());
    }

    public NutsWorkspaceEnvManager setProperty(String property, Object value) {
        this.checkSession();
        this.model.setProperty(property, value);
        return this;
    }

    public NutsOsFamily getOsFamily() {
        return this.model.getOsFamily();
    }

    public NutsShellFamily[] getShellFamilies() {
        return this.model.getShellFamilies();
    }

    public NutsShellFamily getShellFamily() {
        return this.model.getShellFamily();
    }

    public NutsId getDesktopEnvironment() {
        return this.getDesktopEnvironments()[0];
    }

    public NutsId[] getDesktopEnvironments() {
        return this.model.getDesktopEnvironments(this.session);
    }

    public NutsDesktopEnvironmentFamily getDesktopEnvironmentFamily() {
        return this.model.getDesktopEnvironmentFamily(this.session);
    }

    public NutsDesktopEnvironmentFamily[] getDesktopEnvironmentFamilies() {
        return this.model.getDesktopEnvironmentFamilies(this.session);
    }

    public NutsPlatformManager platforms() {
        return new DefaultNutsPlatformManager(this.sdkModel).setSession(this.getSession());
    }

    public NutsId getPlatform() {
        return this.model.getPlatform(this.session);
    }

    public NutsId getOs() {
        return this.model.getOs();
    }

    public NutsId getOsDist() {
        return this.model.getOsDist();
    }

    public NutsId getArch() {
        return this.model.getArch();
    }

    public NutsArchFamily getArchFamily() {
        return this.model.getArchFamily();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspaceEnvManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    public boolean isGraphicalDesktopEnvironment() {
        return this.model.isGraphicalDesktopEnvironment();
    }

    public NutsSupportMode getDesktopIntegrationSupport(NutsDesktopIntegrationItem item) {
        this.checkSession();
        if (item == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing item", (Object[])new Object[0]));
        }
        String optionName = null;
        switch (item) {
            case DESKTOP: {
                optionName = "---system-desktop-launcher";
                break;
            }
            case MENU: {
                optionName = "---system-menu-launcher";
                break;
            }
            case SHORTCUT: {
                optionName = "---system-custom-launcher";
            }
        }
        if (optionName != null) {
            NutsSupportMode q;
            String o;
            NutsArgument bootCustomArgument = this.session.boot().getBootCustomArgument(new String[]{optionName});
            String string = o = bootCustomArgument == null ? null : bootCustomArgument.getString();
            if (!NutsBlankable.isBlank((String)o) && (q = NutsSupportMode.parseLenient((String)o, null, null)) != null) {
                return q;
            }
        }
        switch (this.getOsFamily()) {
            case LINUX: {
                switch (item) {
                    case DESKTOP: {
                        return NutsSupportMode.SUPPORTED;
                    }
                    case MENU: {
                        return NutsSupportMode.PREFERRED;
                    }
                    case SHORTCUT: {
                        return NutsSupportMode.PREFERRED;
                    }
                }
                break;
            }
            case UNIX: {
                return NutsSupportMode.UNSUPPORTED;
            }
            case WINDOWS: {
                switch (item) {
                    case DESKTOP: {
                        if (Files.isDirectory(this.getDesktopPath(), new LinkOption[0])) {
                            return NutsSupportMode.PREFERRED;
                        }
                        return NutsSupportMode.SUPPORTED;
                    }
                    case MENU: {
                        return NutsSupportMode.PREFERRED;
                    }
                    case SHORTCUT: {
                        return NutsSupportMode.PREFERRED;
                    }
                }
                break;
            }
            case MACOS: {
                return NutsSupportMode.UNSUPPORTED;
            }
            case UNKNOWN: {
                return NutsSupportMode.UNSUPPORTED;
            }
        }
        return NutsSupportMode.UNSUPPORTED;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Path getDesktopPath() {
        switch (this.getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case MACOS: {
                File f = new File(System.getProperty("user.home"), ".config/user-dirs.dirs");
                if (f.exists()) {
                    try (BufferedReader r = new BufferedReader(new FileReader(f));){
                        String line;
                        while ((line = r.readLine()) != null) {
                            if ((line = line.trim()).startsWith("#")) continue;
                            Matcher m = UNIX_USER_DIRS_PATTERN.matcher(line);
                            if (m.find()) {
                                String k = m.group("k");
                                if (!k.equals("XDG_DESKTOP_DIR")) continue;
                                String v = m.group("v");
                                if ((v = v.trim()).startsWith("\"")) {
                                    int last = v.indexOf(34, 1);
                                    String s = v.substring(1, last);
                                    s = s.replace("$HOME", System.getProperty("user.home"));
                                    Path path = Paths.get(s, new String[0]);
                                    return path;
                                }
                                Path path = Paths.get(v, new String[0]);
                                return path;
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return new File(System.getProperty("user.home"), "Desktop").toPath();
            }
            case WINDOWS: {
                return new File(System.getProperty("user.home"), "Desktop").toPath();
            }
        }
        return new File(System.getProperty("user.home"), "Desktop").toPath();
    }

    public void addLauncher(NutsLauncherOptions launcher) {
        this.checkSession();
        NutsSession session = this.getSession();
        SystemNdi ndi = NutsSettingsNdiSubCommand.createNdi(session);
        if (ndi != null) {
            ndi.addScript(new NdiScriptOptions().setSession(session).setLauncher(launcher.copy()), new String[]{launcher.getId().builder().getFullName()});
        }
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public DefaultNutsWorkspaceEnvManagerModel getModel() {
        return this.model;
    }

    private DefaultNutsWorkspaceConfigModel _configModel() {
        DefaultNutsWorkspaceConfigManager config = (DefaultNutsWorkspaceConfigManager)this.session.config();
        return config.getModel();
    }
}

