/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.boot.NutsBootConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigRuntime;
import net.thevpc.nuts.spi.NutsBootDescriptor;
import net.thevpc.nuts.spi.NutsBootId;

public final class DefaultNutsWorkspaceCurrentConfig {
    private final Map<NutsStoreLocation, String> userStoreLocations = new HashMap<NutsStoreLocation, String>();
    private final Map<NutsStoreLocation, String> effStoreLocationsMap = new HashMap<NutsStoreLocation, String>();
    private final Path[] effStoreLocationPath = new Path[NutsStoreLocation.values().length];
    private final Map<NutsHomeLocation, String> homeLocations = new HashMap<NutsHomeLocation, String>();
    private final NutsWorkspace ws;
    private String name;
    private NutsId apiId;
    private NutsId bootRuntime;
    private NutsBootDescriptor runtimeBootDescriptor;
    private NutsBootDescriptor[] extensionBootDescriptors;
    private String bootRepositories;
    private String bootJavaCommand;
    private String bootJavaOptions;
    private NutsStoreLocationStrategy storeLocationStrategy;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy;
    private NutsOsFamily storeLocationLayout;
    private Boolean global;

    public DefaultNutsWorkspaceCurrentConfig(NutsWorkspace ws) {
        this.ws = ws;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceOptions c, NutsSession session) {
        String o;
        if (c.getName() != null) {
            this.name = c.getName();
        }
        if (c.getRuntimeId() != null) {
            this.setRuntimeId(c.getRuntimeId(), session);
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        if (c.getStoreLocationStrategy() != null) {
            this.storeLocationStrategy = c.getStoreLocationStrategy();
        }
        if (c.getRepositoryStoreLocationStrategy() != null) {
            this.repositoryStoreLocationStrategy = c.getRepositoryStoreLocationStrategy();
        }
        if (c.getStoreLocationLayout() != null) {
            this.storeLocationLayout = c.getStoreLocationLayout();
        }
        for (Map.Entry<NutsStoreLocation, String> entry : new NutsStoreLocationsMap(c.getStoreLocations()).toMap().entrySet()) {
            o = this.userStoreLocations.get(entry.getKey());
            if (!NutsBlankable.isBlank((String)o)) continue;
            this.userStoreLocations.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<NutsStoreLocation, String> entry : new NutsHomeLocationsMap(c.getHomeLocations()).toMap().entrySet()) {
            o = this.homeLocations.get(entry.getKey());
            if (!NutsBlankable.isBlank((String)o)) continue;
            this.homeLocations.put((NutsHomeLocation)entry.getKey(), entry.getValue());
        }
        if (this.global == null) {
            this.global = c.isGlobal();
        }
        return this;
    }

    public void setRuntimeId(String s, NutsSession session) {
        this.bootRuntime = s.contains("#") ? NutsId.of((String)s, (NutsSession)session) : NutsId.of((String)("net.thevpc.nuts:nuts-runtime#" + s), (NutsSession)session);
    }

    public DefaultNutsWorkspaceCurrentConfig mergeRuntime(NutsWorkspaceOptions c, NutsSession session) {
        if (c.getRuntimeId() != null) {
            NutsId nutsId = this.bootRuntime = c.getRuntimeId().contains("#") ? NutsId.of((String)c.getRuntimeId(), (NutsSession)session) : NutsId.of((String)("net.thevpc.nuts:nuts-runtime#" + c.getRuntimeId()), (NutsSession)session);
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig build(NutsPath workspaceLocation, NutsSession session) {
        if (this.storeLocationStrategy == null) {
            this.storeLocationStrategy = NutsStoreLocationStrategy.EXPLODED;
        }
        if (this.repositoryStoreLocationStrategy == null) {
            this.repositoryStoreLocationStrategy = NutsStoreLocationStrategy.EXPLODED;
        }
        Map storeLocations = NutsUtilPlatforms.buildLocations((NutsOsFamily)this.getStoreLocationLayout(), (NutsStoreLocationStrategy)this.storeLocationStrategy, this.getStoreLocations(), this.homeLocations, (boolean)this.isGlobal(), (String)workspaceLocation.toString(), (NutsSession)session);
        this.effStoreLocationsMap.clear();
        this.effStoreLocationsMap.putAll(storeLocations);
        for (int i = 0; i < this.effStoreLocationPath.length; ++i) {
            this.effStoreLocationPath[i] = Paths.get(this.effStoreLocationsMap.get(NutsStoreLocation.values()[i]), new String[0]);
        }
        if (this.apiId == null) {
            this.apiId = NutsId.of((String)("net.thevpc.nuts:nuts#" + Nuts.getVersion()), (NutsSession)session);
        }
        if (this.storeLocationLayout == null) {
            this.storeLocationLayout = session.env().getOsFamily();
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceConfigApi c, NutsSession session) {
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        if (c.getApiVersion() != null) {
            this.apiId = parser.parse("net.thevpc.nuts:nuts#" + c.getApiVersion());
        }
        if (c.getRuntimeId() != null) {
            NutsId nutsId = this.bootRuntime = c.getRuntimeId().contains("#") ? parser.parse(c.getRuntimeId()) : parser.parse("net.thevpc.nuts:nuts-runtime#" + c.getRuntimeId());
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceConfigRuntime c, NutsSession session) {
        if (c.getId() != null) {
            this.bootRuntime = NutsId.of((String)c.getId(), (NutsSession)session);
        }
        if (c.getDependencies() != null) {
            this.runtimeBootDescriptor = new NutsBootDescriptor(NutsBootId.parse((String)this.bootRuntime.toString()), (NutsBootId[])Arrays.stream(c.getDependencies().split(";")).map(NutsBootId::parse).toArray(NutsBootId[]::new));
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsWorkspaceConfigBoot c, NutsSession session) {
        String o;
        if (c.getName() != null) {
            this.name = c.getName();
        }
        if (c.getStoreLocationStrategy() != null) {
            this.storeLocationStrategy = c.getStoreLocationStrategy();
        }
        if (c.getRepositoryStoreLocationStrategy() != null) {
            this.repositoryStoreLocationStrategy = c.getRepositoryStoreLocationStrategy();
        }
        if (c.getStoreLocationLayout() != null) {
            this.storeLocationLayout = c.getStoreLocationLayout();
        }
        for (Map.Entry<NutsStoreLocation, String> entry : new NutsStoreLocationsMap(c.getStoreLocations()).toMap().entrySet()) {
            o = this.userStoreLocations.get(entry.getKey());
            if (!NutsBlankable.isBlank((String)o)) continue;
            this.userStoreLocations.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<NutsStoreLocation, String> entry : new NutsHomeLocationsMap(c.getHomeLocations()).toMap().entrySet()) {
            o = this.homeLocations.get(entry.getKey());
            if (!NutsBlankable.isBlank((String)o)) continue;
            this.homeLocations.put((NutsHomeLocation)entry.getKey(), entry.getValue());
        }
        if (this.global == null) {
            this.global = c.isGlobal();
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig merge(NutsBootConfig c, NutsSession session) {
        String o;
        this.name = c.getName();
        NutsIdParser parser = NutsIdParser.of((NutsSession)session);
        if (c.getApiVersion() != null) {
            this.apiId = parser.parse("net.thevpc.nuts:nuts#" + c.getApiVersion());
        }
        if (c.getRuntimeId() != null) {
            NutsId nutsId = this.bootRuntime = c.getRuntimeId().contains("#") ? parser.parse(c.getRuntimeId()) : parser.parse("net.thevpc.nuts:nuts-runtime#" + c.getRuntimeId());
        }
        if (c.getRuntimeBootDescriptor() != null) {
            this.runtimeBootDescriptor = c.getRuntimeBootDescriptor();
        }
        if (c.getExtensionBootDescriptors() != null) {
            this.extensionBootDescriptors = c.getExtensionBootDescriptors();
        }
        if (c.getBootRepositories() != null) {
            this.bootRepositories = c.getBootRepositories();
        }
        if (c.getJavaCommand() != null) {
            this.bootJavaCommand = c.getJavaCommand();
        }
        if (c.getJavaOptions() != null) {
            this.bootJavaOptions = c.getJavaOptions();
        }
        if (c.getStoreLocationStrategy() != null) {
            this.storeLocationStrategy = c.getStoreLocationStrategy();
        }
        if (c.getRepositoryStoreLocationStrategy() != null) {
            this.repositoryStoreLocationStrategy = c.getRepositoryStoreLocationStrategy();
        }
        if (c.getStoreLocationLayout() != null) {
            this.storeLocationLayout = c.getStoreLocationLayout();
        }
        for (Map.Entry<NutsStoreLocation, String> entry : new NutsStoreLocationsMap(c.getStoreLocations()).toMap().entrySet()) {
            o = this.userStoreLocations.get(entry.getKey());
            if (!NutsBlankable.isBlank((String)o)) continue;
            this.userStoreLocations.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<NutsStoreLocation, String> entry : new NutsHomeLocationsMap(c.getHomeLocations()).toMap().entrySet()) {
            o = this.homeLocations.get(entry.getKey());
            if (!NutsBlankable.isBlank((String)o)) continue;
            this.homeLocations.put((NutsHomeLocation)entry.getKey(), entry.getValue());
        }
        if (this.global == null) {
            this.global = c.isGlobal();
        }
        return this;
    }

    public NutsBootDescriptor[] getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public DefaultNutsWorkspaceCurrentConfig setExtensionBootDescriptors(NutsBootDescriptor[] extensionBootDescriptors) {
        this.extensionBootDescriptors = extensionBootDescriptors;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DefaultNutsWorkspaceCurrentConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isGlobal() {
        return this.global != null && this.global != false;
    }

    public DefaultNutsWorkspaceCurrentConfig setGlobal(boolean global) {
        this.global = global;
        return this;
    }

    public String getApiVersion() {
        return this.getApiId().getVersion().getValue();
    }

    public NutsId getApiId() {
        return this.apiId;
    }

    public DefaultNutsWorkspaceCurrentConfig setApiId(NutsId apiId) {
        this.apiId = apiId;
        return this;
    }

    public NutsId getRuntimeId() {
        return this.bootRuntime;
    }

    public DefaultNutsWorkspaceCurrentConfig setRuntimeId(NutsId bootRuntime) {
        this.bootRuntime = bootRuntime;
        return this;
    }

    public NutsBootDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public DefaultNutsWorkspaceCurrentConfig setRuntimeBootDescriptor(NutsBootDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public String getBootRepositories() {
        return this.bootRepositories;
    }

    public DefaultNutsWorkspaceCurrentConfig setBootRepositories(String bootRepositories) {
        this.bootRepositories = bootRepositories;
        return this;
    }

    public String getJavaCommand() {
        return this.bootJavaCommand;
    }

    public String getJavaOptions() {
        return this.bootJavaOptions;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public DefaultNutsWorkspaceCurrentConfig setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public DefaultNutsWorkspaceCurrentConfig setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy repositoryStoreLocationStrategy) {
        this.repositoryStoreLocationStrategy = repositoryStoreLocationStrategy;
        return this;
    }

    public Map<NutsStoreLocation, String> getStoreLocations() {
        return new LinkedHashMap<NutsStoreLocation, String>(this.effStoreLocationsMap);
    }

    public Map<NutsHomeLocation, String> getHomeLocations() {
        return new LinkedHashMap<NutsHomeLocation, String>(this.homeLocations);
    }

    public DefaultNutsWorkspaceCurrentConfig setHomeLocations(Map<NutsHomeLocation, String> homeLocations) {
        this.homeLocations.clear();
        if (homeLocations != null) {
            this.homeLocations.putAll(homeLocations);
        }
        return this;
    }

    public NutsPath getStoreLocation(NutsStoreLocation folderType, NutsSession session) {
        Path p = this.effStoreLocationPath[folderType.ordinal()];
        return p == null ? null : NutsPath.of((Path)p, (NutsSession)session);
    }

    public NutsPath getHomeLocation(NutsHomeLocation location, NutsSession session) {
        String s = new NutsHomeLocationsMap(this.homeLocations).get(location);
        return s == null ? null : NutsPath.of((String)s, (NutsSession)session);
    }

    public NutsPath getHomeLocation(NutsStoreLocation folderType, NutsSession session) {
        return NutsPath.of((Path)Paths.get(NutsUtilPlatforms.getPlatformHomeFolder((NutsOsFamily)this.getStoreLocationLayout(), (NutsStoreLocation)folderType, this.getHomeLocations(), (boolean)this.isGlobal(), (String)this.getName()), new String[0]), (NutsSession)session);
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public DefaultNutsWorkspaceCurrentConfig setStoreLocationLayout(NutsOsFamily storeLocationLayout) {
        this.storeLocationLayout = storeLocationLayout;
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig setUserStoreLocations(Map<NutsStoreLocation, String> userStoreLocations) {
        this.userStoreLocations.clear();
        if (userStoreLocations != null) {
            this.userStoreLocations.putAll(userStoreLocations);
        }
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig setBootJavaCommand(String bootJavaCommand) {
        this.bootJavaCommand = bootJavaCommand;
        return this;
    }

    public DefaultNutsWorkspaceCurrentConfig setBootJavaOptions(String bootJavaOptions) {
        this.bootJavaOptions = bootJavaOptions;
        return this;
    }

    public NutsPath getStoreLocation(String id, NutsStoreLocation folderType, NutsSession session) {
        return this.getStoreLocation(NutsId.of((String)id, (NutsSession)session), folderType, session);
    }

    public NutsPath getStoreLocation(NutsId id, NutsStoreLocation folderType, NutsSession session) {
        NutsPath storeLocation = this.getStoreLocation(folderType, session);
        if (storeLocation == null) {
            return null;
        }
        switch (folderType) {
            case CACHE: {
                return storeLocation.resolve("id").resolve(session.locations().getDefaultIdBasedir(id));
            }
            case CONFIG: {
                return storeLocation.resolve("id").resolve(session.locations().getDefaultIdBasedir(id));
            }
        }
        return storeLocation.resolve(session.locations().getDefaultIdBasedir(id));
    }
}

