/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsBootManager;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExtensionNotFoundException;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryManager;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceStoredConfig;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootManager;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootModel;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.dependency.solver.NutsDependencySolverUtils;
import net.thevpc.nuts.runtime.standalone.descriptor.parser.NutsDescriptorContentResolver;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.standalone.extension.NutsExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.io.path.NutsPathFromSPI;
import net.thevpc.nuts.runtime.standalone.io.path.spi.ClassLoaderPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.DotfilefsPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.FilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.GenericFilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.GithubfsPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.InvalidFilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NutsResourcePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.HtmlfsPath;
import net.thevpc.nuts.runtime.standalone.io.terminal.AbstractSystemTerminalAdapter;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNutsSessionTerminalFromSystem;
import net.thevpc.nuts.runtime.standalone.io.terminal.UnmodifiableSessionTerminal;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.repository.util.NutsRepositoryUtils;
import net.thevpc.nuts.runtime.standalone.security.ReadOnlyNutsWorkspaceOptions;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.TimePeriod;
import net.thevpc.nuts.runtime.standalone.workspace.CoreNutsBootOptions;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceVarExpansionFunction;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultImportManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsPlatformManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceBootConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceCurrentConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DummyNutsIndexStoreFactory;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.CompatUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.NutsVersionCompat;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v502.NutsVersionCompat502;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v506.NutsVersionCompat506;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v507.NutsVersionCompat507;
import net.thevpc.nuts.runtime.standalone.workspace.config.compat.v803.NutsVersionCompat803;
import net.thevpc.nuts.spi.NutsAuthenticationAgent;
import net.thevpc.nuts.spi.NutsBootDescriptor;
import net.thevpc.nuts.spi.NutsDependencySolver;
import net.thevpc.nuts.spi.NutsDependencySolverFactory;
import net.thevpc.nuts.spi.NutsIndexStoreFactory;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;
import net.thevpc.nuts.spi.NutsRepositoryDB;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import net.thevpc.nuts.spi.NutsRepositorySelectorList;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;
import net.thevpc.nuts.spi.NutsWorkspaceArchetypeComponent;

public class DefaultNutsWorkspaceConfigModel {
    private final DefaultNutsWorkspace ws;
    private final Map<String, NutsUserConfig> configUsers = new LinkedHashMap<String, NutsUserConfig>();
    private final NutsWorkspaceStoredConfig storedConfig = new NutsWorkspaceStoredConfigImpl();
    private final ClassLoader bootClassLoader;
    private final URL[] bootClassWorldURLs;
    private final Function<String, String> pathExpansionConverter;
    private final WorkspaceSystemTerminalAdapter workspaceSystemTerminalAdapter;
    private final List<NutsPathFactory> pathFactories = new ArrayList<NutsPathFactory>();
    private final NutsPathFactory invalidPathFactory;
    private final DefaultNutsBootModel bootModel;
    protected NutsWorkspaceConfigBoot storeModelBoot = new NutsWorkspaceConfigBoot();
    protected NutsWorkspaceConfigApi storeModelApi = new NutsWorkspaceConfigApi();
    protected NutsWorkspaceConfigRuntime storeModelRuntime = new NutsWorkspaceConfigRuntime();
    protected NutsWorkspaceConfigSecurity storeModelSecurity = new NutsWorkspaceConfigSecurity();
    protected NutsWorkspaceConfigMain storeModelMain = new NutsWorkspaceConfigMain();
    protected Map<String, NutsDependencySolverFactory> dependencySolvers;
    private NutsLogger LOG;
    private DefaultNutsWorkspaceCurrentConfig currentConfig;
    private boolean storeModelBootChanged = false;
    private boolean storeModelApiChanged = false;
    private boolean storeModelRuntimeChanged = false;
    private boolean storeModelSecurityChanged = false;
    private boolean storeModelMainChanged = false;
    private long startCreateTime;
    private long endCreateTime;
    private NutsIndexStoreFactory indexStoreClientFactory;
    private NutsStoreLocationsMap preUpdateConfigStoreLocations;
    private NutsRepositorySelectorList parsedBootRepositoriesList;
    private ExecutorService executorService;
    private NutsSessionTerminal terminal;

    public DefaultNutsWorkspaceConfigModel(DefaultNutsWorkspace ws) {
        this.ws = ws;
        CoreNutsBootOptions bOptions = NutsWorkspaceExt.of((NutsWorkspace)ws).getModel().bootModel.getCoreBootOptions();
        this.bootClassLoader = bOptions.getClassWorldLoader() == null ? Thread.currentThread().getContextClassLoader() : bOptions.getClassWorldLoader();
        this.bootClassWorldURLs = bOptions.getClassWorldURLs() == null ? null : Arrays.copyOf(bOptions.getClassWorldURLs(), bOptions.getClassWorldURLs().length);
        this.workspaceSystemTerminalAdapter = new WorkspaceSystemTerminalAdapter(ws);
        this.pathExpansionConverter = new NutsWorkspaceVarExpansionFunction(NutsWorkspaceUtils.defaultSession(ws));
        this.bootModel = (DefaultNutsBootModel)((DefaultNutsBootManager)ws.boot()).getModel();
        this.addPathFactory(new FilePath.FilePathFactory(ws));
        this.addPathFactory(new ClassLoaderPath.ClasspathFactory(ws));
        this.addPathFactory(new URLPath.URLPathFactory(ws));
        this.addPathFactory(new NutsResourcePath.NutsResourceFactory(ws));
        this.addPathFactory(new HtmlfsPath.HtmlfsFactory(ws));
        this.addPathFactory(new DotfilefsPath.DotfilefsFactory(ws));
        this.addPathFactory(new GithubfsPath.GithubfsFactory(ws));
        this.addPathFactory(new GenericFilePath.GenericPathFactory(ws));
        this.invalidPathFactory = new InvalidFilePathFactory();
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(DefaultNutsWorkspaceConfigModel.class, (NutsSession)session);
        }
        return this.LOG;
    }

    public DefaultNutsWorkspaceCurrentConfig getCurrentConfig() {
        return this.currentConfig;
    }

    public void setCurrentConfig(DefaultNutsWorkspaceCurrentConfig currentConfig) {
        this.currentConfig = currentConfig;
    }

    public NutsWorkspaceStoredConfig stored() {
        return this.storedConfig;
    }

    public ClassLoader getBootClassLoader() {
        return this.bootClassLoader;
    }

    public URL[] getBootClassWorldURLs() {
        return this.bootClassWorldURLs == null ? null : Arrays.copyOf(this.bootClassWorldURLs, this.bootClassWorldURLs.length);
    }

    public boolean isReadOnly() {
        CoreNutsBootOptions bOptions = NutsWorkspaceExt.of((NutsWorkspace)this.ws).getModel().bootModel.getCoreBootOptions();
        return bOptions.getOptions().isReadOnly();
    }

    public boolean save(boolean force, NutsSession session) {
        if (!force && !this.isConfigurationChanged()) {
            return false;
        }
        NutsWorkspaceUtils.of(session).checkReadOnly();
        NutsWorkspaceUtils.checkSession(this.ws, session);
        boolean ok = false;
        session.security().checkAllowed("save", "save");
        NutsPath apiVersionSpecificLocation = session.locations().getStoreLocation(session.getWorkspace().getApiId(), NutsStoreLocation.CONFIG);
        NutsElements elem = NutsElements.of((NutsSession)session);
        if (force || this.storeModelBootChanged) {
            Path file = session.locations().getWorkspaceLocation().toFile().resolve("nuts-workspace.json");
            this.storeModelBoot.setConfigVersion("0.8.0");
            if (this.storeModelBoot.getExtensions() != null) {
                for (NutsWorkspaceConfigBoot.ExtensionConfig extensionConfig : this.storeModelBoot.getExtensions()) {
                    extensionConfig.setConfigVersion(null);
                }
            }
            elem.json().setValue((Object)this.storeModelBoot).setNtf(false).print(file);
            this.storeModelBootChanged = false;
            ok = true;
        }
        NutsPath configVersionSpecificLocation = session.locations().getStoreLocation(session.getWorkspace().getApiId(), NutsStoreLocation.CONFIG);
        if (force || this.storeModelSecurityChanged) {
            this.storeModelSecurity.setUsers(this.configUsers.isEmpty() ? null : this.configUsers.values().toArray(new NutsUserConfig[0]));
            NutsPath file = configVersionSpecificLocation.resolve("nuts-security-config.json");
            this.storeModelSecurity.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelSecurity.getUsers() != null) {
                for (NutsUserConfig extension : this.storeModelSecurity.getUsers()) {
                    extension.setConfigVersion(null);
                }
            }
            elem.setSession(session).json().setValue((Object)this.storeModelSecurity).setNtf(false).print(file);
            this.storeModelSecurityChanged = false;
            ok = true;
        }
        if (force || this.storeModelMainChanged) {
            ArrayList<NutsPlatformLocation> plainSdks = new ArrayList<NutsPlatformLocation>();
            plainSdks.addAll(Arrays.asList(session.env().platforms().findPlatforms()));
            this.storeModelMain.setPlatforms(plainSdks);
            this.storeModelMain.setRepositories(new ArrayList<NutsRepositoryRef>(Arrays.stream(session.repos().getRepositories()).filter(x -> !x.config().isTemporary()).map(x -> x.config().getRepositoryRef()).collect(Collectors.toList())));
            NutsPath nutsPath = configVersionSpecificLocation.resolve("nuts-main-config.json");
            this.storeModelMain.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelMain.getCommandFactories() != null) {
                for (NutsCommandFactoryConfig item : this.storeModelMain.getCommandFactories()) {
                    item.setConfigVersion(null);
                }
            }
            if (this.storeModelMain.getRepositories() != null) {
                for (NutsRepositoryRef item : this.storeModelMain.getRepositories()) {
                    item.setConfigVersion(null);
                }
            }
            if (this.storeModelMain.getPlatforms() != null) {
                for (NutsPlatformLocation item : this.storeModelMain.getPlatforms()) {
                    item.setConfigVersion(null);
                }
            }
            elem.setSession(session).json().setValue((Object)this.storeModelMain).setNtf(false).print(nutsPath);
            this.storeModelMainChanged = false;
            ok = true;
        }
        if (force || this.storeModelApiChanged) {
            NutsPath afile = apiVersionSpecificLocation.resolve("nuts-api-boot-config.json");
            this.storeModelApi.setConfigVersion(this.current().getApiVersion());
            if (this.storeModelSecurity.getUsers() != null) {
                for (NutsUserConfig item : this.storeModelSecurity.getUsers()) {
                    item.setConfigVersion(null);
                }
            }
            elem.setSession(session).json().setValue((Object)this.storeModelApi).setNtf(false).print(afile);
            this.storeModelApiChanged = false;
            ok = true;
        }
        if (force || this.storeModelRuntimeChanged) {
            NutsPath runtimeVersionSpecificLocation = session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("id").resolve(session.locations().getDefaultIdBasedir(session.getWorkspace().getRuntimeId()));
            NutsPath nutsPath = runtimeVersionSpecificLocation.resolve("nuts-runtime-boot-config.json");
            this.storeModelRuntime.setConfigVersion(this.current().getApiVersion());
            elem.setSession(session).json().setValue((Object)this.storeModelRuntime).setNtf(false).print(nutsPath);
            this.storeModelRuntimeChanged = false;
            ok = true;
        }
        NutsException error = null;
        for (NutsRepository repo : session.repos().getRepositories()) {
            try {
                if (!(repo.config() instanceof NutsRepositoryConfigManagerExt)) continue;
                ok |= ((NutsRepositoryConfigManagerExt)repo.config()).getModel().save(force, session);
            }
            catch (NutsException ex) {
                error = ex;
            }
        }
        if (error != null) {
            throw error;
        }
        return ok;
    }

    public boolean save(NutsSession session) {
        return this.save(true, session);
    }

    public NutsWorkspaceBootConfig loadBootConfig(String _ws, boolean global, boolean followLinks, NutsSession session) {
        String _ws0 = _ws;
        String effWorkspaceName = null;
        String lastConfigPath = null;
        NutsWorkspaceConfigBoot lastConfigLoaded = null;
        boolean defaultLocation = false;
        if (_ws != null && _ws.matches("[a-z-]+://.*")) {
            effWorkspaceName = "remote-bootstrap";
            lastConfigPath = NutsUtilPlatforms.getWorkspaceLocation(null, (boolean)global, (String)CoreNutsUtils.resolveValidWorkspaceName(effWorkspaceName));
            lastConfigLoaded = this.parseBootConfig(NutsPath.of((String)lastConfigPath, (NutsSession)session), session);
            defaultLocation = true;
            return new DefaultNutsWorkspaceBootConfig(session, _ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
        }
        if (followLinks) {
            NutsWorkspaceConfigBoot configLoaded;
            defaultLocation = CoreNutsUtils.isValidWorkspaceName(_ws);
            int maxDepth = 36;
            for (int i = 0; i < maxDepth && (configLoaded = this.parseBootConfig(NutsPath.of((String)(lastConfigPath = CoreNutsUtils.isValidWorkspaceName(_ws) ? NutsUtilPlatforms.getWorkspaceLocation(null, (boolean)global, (String)CoreNutsUtils.resolveValidWorkspaceName(_ws)) : CoreIOUtils.getAbsolutePath(_ws)), (NutsSession)session), session)) != null; ++i) {
                if (NutsBlankable.isBlank((String)configLoaded.getWorkspace())) {
                    lastConfigLoaded = configLoaded;
                    break;
                }
                _ws = configLoaded.getWorkspace();
                if (i < maxDepth - 1) continue;
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cyclic workspace resolution", (Object[])new Object[0]));
            }
            if (lastConfigLoaded == null) {
                return null;
            }
            effWorkspaceName = CoreNutsUtils.resolveValidWorkspaceName(_ws);
            return new DefaultNutsWorkspaceBootConfig(session, _ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
        }
        defaultLocation = CoreNutsUtils.isValidWorkspaceName(_ws);
        lastConfigPath = CoreNutsUtils.isValidWorkspaceName(_ws) ? NutsUtilPlatforms.getWorkspaceLocation(null, (boolean)global, (String)CoreNutsUtils.resolveValidWorkspaceName(_ws)) : CoreIOUtils.getAbsolutePath(_ws);
        lastConfigLoaded = this.parseBootConfig(NutsPath.of((String)lastConfigPath, (NutsSession)session), session);
        if (lastConfigLoaded == null) {
            return null;
        }
        effWorkspaceName = CoreNutsUtils.resolveValidWorkspaceName(_ws);
        return new DefaultNutsWorkspaceBootConfig(session, _ws0, lastConfigPath, effWorkspaceName, defaultLocation, lastConfigLoaded);
    }

    public boolean isExcludedExtension(String extensionId, NutsWorkspaceOptions options, NutsSession session) {
        if (extensionId != null && options != null) {
            NutsId pnid = NutsId.of((String)extensionId, (NutsSession)session);
            String shortName = pnid.getShortName();
            String artifactId = pnid.getArtifactId();
            for (String excludedExtensionList : options.getExcludedExtensions()) {
                for (String s : excludedExtensionList.split("[;, ]")) {
                    if (s.length() <= 0 || !s.equals(shortName) && !s.equals(artifactId)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public NutsWorkspaceOptions getOptions(NutsSession session) {
        CoreNutsBootOptions bOptions = NutsWorkspaceExt.of((NutsWorkspace)this.ws).getModel().bootModel.getCoreBootOptions();
        return new ReadOnlyNutsWorkspaceOptions(bOptions.getOptions(), session);
    }

    public boolean isSupportedRepositoryType(String repositoryType, NutsSession session) {
        if (NutsBlankable.isBlank((String)repositoryType)) {
            repositoryType = "nuts";
        }
        return session.extensions().createAllSupported(NutsRepositoryFactoryComponent.class, (Object)new NutsRepositoryConfig().setLocation(NutsRepositoryLocation.of((String)(repositoryType + "@")))).size() > 0;
    }

    public NutsAddRepositoryOptions[] getDefaultRepositories(NutsSession session) {
        ArrayList<NutsAddRepositoryOptions> all = new ArrayList<NutsAddRepositoryOptions>();
        for (NutsRepositoryFactoryComponent provider : session.extensions().createAll(NutsRepositoryFactoryComponent.class)) {
            for (NutsAddRepositoryOptions d : provider.getDefaultRepositories(session)) {
                all.add(d);
            }
        }
        Collections.sort(all, new Comparator<NutsAddRepositoryOptions>(){

            @Override
            public int compare(NutsAddRepositoryOptions o1, NutsAddRepositoryOptions o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
        return all.toArray(new NutsAddRepositoryOptions[0]);
    }

    public Set<String> getAvailableArchetypes(NutsSession session) {
        HashSet<String> set = new HashSet<String>();
        set.add("default");
        for (NutsWorkspaceArchetypeComponent extension : session.extensions().createAllSupported(NutsWorkspaceArchetypeComponent.class, null)) {
            set.add(extension.getName());
        }
        return set;
    }

    public NutsPath resolveRepositoryPath(NutsPath repositoryLocation, NutsSession session) {
        NutsPath root = this.getRepositoriesRoot(session);
        return repositoryLocation.toAbsolute(root != null ? root : session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("repos"));
    }

    public NutsIndexStoreFactory getIndexStoreClientFactory() {
        return this.indexStoreClientFactory;
    }

    public String getBootRepositories() {
        return this.current().getBootRepositories();
    }

    public String getJavaCommand() {
        return this.current().getJavaCommand();
    }

    public String getJavaOptions() {
        return this.current().getJavaOptions();
    }

    public boolean isGlobal() {
        return this.current().isGlobal();
    }

    public long getCreationStartTimeMillis() {
        return this.startCreateTime;
    }

    public long getCreationFinishTimeMillis() {
        return this.endCreateTime;
    }

    public long getCreationTimeMillis() {
        return this.endCreateTime - this.startCreateTime;
    }

    public NutsWorkspaceConfigMain getStoreModelMain() {
        return this.storeModelMain;
    }

    public DefaultNutsWorkspaceCurrentConfig current() {
        if (this.currentConfig == null) {
            throw new IllegalStateException("unable to use workspace.current(). Still in initialize status");
        }
        return this.currentConfig;
    }

    public void setStartCreateTimeMillis(long startCreateTime) {
        this.startCreateTime = startCreateTime;
    }

    public void setConfigBoot(NutsWorkspaceConfigBoot config, NutsSession options) {
        this.setConfigBoot(config, options, true);
    }

    public void setConfigApi(NutsWorkspaceConfigApi config, NutsSession session) {
        this.setConfigApi(config, session, true);
    }

    public void setConfigRuntime(NutsWorkspaceConfigRuntime config, NutsSession options) {
        this.setConfigRuntime(config, options, true);
    }

    public void setConfigSecurity(NutsWorkspaceConfigSecurity config, NutsSession session) {
        this.setConfigSecurity(config, session, true);
    }

    public void setConfigMain(NutsWorkspaceConfigMain config, NutsSession session) {
        this.setConfigMain(config, session, true);
    }

    public void setEndCreateTimeMillis(long endCreateTime) {
        this.endCreateTime = endCreateTime;
    }

    public void installBootIds(NutsSession session) {
        NutsWorkspaceModel wsModel = NutsWorkspaceExt.of(this.ws).getModel();
        NutsBootDescriptor d = wsModel.bootModel.getCoreBootOptions().getRuntimeBootDescriptor();
        NutsId iruntimeId = NutsId.of((String)d.getId().toString(), (NutsSession)session);
        wsModel.configModel.prepareBootClassPathConf(NutsIdType.API, this.ws.getApiId(), null, iruntimeId, false, false, session);
        wsModel.configModel.prepareBootClassPathJar(this.ws.getApiId(), null, iruntimeId, false, session);
        wsModel.configModel.prepareBootClassPathConf(NutsIdType.RUNTIME, iruntimeId, this.ws.getApiId(), null, false, true, session);
        wsModel.configModel.prepareBootClassPathJar(iruntimeId, this.ws.getApiId(), null, true, session);
        List<NutsWorkspaceConfigBoot.ExtensionConfig> extensions = this.getStoredConfigBoot().getExtensions();
        if (extensions != null) {
            for (NutsWorkspaceConfigBoot.ExtensionConfig extension : extensions) {
                if (!extension.isEnabled()) continue;
                wsModel.configModel.prepareBootClassPathConf(NutsIdType.EXTENSION, extension.getId(), this.ws.getApiId(), null, false, true, session);
                wsModel.configModel.prepareBootClassPathJar(extension.getId(), this.ws.getApiId(), null, true, session);
            }
        }
    }

    public boolean isConfigurationChanged() {
        return this.storeModelBootChanged || this.storeModelApiChanged || this.storeModelRuntimeChanged || this.storeModelSecurityChanged || this.storeModelMainChanged;
    }

    public boolean loadWorkspace(NutsSession session) {
        try {
            NutsWorkspaceConfigRuntime rconfig;
            NutsWorkspaceUtils.checkSession(this.ws, session);
            NutsWorkspaceConfigBoot _config = this.parseBootConfig(session);
            if (_config == null) {
                return false;
            }
            DefaultNutsWorkspaceCurrentConfig cConfig = new DefaultNutsWorkspaceCurrentConfig(this.ws).merge(_config, session);
            CoreNutsBootOptions bOptions = NutsWorkspaceExt.of((NutsWorkspace)this.ws).getModel().bootModel.getCoreBootOptions();
            if (cConfig.getApiId() == null) {
                cConfig.setApiId(NutsId.of((String)("net.thevpc.nuts:nuts#" + bOptions.getApiVersion()), (NutsSession)session));
            }
            if (cConfig.getRuntimeId() == null) {
                cConfig.setRuntimeId(bOptions.getRuntimeId().toString(), session);
            }
            if (cConfig.getRuntimeBootDescriptor() == null) {
                cConfig.setRuntimeBootDescriptor(bOptions.getRuntimeBootDescriptor());
            }
            if (cConfig.getExtensionBootDescriptors() == null) {
                cConfig.setExtensionBootDescriptors(bOptions.getExtensionBootDescriptors());
            }
            if (cConfig.getBootRepositories() == null) {
                cConfig.setBootRepositories(bOptions.getBootRepositories());
            }
            cConfig.merge(this.getOptions(session), session);
            this.setCurrentConfig(cConfig.build(session.locations().getWorkspaceLocation(), session));
            NutsVersionCompat compat = this.createNutsVersionCompat(Nuts.getVersion(), session);
            NutsWorkspaceConfigApi aconfig = compat.parseApiConfig(session);
            if (aconfig != null) {
                cConfig.merge(aconfig, session);
            }
            if ((rconfig = compat.parseRuntimeConfig(session)) != null) {
                cConfig.merge(rconfig, session);
            }
            NutsWorkspaceConfigSecurity sconfig = compat.parseSecurityConfig(session);
            NutsWorkspaceConfigMain mconfig = compat.parseMainConfig(session);
            if (bOptions.getOptions().isRecover() || bOptions.getOptions().isReset()) {
                cConfig.setApiId(NutsId.of((String)("net.thevpc.nuts:nuts#" + bOptions.getApiVersion()), (NutsSession)session));
                cConfig.setRuntimeId(bOptions.getRuntimeId() == null ? null : bOptions.getRuntimeId().toString(), session);
                cConfig.setRuntimeBootDescriptor(bOptions.getRuntimeBootDescriptor());
                cConfig.setExtensionBootDescriptors(bOptions.getExtensionBootDescriptors());
                cConfig.setBootRepositories(bOptions.getBootRepositories());
            }
            this.setCurrentConfig(cConfig.build(session.locations().getWorkspaceLocation(), session));
            this.setConfigBoot(_config, session, false);
            this.setConfigApi(aconfig, session, false);
            this.setConfigRuntime(rconfig, session, false);
            this.setConfigSecurity(sconfig, session, false);
            this.setConfigMain(mconfig, session, false);
            this.storeModelBootChanged = false;
            this.storeModelApiChanged = false;
            this.storeModelRuntimeChanged = false;
            this.storeModelSecurityChanged = false;
            this.storeModelMainChanged = false;
            return true;
        }
        catch (RuntimeException ex) {
            if (!session.boot().getBootOptions().isRecover()) {
                throw ex;
            }
            this.onLoadWorkspaceError(ex, session);
            return false;
        }
    }

    public void setBootApiVersion(String value, NutsSession session) {
        if (!Objects.equals(value, this.storeModelApi.getApiVersion())) {
            this.storeModelApi.setApiVersion(value);
            this.fireConfigurationChanged("api-version", session, ConfigEventType.API);
        }
    }

    public void setExtraBootExtensionId(NutsId apiId, NutsId extensionId, NutsDependency[] deps, NutsSession session) {
        String newDeps = Arrays.stream(deps).map(Object::toString).collect(Collectors.joining(";"));
        NutsWorkspaceConfigBoot.ExtensionConfig cc = new NutsWorkspaceConfigBoot.ExtensionConfig();
        cc.setId(apiId);
        cc.setDependencies(newDeps);
        cc.setEnabled(true);
        if (apiId.getVersion().equals(session.getWorkspace().getApiId().getVersion())) {
            NutsExtensionListHelper h = new NutsExtensionListHelper(session.getWorkspace().getApiId(), this.getStoredConfigBoot().getExtensions()).save();
            if (h.add(extensionId, deps)) {
                this.getStoredConfigBoot().setExtensions(h.getConfs());
                NutsWorkspaceExt.of(this.ws).deployBoot(session, extensionId, true);
                this.fireConfigurationChanged("extensions", session, ConfigEventType.BOOT);
                DefaultNutsWorkspaceConfigModel configModel = NutsWorkspaceExt.of((NutsSession)session).getModel().configModel;
                configModel.save(session);
            }
        } else {
            NutsExtensionListHelper h2 = new NutsExtensionListHelper(session.getWorkspace().getApiId(), new ArrayList<NutsWorkspaceConfigBoot.ExtensionConfig>());
            if (h2.add(extensionId, deps)) {
                NutsWorkspaceExt.of(this.ws).deployBoot(session, extensionId, true);
            }
        }
        NutsPath runtimeVersionSpecificLocation = session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("id").resolve(session.locations().getDefaultIdBasedir(extensionId));
        NutsPath afile = runtimeVersionSpecificLocation.resolve("nuts-extension-boot-config.json");
        cc.setConfigVersion(this.current().getApiVersion());
        NutsElements.of((NutsSession)session).json().setValue((Object)cc).setNtf(false).print(afile);
    }

    public void setExtraBootRuntimeId(NutsId apiId, NutsId runtimeId, NutsDependency[] deps, NutsSession session) {
        String newDeps = Arrays.stream(deps).map(Object::toString).collect(Collectors.joining(";"));
        if (apiId == null || apiId.getVersion().equals(session.getWorkspace().getApiId().getVersion())) {
            if (!Objects.equals(runtimeId.toString(), this.storeModelApi.getRuntimeId()) || !Objects.equals(newDeps, this.storeModelRuntime.getDependencies())) {
                this.storeModelApi.setRuntimeId(runtimeId.toString());
                this.storeModelRuntime.setDependencies(newDeps);
                this.setConfigRuntime(this.storeModelRuntime, session, true);
                this.fireConfigurationChanged("runtime-id", session, ConfigEventType.API);
            }
            this.setBootRuntimeId(runtimeId.toString(), newDeps, session);
            this.save(session);
            return;
        }
        NutsWorkspaceConfigApi estoreModelApi = new NutsWorkspaceConfigApi();
        estoreModelApi.setApiVersion(apiId.getVersion().toString());
        estoreModelApi.setRuntimeId(runtimeId.toString());
        estoreModelApi.setConfigVersion(this.current().getApiVersion());
        NutsPath apiVersionSpecificLocation = session.locations().getStoreLocation(apiId, NutsStoreLocation.CONFIG);
        NutsPath afile = apiVersionSpecificLocation.resolve("nuts-api-boot-config.json");
        NutsElements elems = NutsElements.of((NutsSession)session);
        elems.json().setValue((Object)estoreModelApi).setNtf(false).print(afile);
        NutsWorkspaceConfigRuntime storeModelRuntime = new NutsWorkspaceConfigRuntime();
        storeModelRuntime.setId(runtimeId.toString());
        storeModelRuntime.setDependencies(newDeps);
        NutsPath runtimeVersionSpecificLocation = session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("id").resolve(session.locations().getDefaultIdBasedir(runtimeId));
        afile = runtimeVersionSpecificLocation.resolve("nuts-runtime-boot-config.json");
        storeModelRuntime.setConfigVersion(this.current().getApiVersion());
        elems.setSession(session).json().setValue((Object)storeModelRuntime).setNtf(false).print(afile);
    }

    public void setBootRuntimeId(String value, String dependencies, NutsSession session) {
        if (!Objects.equals(value, this.storeModelApi.getRuntimeId()) || !Objects.equals(dependencies, this.storeModelRuntime.getDependencies())) {
            this.storeModelApi.setRuntimeId(value);
            this.storeModelRuntime.setDependencies(dependencies);
            this.setConfigRuntime(this.storeModelRuntime, session, true);
            this.fireConfigurationChanged("runtime-id", session, ConfigEventType.API);
        }
    }

    public void setBootRuntimeDependencies(String dependencies, NutsSession session) {
        if (!Objects.equals(dependencies, this.storeModelRuntime.getDependencies())) {
            // empty if block
        }
    }

    public void setBootRepositories(String value, NutsSession session) {
        if (!Objects.equals(value, this.storeModelBoot.getBootRepositories())) {
            this.storeModelBoot.setBootRepositories(value);
            this.fireConfigurationChanged("boot-repositories", session, ConfigEventType.API);
        }
    }

    public NutsWorkspaceConfigBoot.ExtensionConfig getBootExtension(String value, NutsSession session) {
        NutsId newId = NutsId.of((String)value, (NutsSession)session);
        for (NutsWorkspaceConfigBoot.ExtensionConfig extension : this.storeModelBoot.getExtensions()) {
            NutsId id = extension.getId();
            if (!newId.equalsShortId(id)) continue;
            return extension;
        }
        return null;
    }

    public void setBootExtension(String value, String dependencies, boolean enabled, NutsSession session) {
        NutsId newId = NutsId.of((String)value, (NutsSession)session);
        for (NutsWorkspaceConfigBoot.ExtensionConfig extension : this.storeModelBoot.getExtensions()) {
            NutsId id = extension.getId();
            if (!newId.equalsShortId(id)) continue;
            extension.setId(newId);
            extension.setEnabled(enabled);
            extension.setDependencies(dependencies);
            this.fireConfigurationChanged("boot-extensions", session, ConfigEventType.API);
            return;
        }
        this.storeModelBoot.getExtensions().add(new NutsWorkspaceConfigBoot.ExtensionConfig(newId, dependencies, true));
    }

    public NutsUserConfig getUser(String userId, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        NutsUserConfig _config = this.getSecurity(userId);
        if (_config == null && ("admin".equals(userId) || "anonymous".equals(userId))) {
            _config = new NutsUserConfig(userId, null, null, null);
            this.setUser(_config, session);
        }
        return _config;
    }

    public NutsUserConfig[] getUsers(NutsSession session) {
        return this.configUsers.values().toArray(new NutsUserConfig[0]);
    }

    public void setUser(NutsUserConfig config, NutsSession session) {
        if (config != null) {
            this.configUsers.put(config.getUser(), config);
            this.fireConfigurationChanged("user", session, ConfigEventType.SECURITY);
        }
    }

    public void removeUser(String userId, NutsSession session) {
        NutsUserConfig old = this.getSecurity(userId);
        if (old != null) {
            this.configUsers.remove(userId);
            this.fireConfigurationChanged("users", session, ConfigEventType.SECURITY);
        }
    }

    public void setSecure(boolean secure, NutsSession session) {
        if (secure != this.storeModelSecurity.isSecure()) {
            this.storeModelSecurity.setSecure(secure);
            this.fireConfigurationChanged("secure", session, ConfigEventType.SECURITY);
        }
    }

    public void fireConfigurationChanged(String configName, NutsSession session, ConfigEventType t) {
        ((DefaultImportManager)session.imports()).getModel().invalidateCache();
        switch (t) {
            case API: {
                this.storeModelApiChanged = true;
                break;
            }
            case RUNTIME: {
                this.storeModelRuntimeChanged = true;
                break;
            }
            case SECURITY: {
                this.storeModelSecurityChanged = true;
                break;
            }
            case MAIN: {
                this.storeModelMainChanged = true;
                break;
            }
            case BOOT: {
                this.storeModelBootChanged = true;
            }
        }
        DefaultNutsWorkspaceEvent evt = new DefaultNutsWorkspaceEvent(session, null, "config." + configName, null, true);
        for (NutsWorkspaceListener workspaceListener : session.events().getWorkspaceListeners()) {
            workspaceListener.onConfigurationChanged((NutsWorkspaceEvent)evt);
        }
    }

    public NutsWorkspaceConfigApi getStoredConfigApi() {
        if (this.storeModelApi.getApiVersion() == null) {
            this.storeModelApi.setApiVersion(Nuts.getVersion());
        }
        return this.storeModelApi;
    }

    public NutsWorkspaceConfigBoot getStoredConfigBoot() {
        return this.storeModelBoot;
    }

    public NutsWorkspaceConfigSecurity getStoredConfigSecurity() {
        return this.storeModelSecurity;
    }

    public NutsWorkspaceConfigMain getStoredConfigMain() {
        return this.storeModelMain;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public NutsDependencySolver createDependencySolver(String name, NutsSession session) {
        NutsDependencySolverFactory c = this.getSolversMap(session).get(NutsDependencySolverUtils.resolveSolverName(name));
        if (c != null) {
            return c.create(session);
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"dependency solver not found %s", (Object[])new Object[]{name}));
    }

    private Map<String, NutsDependencySolverFactory> getSolversMap(NutsSession session) {
        if (this.dependencySolvers == null) {
            this.dependencySolvers = new LinkedHashMap<String, NutsDependencySolverFactory>();
            for (NutsDependencySolverFactory nutsDependencySolver : session.extensions().createAllSupported(NutsDependencySolverFactory.class, null)) {
                this.dependencySolvers.put(nutsDependencySolver.getName(), nutsDependencySolver);
            }
        }
        return this.dependencySolvers;
    }

    public NutsDependencySolverFactory[] getDependencySolvers(NutsSession session) {
        return this.getSolversMap(session).values().toArray(new NutsDependencySolverFactory[0]);
    }

    public NutsPath getRepositoriesRoot(NutsSession session) {
        return session.locations().getStoreLocation(NutsStoreLocation.CONFIG).resolve("repos");
    }

    public NutsPath getTempRepositoriesRoot(NutsSession session) {
        return session.locations().getStoreLocation(NutsStoreLocation.TEMP).resolve("repos");
    }

    public boolean isValidWorkspaceFolder(NutsSession session) {
        Path file = session.locations().getWorkspaceLocation().toFile().resolve("nuts-workspace.json");
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    public NutsAuthenticationAgent createAuthenticationAgent(String authenticationAgent, NutsSession session) {
        authenticationAgent = NutsUtilStrings.trim((String)authenticationAgent);
        NutsAuthenticationAgent supported = null;
        if (authenticationAgent.isEmpty()) {
            supported = (NutsAuthenticationAgent)session.extensions().createSupported(NutsAuthenticationAgent.class, true, (Object)"");
        } else {
            List agents = session.extensions().createAllSupported(NutsAuthenticationAgent.class, (Object)authenticationAgent);
            for (NutsAuthenticationAgent agent : agents) {
                if (!agent.getId().equals(authenticationAgent)) continue;
                supported = agent;
            }
        }
        if (supported == null) {
            throw new NutsExtensionNotFoundException(session, NutsAuthenticationAgent.class, (Object)authenticationAgent);
        }
        NutsWorkspaceUtils.setSession(supported, session);
        return supported;
    }

    public void setUsers(NutsUserConfig[] users, NutsSession session) {
        for (NutsUserConfig u : this.getUsers(session)) {
            this.removeUser(u.getUser(), session);
        }
        for (NutsUserConfig conf : users) {
            this.setUser(conf, session);
        }
    }

    public NutsWorkspaceConfigRuntime getStoredConfigRuntime() {
        return this.storeModelRuntime;
    }

    public NutsId createSdkId(String type, String version, NutsSession session) {
        return NutsWorkspaceUtils.of(session).createSdkId(type, version);
    }

    public void onExtensionsPrepared(NutsSession session) {
        try {
            this.indexStoreClientFactory = (NutsIndexStoreFactory)session.extensions().createSupported(NutsIndexStoreFactory.class, false, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.indexStoreClientFactory == null) {
            this.indexStoreClientFactory = new DummyNutsIndexStoreFactory();
        }
    }

    public void setConfigApi(NutsWorkspaceConfigApi config, NutsSession session, boolean fire) {
        NutsWorkspaceConfigApi nutsWorkspaceConfigApi = this.storeModelApi = config == null ? new NutsWorkspaceConfigApi() : config;
        if (fire) {
            this.fireConfigurationChanged("boot-api-config", session, ConfigEventType.API);
        }
    }

    public void setConfigRuntime(NutsWorkspaceConfigRuntime config, NutsSession session, boolean fire) {
        NutsWorkspaceConfigRuntime nutsWorkspaceConfigRuntime = this.storeModelRuntime = config == null ? new NutsWorkspaceConfigRuntime() : config;
        if (fire) {
            this.fireConfigurationChanged("boot-runtime-config", session, ConfigEventType.RUNTIME);
        }
    }

    private void setConfigSecurity(NutsWorkspaceConfigSecurity config, NutsSession session, boolean fire) {
        this.storeModelSecurity = config == null ? new NutsWorkspaceConfigSecurity() : config;
        this.configUsers.clear();
        if (this.storeModelSecurity.getUsers() != null) {
            for (NutsUserConfig s : this.storeModelSecurity.getUsers()) {
                this.configUsers.put(s.getUser(), s);
            }
        }
        this.storeModelSecurityChanged = true;
        if (fire) {
            this.fireConfigurationChanged("config-security", session, ConfigEventType.SECURITY);
        }
    }

    private void setConfigMain(NutsWorkspaceConfigMain config, NutsSession session, boolean fire) {
        this.storeModelMain = config == null ? new NutsWorkspaceConfigMain() : config;
        DefaultNutsPlatformManager d = (DefaultNutsPlatformManager)session.env().platforms();
        d.getModel().setPlatforms(this.storeModelMain.getPlatforms().toArray(new NutsPlatformLocation[0]), session);
        NutsRepositoryManager repos = session.repos();
        repos.removeAllRepositories();
        if (this.storeModelMain.getRepositories() != null) {
            for (NutsRepositoryRef ref : this.storeModelMain.getRepositories()) {
                repos.addRepository(NutsRepositoryUtils.refToOptions(ref));
            }
        }
        this.storeModelMainChanged = true;
        if (fire) {
            this.fireConfigurationChanged("config-main", session, ConfigEventType.MAIN);
        }
    }

    private void setConfigBoot(NutsWorkspaceConfigBoot config, NutsSession session, boolean fire) {
        this.storeModelBoot = config;
        if (NutsBlankable.isBlank((String)config.getUuid())) {
            config.setUuid(UUID.randomUUID().toString());
            fire = true;
        }
        if (fire) {
            this.fireConfigurationChanged("config-master", session, ConfigEventType.BOOT);
        }
    }

    public String toString() {
        String s1 = "NULL";
        String s2 = "NULL";
        s1 = this.ws.getApiId().toString();
        s2 = String.valueOf(this.ws.getRuntimeId());
        return "NutsWorkspaceConfig{workspaceBootId=" + s1 + ", workspaceRuntimeId=" + s2 + ", workspace=" + (this.currentConfig == null ? "NULL" : "'" + ((DefaultNutsWorkspaceLocationManager)NutsWorkspaceUtils.defaultSession(this.ws).locations()).getModel().getWorkspaceLocation() + '\'') + '}';
    }

    public void collect(NutsClassLoaderNode n, LinkedHashMap<String, NutsClassLoaderNode> deps) {
        if (!deps.containsKey(n.getId())) {
            deps.put(n.getId(), n);
            for (NutsClassLoaderNode d : n.getDependencies()) {
                this.collect(d, deps);
            }
        }
    }

    public NutsBootDef fetchBootDef(NutsId id, boolean content, NutsSession session) {
        NutsDefinition nd = session.fetch().setId(id).setDependencies(true).setContent(content).setDependencyFilter(NutsDependencyFilters.of((NutsSession)session).byRunnable()).setFailFast(false).getResultDefinition();
        if (nd != null) {
            if (content && nd.getContent() == null) {
                throw new NutsNotFoundException(session, id);
            }
            return new NutsBootDef(nd.getId(), nd.getDependencies().transitive().toList().toArray(new NutsDependency[0]), content && nd.getContent() != null ? nd.getContent().getPath() : null);
        }
        if (this.isFirstBoot()) {
            NutsClassLoaderNode n = this.searchBootNode(id, session);
            if (n != null) {
                LinkedHashMap<String, NutsClassLoaderNode> dm = new LinkedHashMap<String, NutsClassLoaderNode>();
                for (NutsClassLoaderNode d : n.getDependencies()) {
                    this.collect(d, dm);
                }
                return new NutsBootDef(id, (NutsDependency[])dm.values().stream().map(x -> NutsDependency.of((String)x.getId(), (NutsSession)session)).toArray(NutsDependency[]::new), NutsPath.of((URL)n.getURL(), (NutsSession)session));
            }
            MavenUtils.DepsAndRepos dd = MavenUtils.of(session).loadDependenciesAndRepositoriesFromPomPath(id, this.resolveBootRepositoriesBootSelectionArray(session), session);
            if (dd != null) {
                String contentPath = id.getGroupId().replace('.', '/') + "/" + id.getArtifactId() + "/" + id.getVersion() + "/" + id.getArtifactId() + "-" + id.getVersion();
                NutsPath pp = null;
                for (String repo : dd.repos) {
                    NutsPath a;
                    NutsRepositoryLocation r = NutsRepositoryLocation.of((String)repo);
                    NutsPath base = NutsPath.of((String)r.getPath(), (NutsSession)session);
                    if (!base.isLocal() || !base.isDirectory() || !(a = base.resolve(contentPath + ".jar")).isRegularFile()) continue;
                    pp = a;
                    break;
                }
                if (pp != null) {
                    NutsDescriptor d = NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.MAVEN).parse(pp);
                    return new NutsBootDef(id, d.getDependencies(), pp);
                }
            }
        }
        throw new NutsNotFoundException(session, id);
    }

    public void prepareBootClassPathConf(NutsIdType idType, NutsId id, NutsId forId, NutsId forceRuntimeId, boolean force, boolean processDependencies, NutsSession session) {
        switch (idType) {
            case API: {
                return;
            }
            case RUNTIME: {
                NutsBootDef d = this.fetchBootDef(id, false, session);
                for (NutsId apiId : CoreNutsUtils.resolveNutsApiIds(d.deps, session)) {
                    this.setExtraBootRuntimeId(apiId, d.id, d.deps, session);
                }
                break;
            }
            case EXTENSION: {
                NutsBootDef d = this.fetchBootDef(id, false, session);
                for (NutsId apiId : CoreNutsUtils.resolveNutsApiIds(d.deps, session)) {
                    this.setExtraBootRuntimeId(apiId, d.id, d.deps, session);
                }
                break;
            }
        }
    }

    public void prepareBootClassPathJar(NutsId id, NutsId forId, NutsId forceRuntimeId, boolean processDependencies, NutsSession session) {
        NutsBootDef d = this.fetchBootDef(id, true, session);
        if (this.deployToInstalledRepository(d.content.toFile(), session) && processDependencies) {
            for (NutsDependency dep : d.deps) {
                this.prepareBootClassPathJar(dep.toId(), id, forceRuntimeId, true, session);
            }
        }
    }

    private boolean isFirstBoot() {
        return this.ws.boot().isFirstBoot();
    }

    private boolean deployToInstalledRepository(Path tmp, NutsSession session) {
        NutsInstalledRepository ins = NutsWorkspaceExt.of(session.getWorkspace()).getInstalledRepository();
        NutsDescriptor descriptor = NutsDescriptorContentResolver.resolveNutsDescriptorFromFileContent(tmp, null, session);
        if (descriptor != null) {
            DefaultNutsDefinition b = new DefaultNutsDefinition(null, null, descriptor.getId(), descriptor, (NutsContent)new NutsDefaultContent(NutsPath.of((Path)tmp, (NutsSession)session), true, true), new DefaultNutsInstallInfo(descriptor.getId(), NutsInstallStatus.NONE, null, null, null, null, null, null, false, false), null, session);
            ins.install(b, session);
            return true;
        }
        return false;
    }

    private NutsClassLoaderNode searchBootNode(NutsId id, NutsSession session) {
        NutsBootManager boot = session.boot();
        ArrayList<NutsClassLoaderNode> all = new ArrayList<NutsClassLoaderNode>();
        all.add(boot.getBootRuntimeClassLoaderNode());
        all.addAll(Arrays.asList(boot.getBootExtensionClassLoaderNode()));
        return this.searchBootNode(id, all.toArray(new NutsClassLoaderNode[0]));
    }

    private NutsClassLoaderNode searchBootNode(NutsId id, NutsClassLoaderNode[] into) {
        for (NutsClassLoaderNode n : into) {
            if (n != null && id.getLongName().equals(n.getId())) {
                return n;
            }
            NutsClassLoaderNode a = this.searchBootNode(id, n.getDependencies());
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public void onPreUpdateConfig(String confName, NutsSession session) {
        this.preUpdateConfigStoreLocations = new NutsStoreLocationsMap(this.currentConfig.getStoreLocations());
    }

    public void onPostUpdateConfig(String confName, NutsSession session) {
        this.preUpdateConfigStoreLocations = new NutsStoreLocationsMap(this.currentConfig.getStoreLocations());
        DefaultNutsWorkspaceCurrentConfig d = this.currentConfig;
        d.setUserStoreLocations(new NutsStoreLocationsMap(this.storeModelBoot.getStoreLocations()).toMapOrNull());
        d.setHomeLocations(new NutsHomeLocationsMap(this.storeModelBoot.getHomeLocations()).toMapOrNull());
        d.build(session.locations().getWorkspaceLocation(), session);
        NutsStoreLocationsMap newSL = new NutsStoreLocationsMap(this.currentConfig.getStoreLocations());
        for (NutsStoreLocation sl : NutsStoreLocation.values()) {
            Path oldPathObj;
            String newPath;
            String oldPath = this.preUpdateConfigStoreLocations.get(sl);
            if (oldPath.equals(newPath = newSL.get(sl)) || !Files.exists(oldPathObj = Paths.get(oldPath, new String[0]), new LinkOption[0])) continue;
            CoreIOUtils.copyFolder(oldPathObj, Paths.get(newPath, new String[0]), session);
        }
        this.fireConfigurationChanged(confName, session, ConfigEventType.API);
    }

    private void onLoadWorkspaceError(Throwable ex, NutsSession session) {
        DefaultNutsWorkspaceConfigModel wconfig = this;
        Path file = session.locations().getWorkspaceLocation().toFile().resolve("nuts-workspace.json");
        if (wconfig.isReadOnly()) {
            throw new NutsIOException(session, NutsMessage.cstyle((String)"unable to load config file %s", (Object[])new Object[]{file}), ex);
        }
        String fileSuffix = Instant.now().toString();
        fileSuffix = fileSuffix.replace(':', '-');
        String fileName = "nuts-workspace-" + fileSuffix;
        NutsPath logError = session.locations().getStoreLocation(this.ws.getApiId(), NutsStoreLocation.LOG).resolve("invalid-config");
        NutsPath logFile = logError.resolve(fileName + ".error");
        this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"erroneous workspace config file. Unable to load file {0} : {1}", (Object[])new Object[]{file, ex}));
        try {
            logFile.mkParentDirs();
        }
        catch (Exception ex1) {
            throw new NutsIOException(session, NutsMessage.cstyle((String)"unable to log workspace error while loading config file %s : %s", (Object[])new Object[]{file, ex1}), ex);
        }
        NutsPath newfile = logError.resolve(fileName + ".json");
        this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"erroneous workspace config file will be replaced by a fresh one. Old config is copied to {0}\n error logged to  {1}", (Object[])new Object[]{newfile.toString(), logFile}));
        try {
            Files.move(file, newfile.toFile(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new NutsIOException(session, NutsMessage.cstyle((String)"unable to load and re-create config file %s : %s", (Object[])new Object[]{file, e}), ex);
        }
        try (PrintStream o = new PrintStream(logFile.getOutputStream());){
            o.println("workspace.path:");
            o.println(session.locations().getWorkspaceLocation());
            o.println("workspace.options:");
            o.println(wconfig.getOptions(session).formatter().setCompact(false).setRuntime(true).setInit(true).setExported(true).getBootCommandLine());
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                o.println("location." + location.id() + ":");
                o.println(session.locations().getStoreLocation(location));
            }
            o.println("java.class.path:");
            o.println(System.getProperty("java.class.path"));
            o.println();
            ex.printStackTrace(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NutsUserConfig getSecurity(String id) {
        return this.configUsers.get(id);
    }

    private NutsWorkspaceConfigBoot parseBootConfig(NutsSession session) {
        return this.parseBootConfig(session.locations().getWorkspaceLocation(), session);
    }

    private NutsWorkspaceConfigBoot parseBootConfig(NutsPath path, NutsSession session) {
        Path file = path.toFile().resolve("nuts-workspace.json");
        byte[] bytes = CompatUtils.readAllBytes(file, session);
        if (bytes == null) {
            return null;
        }
        try {
            Map a_config0 = (Map)NutsElements.of((NutsSession)session).json().parse(bytes, Map.class);
            String version = (String)a_config0.get("configVersion");
            if (version == null && (version = (String)a_config0.get("createApiVersion")) == null) {
                version = Nuts.getVersion();
            }
            return this.createNutsVersionCompat(version, session).parseConfig(bytes, session);
        }
        catch (Exception ex) {
            this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"erroneous workspace config file. Unable to load file {0} : {1}", (Object[])new Object[]{file, ex}));
            throw new NutsIOException(session, NutsMessage.cstyle((String)"unable to load config file %s", (Object[])new Object[]{file}), (Throwable)ex);
        }
    }

    private NutsVersionCompat createNutsVersionCompat(String apiVersion, NutsSession session) {
        int buildNumber = CoreNutsUtils.getApiVersionOrdinalNumber(apiVersion);
        if (buildNumber >= 803) {
            return new NutsVersionCompat803(session, apiVersion);
        }
        if (buildNumber >= 507) {
            return new NutsVersionCompat507(session, apiVersion);
        }
        if (buildNumber >= 506) {
            return new NutsVersionCompat506(session, apiVersion);
        }
        return new NutsVersionCompat502(session, apiVersion);
    }

    public NutsRepositoryLocation[] resolveBootRepositoriesBootSelectionArray(NutsSession session) {
        ArrayList<NutsRepositoryLocation> defaults = new ArrayList<NutsRepositoryLocation>();
        DefaultNutsWorkspaceConfigManager rm = (DefaultNutsWorkspaceConfigManager)session.config();
        for (NutsAddRepositoryOptions d : rm.getDefaultRepositories()) {
            defaults.add(NutsRepositoryLocation.of((String)d.getName(), null));
        }
        return this.resolveBootRepositoriesList(session).resolve(defaults.toArray(new NutsRepositoryLocation[0]), NutsRepositoryDB.of((NutsSession)session));
    }

    public NutsRepositorySelectorList resolveBootRepositoriesList(NutsSession session) {
        if (this.parsedBootRepositoriesList != null) {
            return this.parsedBootRepositoriesList;
        }
        CoreNutsBootOptions bOptions = NutsWorkspaceExt.of((NutsWorkspace)this.ws).getModel().bootModel.getCoreBootOptions();
        this.parsedBootRepositoriesList = NutsRepositorySelectorList.ofAll((String[])bOptions.getOptions().getRepositories(), (NutsRepositoryDB)NutsRepositoryDB.of((NutsSession)session), (NutsSession)session);
        return this.parsedBootRepositoriesList;
    }

    public NutsWorkspaceConfigBoot getStoreModelBoot() {
        return this.storeModelBoot;
    }

    public NutsWorkspaceConfigApi getStoreModelApi() {
        return this.storeModelApi;
    }

    public NutsWorkspaceConfigRuntime getStoreModelRuntime() {
        return this.storeModelRuntime;
    }

    public NutsWorkspaceConfigSecurity getStoreModelSecurity() {
        return this.storeModelSecurity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService executorService(NutsSession session) {
        if (this.executorService == null) {
            DefaultNutsWorkspaceConfigModel defaultNutsWorkspaceConfigModel = this;
            synchronized (defaultNutsWorkspaceConfigModel) {
                if (this.executorService == null) {
                    this.executorService = session.boot().getBootOptions().getExecutorService();
                    if (this.executorService == null) {
                        int minPoolSize = this.getConfigProperty("nuts.threads.min", session).getInt(Integer.valueOf(2));
                        if (minPoolSize < 1) {
                            minPoolSize = 60;
                        } else if (minPoolSize > 500) {
                            minPoolSize = 500;
                        }
                        int maxPoolSize = this.getConfigProperty("nuts.threads.max", session).getInt(Integer.valueOf(60));
                        if (maxPoolSize < 1) {
                            maxPoolSize = 60;
                        } else if (maxPoolSize > 500) {
                            maxPoolSize = 500;
                        }
                        if (minPoolSize > maxPoolSize) {
                            minPoolSize = maxPoolSize;
                        }
                        TimePeriod defaultPeriod = new TimePeriod(3L, TimeUnit.SECONDS);
                        TimePeriod period = TimePeriod.parseLenient(this.getConfigProperty("nuts.threads.keep-alive", session).getString(), TimeUnit.SECONDS, defaultPeriod, defaultPeriod);
                        if (period.getCount() < 0L) {
                            period = defaultPeriod;
                        }
                        ThreadPoolExecutor executorService2 = (ThreadPoolExecutor)Executors.newCachedThreadPool(CoreNutsUtils.nutsDefaultThreadFactory);
                        executorService2.setCorePoolSize(minPoolSize);
                        executorService2.setKeepAliveTime(period.getCount(), period.getUnit());
                        executorService2.setMaximumPoolSize(maxPoolSize);
                        this.executorService = executorService2;
                    }
                }
            }
        }
        return this.executorService;
    }

    public NutsSessionTerminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(NutsSessionTerminal terminal, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        if (terminal == null) {
            terminal = this.createTerminal(session);
        }
        if (!(terminal instanceof UnmodifiableSessionTerminal)) {
            terminal = new UnmodifiableSessionTerminal(terminal, session);
        }
        this.terminal = terminal;
    }

    public NutsSessionTerminal createTerminal(InputStream in, NutsPrintStream out, NutsPrintStream err, NutsSession session) {
        NutsSessionTerminal t = this.createTerminal(session);
        if (in != null) {
            t.setIn(in);
        }
        if (out != null) {
            t.setOut(out);
        }
        if (err != null) {
            t.setErr(err);
        }
        return t;
    }

    public NutsSessionTerminal createTerminal(NutsSession session) {
        return new DefaultNutsSessionTerminalFromSystem(session, (NutsSystemTerminalBase)this.workspaceSystemTerminalAdapter);
    }

    public void addPathFactory(NutsPathFactory f) {
        if (f != null && !this.pathFactories.contains(f)) {
            this.pathFactories.add(f);
        }
    }

    public void removePathFactory(NutsPathFactory f) {
        this.pathFactories.remove(f);
    }

    public NutsPath resolve(String path, NutsSession session, ClassLoader classLoader) {
        NutsPathSPI s;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader finalClassLoader = classLoader;
        NutsSupported z = Arrays.stream(this.getPathFactories()).map(x -> {
            try {
                return x.createPath(path, session, finalClassLoader);
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(x -> x != null && x.getSupportLevel() > 0).max(Comparator.comparingInt(NutsSupported::getSupportLevel)).orElse(null);
        NutsPathSPI nutsPathSPI = s = z == null ? null : (NutsPathSPI)z.getValue();
        if (s != null) {
            if (s instanceof NutsPath) {
                return (NutsPath)s;
            }
            return new NutsPathFromSPI(s);
        }
        return null;
    }

    public NutsPathFactory[] getPathFactories() {
        ArrayList<NutsPathFactory> all = new ArrayList<NutsPathFactory>(this.pathFactories.size() + 1);
        all.addAll(this.pathFactories);
        all.add(this.invalidPathFactory);
        return all.toArray(new NutsPathFactory[0]);
    }

    public DefaultNutsBootModel getBootModel() {
        return this.bootModel;
    }

    public Map<String, String> getConfigMap() {
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        if (this.getStoreModelMain().getEnv() != null) {
            p.putAll(this.getStoreModelMain().getEnv());
        }
        return p;
    }

    public NutsPrimitiveElement getConfigProperty(String property, NutsSession session) {
        Map<String, String> env = this.getStoreModelMain().getEnv();
        if (env != null) {
            return NutsElements.of((NutsSession)session).ofString(env.get(property));
        }
        return NutsElements.of((NutsSession)session).ofNull();
    }

    public void setConfigProperty(String property, String value, NutsSession session) {
        Map<String, String> env = this.getStoreModelMain().getEnv();
        if (NutsBlankable.isBlank((String)value)) {
            if (env != null && env.containsKey(property)) {
                env.remove(property);
                NutsWorkspaceConfigManagerExt.of(session.config()).getModel().fireConfigurationChanged("env", session, ConfigEventType.MAIN);
            }
        } else {
            String old;
            if (env == null) {
                env = new LinkedHashMap<String, String>();
                this.getStoreModelMain().setEnv(env);
            }
            if (!value.equals(old = env.get(property))) {
                env.put(property, value);
                NutsWorkspaceConfigManagerExt.of(session.config()).getModel().fireConfigurationChanged("env", session, ConfigEventType.MAIN);
            }
        }
    }

    private class InvalidFilePathFactory
    implements NutsPathFactory {
        private InvalidFilePathFactory() {
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(DefaultNutsWorkspaceConfigModel.this.getWorkspace(), session);
            try {
                return NutsSupported.of((int)1, () -> new InvalidFilePath(path, session));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private class NutsWorkspaceStoredConfigImpl
    implements NutsWorkspaceStoredConfig {
        public String getName() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getName();
        }

        public NutsStoreLocationStrategy getStoreLocationStrategy() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocationStrategy();
        }

        public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocationStrategy();
        }

        public NutsOsFamily getStoreLocationLayout() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocationLayout();
        }

        public Map<NutsStoreLocation, String> getStoreLocations() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocations();
        }

        public Map<NutsHomeLocation, String> getHomeLocations() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getHomeLocations();
        }

        public String getStoreLocation(NutsStoreLocation folderType) {
            return new NutsStoreLocationsMap(DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getStoreLocations()).get(folderType);
        }

        public String getHomeLocation(NutsHomeLocation homeLocation) {
            return new NutsHomeLocationsMap(DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getHomeLocations()).get(homeLocation);
        }

        public NutsId getApiId() {
            String v = DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getApiVersion();
            NutsSession ws = NutsWorkspaceUtils.defaultSession(DefaultNutsWorkspaceConfigModel.this.ws);
            return v == null ? null : NutsId.of((String)("net.thevpc.nuts:nuts#" + v), (NutsSession)ws);
        }

        public NutsId getRuntimeId() {
            String v = DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getRuntimeId();
            NutsSession ws = NutsWorkspaceUtils.defaultSession(DefaultNutsWorkspaceConfigModel.this.ws);
            return v == null ? null : (v.contains("#") ? NutsId.of((String)v, (NutsSession)ws) : NutsId.of((String)("net.thevpc.nuts:nuts-runtime#" + v), (NutsSession)ws));
        }

        public String getRuntimeDependencies() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigRuntime().getDependencies();
        }

        public String getBootRepositories() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().getBootRepositories();
        }

        public String getJavaCommand() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getJavaCommand();
        }

        public String getJavaOptions() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigApi().getJavaOptions();
        }

        public boolean isGlobal() {
            return DefaultNutsWorkspaceConfigModel.this.getStoredConfigBoot().isGlobal();
        }
    }

    private class NutsBootDef {
        NutsId id;
        NutsDependency[] deps;
        NutsPath content;

        public NutsBootDef(NutsId id, NutsDependency[] deps, NutsPath content) {
            this.id = id;
            this.deps = deps;
            this.content = content;
        }
    }

    private static class WorkspaceSystemTerminalAdapter
    extends AbstractSystemTerminalAdapter {
        private final NutsWorkspace workspace;

        public WorkspaceSystemTerminalAdapter(NutsWorkspace workspace) {
            this.workspace = workspace;
        }

        @Override
        public NutsSystemTerminalBase getBase() {
            return NutsWorkspaceUtils.defaultSession(this.workspace).config().getSystemTerminal();
        }
    }
}

