/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceStoredConfig;
import net.thevpc.nuts.runtime.standalone.dependency.solver.NutsDependencySolverUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.spi.NutsDependencySolver;
import net.thevpc.nuts.spi.NutsDependencySolverFactory;
import net.thevpc.nuts.spi.NutsIndexStoreFactory;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class DefaultNutsWorkspaceConfigManager
implements NutsWorkspaceConfigManager,
NutsWorkspaceConfigManagerExt {
    private final DefaultNutsWorkspaceConfigModel model;
    private NutsSession session;

    public DefaultNutsWorkspaceConfigManager(DefaultNutsWorkspaceConfigModel model) {
        this.model = model;
    }

    @Override
    public DefaultNutsWorkspaceConfigModel getModel() {
        return this.model;
    }

    public NutsWorkspaceStoredConfig stored() {
        this.checkSession();
        return this.model.stored();
    }

    public boolean isReadOnly() {
        this.checkSession();
        return this.model.isReadOnly();
    }

    public boolean save(boolean force) {
        this.checkSession();
        return this.model.save(force, this.session);
    }

    public boolean save() {
        this.checkSession();
        return this.model.save(this.session);
    }

    public NutsWorkspaceBootConfig loadBootConfig(String _ws, boolean global, boolean followLinks) {
        this.checkSession();
        return this.model.loadBootConfig(_ws, global, followLinks, this.session);
    }

    public boolean isExcludedExtension(String extensionId, NutsWorkspaceOptions options) {
        this.checkSession();
        return this.model.isExcludedExtension(extensionId, options, this.session);
    }

    public boolean isSupportedRepositoryType(String repositoryType) {
        this.checkSession();
        return this.model.isSupportedRepositoryType(repositoryType, this.session);
    }

    public NutsAddRepositoryOptions[] getDefaultRepositories() {
        this.checkSession();
        return this.model.getDefaultRepositories(this.session);
    }

    public Set<String> getAvailableArchetypes() {
        this.checkSession();
        return this.model.getAvailableArchetypes(this.session);
    }

    public NutsPath resolveRepositoryPath(String repositoryLocation) {
        this.checkSession();
        return this.model.resolveRepositoryPath(NutsPath.of((String)repositoryLocation, (NutsSession)this.session), this.session);
    }

    public NutsIndexStoreFactory getIndexStoreClientFactory() {
        this.checkSession();
        return this.model.getIndexStoreClientFactory();
    }

    public String getJavaCommand() {
        this.checkSession();
        return this.model.getJavaCommand();
    }

    public String getJavaOptions() {
        this.checkSession();
        return this.model.getJavaOptions();
    }

    public boolean isGlobal() {
        this.checkSession();
        return this.model.isGlobal();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspaceConfigManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public String toString() {
        String s1 = "NULL";
        String s2 = "NULL";
        s1 = String.valueOf(this.model.getWorkspace().getApiId());
        s2 = String.valueOf(this.model.getWorkspace().getRuntimeId());
        return "NutsWorkspaceConfig{workspaceBootId=" + s1 + ", workspaceRuntimeId=" + s2 + ", workspace=" + (this.model.getCurrentConfig() == null ? "NULL" : "'" + NutsWorkspaceUtils.defaultSession(this.model.getWorkspace()).locations().getWorkspaceLocation() + '\'') + '}';
    }

    public String[] getDependencySolverNames() {
        this.checkSession();
        return (String[])Arrays.stream(this.model.getDependencySolvers(this.getSession())).map(NutsDependencySolverFactory::getName).sorted(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (!o1.equals(o2)) {
                    String n = NutsDependencySolverUtils.resolveSolverName(DefaultNutsWorkspaceConfigManager.this.session.getDependencySolver());
                    if (o1.equals(n)) {
                        return -1;
                    }
                    if (o2.equals(n)) {
                        return 1;
                    }
                }
                return o1.compareTo(o2);
            }
        }).toArray(String[]::new);
    }

    public NutsDependencySolver createDependencySolver(String name) {
        this.checkSession();
        return this.model.createDependencySolver(name, this.getSession());
    }

    public NutsSystemTerminal getSystemTerminal() {
        this.checkSession();
        return NutsWorkspaceExt.of((NutsSession)this.session).getModel().bootModel.getSystemTerminal();
    }

    public NutsWorkspaceConfigManager setSystemTerminal(NutsSystemTerminalBase terminal) {
        this.checkSession();
        NutsWorkspaceExt.of((NutsSession)this.session).getModel().bootModel.setSystemTerminal(terminal, this.getSession());
        return this;
    }

    public NutsSessionTerminal getDefaultTerminal() {
        this.checkSession();
        return this.model.getTerminal();
    }

    public NutsWorkspaceConfigManager setDefaultTerminal(NutsSessionTerminal terminal) {
        this.checkSession();
        this.model.setTerminal(terminal, this.session);
        return this;
    }

    public Map<String, String> getConfigMap() {
        this.checkSession();
        return this.model.getConfigMap();
    }

    public NutsPrimitiveElement getConfigProperty(String property) {
        this.checkSession();
        return this.model.getConfigProperty(property, this.getSession());
    }

    public NutsWorkspaceConfigManager setConfigProperty(String property, String value) {
        this.checkSession();
        this.model.setConfigProperty(property, value, this.session);
        this.model.save(this.getSession());
        return this;
    }
}

