/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceBootConfigExtensionImpl;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigBoot;

class DefaultNutsWorkspaceBootConfig
implements NutsWorkspaceBootConfig {
    private String bootPath;
    private String effectiveWorkspace;
    private String effectiveWorkspaceName;
    private boolean immediateLocation;
    private String uuid = null;
    private boolean global;
    private String name = null;
    private String workspace = null;
    private String bootRepositories = null;
    private Map<NutsStoreLocation, String> storeLocations = null;
    private Map<NutsHomeLocation, String> homeLocations = null;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy = null;
    private NutsStoreLocationStrategy storeLocationStrategy = null;
    private NutsOsFamily storeLocationLayout = null;
    private List<NutsWorkspaceBootConfig.Extension> extensions;

    public DefaultNutsWorkspaceBootConfig(NutsSession session, String bootPath, String effectiveWorkspace, String effectiveWorkspaceName, boolean immediateLocation, NutsWorkspaceConfigBoot bootModel) {
        this.bootPath = bootPath;
        this.effectiveWorkspace = effectiveWorkspace;
        this.immediateLocation = immediateLocation;
        this.effectiveWorkspaceName = effectiveWorkspaceName;
        this.uuid = bootModel.getUuid();
        this.global = bootModel.isGlobal();
        this.name = bootModel.getName();
        this.workspace = bootModel.getWorkspace();
        this.bootRepositories = bootModel.getBootRepositories();
        this.storeLocations = bootModel.getStoreLocations() == null ? new HashMap<NutsStoreLocation, String>() : new HashMap<NutsStoreLocation, String>(bootModel.getStoreLocations());
        this.homeLocations = bootModel.getHomeLocations() == null ? new HashMap<NutsHomeLocation, String>() : new HashMap<NutsHomeLocation, String>(bootModel.getHomeLocations());
        this.repositoryStoreLocationStrategy = bootModel.getRepositoryStoreLocationStrategy();
        this.storeLocationStrategy = bootModel.getStoreLocationStrategy();
        this.storeLocationLayout = bootModel.getStoreLocationLayout();
        if (this.storeLocationStrategy == null) {
            this.storeLocationStrategy = NutsStoreLocationStrategy.EXPLODED;
        }
        this.storeLocations = NutsUtilPlatforms.buildLocations(null, (NutsStoreLocationStrategy)this.storeLocationStrategy, this.storeLocations, this.homeLocations, (boolean)this.global, (String)effectiveWorkspace, (NutsSession)session);
        List<NutsWorkspaceConfigBoot.ExtensionConfig> extensions = bootModel.getExtensions();
        this.extensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions.stream().map(x -> new NutsWorkspaceBootConfigExtensionImpl((NutsWorkspaceConfigBoot.ExtensionConfig)((Object)x))).collect(Collectors.toList()));
    }

    public boolean isImmediateLocation() {
        return this.immediateLocation;
    }

    public String getEffectiveWorkspaceName() {
        return this.effectiveWorkspaceName;
    }

    public String getBootPath() {
        return this.bootPath;
    }

    public String getName() {
        return this.name;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getEffectiveWorkspace() {
        return this.effectiveWorkspace;
    }

    public List<NutsWorkspaceBootConfig.Extension> getExtensions() {
        return this.extensions;
    }

    public String getBootRepositories() {
        return this.bootRepositories;
    }

    public Map<NutsStoreLocation, String> getStoreLocations() {
        return Collections.unmodifiableMap(this.storeLocations);
    }

    public Map<NutsHomeLocation, String> getHomeLocations() {
        return Collections.unmodifiableMap(this.homeLocations);
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String getDefaultIdBasedir(NutsId id) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String plainIdPath = groupId.replace('.', '/') + "/" + artifactId;
        if (id.getVersion().isBlank()) {
            return plainIdPath;
        }
        String version = id.getVersion().getValue();
        String x = plainIdPath + "/" + version;
        return x;
    }

    public String getStoreLocation(NutsId id, NutsStoreLocation folderType) {
        String storeLocation = this.getStoreLocation(folderType);
        if (storeLocation == null) {
            return null;
        }
        return Paths.get(storeLocation, new String[0]).resolve("id").resolve(this.getDefaultIdBasedir(id)).toString();
    }

    public String getStoreLocation(NutsStoreLocation storeLocation) {
        return this.storeLocations.get(storeLocation);
    }

    public String getHomeLocation(NutsHomeLocation homeLocation) {
        return new NutsHomeLocationsMap(this.homeLocations).get(homeLocation);
    }

    public String getHomeLocation(NutsStoreLocation storeLocation) {
        return NutsUtilPlatforms.getPlatformHomeFolder((NutsOsFamily)this.getStoreLocationLayout(), (NutsStoreLocation)storeLocation, this.getHomeLocations(), (boolean)this.isGlobal(), (String)this.getName());
    }
}

