/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceEnvManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsPlatformLocationSelectComparator;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;

public class DefaultNutsPlatformModel {
    private NutsWorkspace workspace;
    private DefaultNutsWorkspaceEnvManagerModel model;

    public DefaultNutsPlatformModel(DefaultNutsWorkspaceEnvManagerModel model) {
        this.workspace = model.getWorkspace();
        this.model = model;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean addPlatform(NutsPlatformLocation location, NutsSession session) {
        return this.add0(location, session, true);
    }

    public boolean add0(NutsPlatformLocation location, NutsSession session, boolean notify) {
        if (location != null) {
            if (NutsBlankable.isBlank((String)location.getProduct())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"platform type should not be null", (Object[])new Object[0]));
            }
            if (NutsBlankable.isBlank((String)location.getName())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"platform name should not be null", (Object[])new Object[0]));
            }
            if (NutsBlankable.isBlank((String)location.getVersion())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"platform version should not be null", (Object[])new Object[0]));
            }
            if (NutsBlankable.isBlank((String)location.getPath())) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"platform path should not be null", (Object[])new Object[0]));
            }
            List<NutsPlatformLocation> list = this.getPlatforms().get(location.getPlatformType());
            if (list == null) {
                list = new ArrayList<NutsPlatformLocation>();
                this.model.getConfigPlatforms().put(location.getPlatformType(), list);
            }
            NutsPlatformLocation old = null;
            for (NutsPlatformLocation nutsPlatformLocation : list) {
                if (!Objects.equals(nutsPlatformLocation.getPackaging(), location.getPackaging()) || !Objects.equals(nutsPlatformLocation.getProduct(), location.getProduct()) || !nutsPlatformLocation.getName().equals(location.getName()) && !nutsPlatformLocation.getPath().equals(location.getPath())) continue;
                old = nutsPlatformLocation;
                break;
            }
            if (old != null) {
                return false;
            }
            list.add(location);
            if (notify) {
                if (session.isPlainTrace()) {
                    session.out().resetLine().printf("%s %s %s (%s) %s at %s%n", new Object[]{NutsTexts.of((NutsSession)session).ofStyled("install", NutsTextStyles.of((NutsTextStyle)NutsTextStyle.success())), location.getId().getShortName(), location.getPackaging(), location.getProduct(), NutsVersion.of((String)location.getVersion(), (NutsSession)session), NutsPath.of((String)location.getPath(), (NutsSession)session)});
                }
                NutsWorkspaceConfigManagerExt.of(session.config()).getModel().fireConfigurationChanged("platform", session, ConfigEventType.MAIN);
            }
            return true;
        }
        return false;
    }

    public boolean updatePlatform(NutsPlatformLocation oldLocation, NutsPlatformLocation newLocation, NutsSession session) {
        boolean updated = false;
        updated |= this.removePlatform(oldLocation, session);
        updated |= this.removePlatform(newLocation, session);
        return updated |= this.addPlatform(newLocation, session);
    }

    public boolean removePlatform(NutsPlatformLocation location, NutsSession session) {
        List<NutsPlatformLocation> list;
        if (location != null && (list = this.getPlatforms().get(location.getPlatformType())) != null && list.remove(location)) {
            NutsWorkspaceConfigManagerExt.of(session.config()).getModel().fireConfigurationChanged("platform", session, ConfigEventType.MAIN);
            return true;
        }
        return false;
    }

    public NutsPlatformLocation findPlatformByName(NutsPlatformFamily type, String locationName, NutsSession session) {
        return this.findOnePlatform(type, location -> location.getName().equals(locationName), session);
    }

    public NutsPlatformLocation findPlatformByPath(NutsPlatformFamily type, String path, NutsSession session) {
        return this.findOnePlatform(type, location -> location.getPath() != null && location.getPath().equals(path.toString()), session);
    }

    public NutsPlatformLocation findPlatformByVersion(NutsPlatformFamily type, String version, NutsSession session) {
        return this.findOnePlatform(type, location -> location.getVersion().equals(version), session);
    }

    public NutsPlatformLocation findPlatform(NutsPlatformLocation location, NutsSession session) {
        if (location == null) {
            return null;
        }
        String type = location.getId().getArtifactId();
        NutsPlatformFamily ftype = NutsPlatformFamily.parseLenient((String)type, (NutsPlatformFamily)NutsPlatformFamily.JAVA, (NutsPlatformFamily)NutsPlatformFamily.UNKNOWN);
        List<NutsPlatformLocation> list = this.getPlatforms().get(ftype);
        if (list != null) {
            for (NutsPlatformLocation location2 : list) {
                if (!location2.equals((Object)location)) continue;
                return location2;
            }
        }
        return null;
    }

    public NutsPlatformLocation findPlatformByVersion(NutsPlatformFamily type, NutsVersionFilter javaVersionFilter, NutsSession session) {
        return this.findOnePlatform(type, location -> javaVersionFilter == null || javaVersionFilter.acceptVersion(NutsVersion.of((String)location.getVersion(), (NutsSession)session), session), session);
    }

    public NutsPlatformLocation[] searchSystemPlatforms(NutsPlatformFamily platformType, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        if (platformType == NutsPlatformFamily.JAVA) {
            try {
                return NutsJavaSdkUtils.of(session.getWorkspace()).searchJdkLocationsFuture(session).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return new NutsPlatformLocation[0];
    }

    public NutsPlatformLocation[] searchSystemPlatforms(NutsPlatformFamily platformType, String path, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        if (platformType == NutsPlatformFamily.JAVA) {
            return NutsJavaSdkUtils.of(session.getWorkspace()).searchJdkLocations(path, session);
        }
        return new NutsPlatformLocation[0];
    }

    public NutsPlatformLocation resolvePlatform(NutsPlatformFamily platformType, String path, String preferredName, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
        if (platformType == NutsPlatformFamily.JAVA) {
            return NutsJavaSdkUtils.of(session.getWorkspace()).resolveJdkLocation(path, null, session);
        }
        return null;
    }

    public void setPlatforms(NutsPlatformLocation[] locations, NutsSession session) {
        this.model.getConfigPlatforms().clear();
        for (NutsPlatformLocation platform : locations) {
            this.add0(platform, session, false);
        }
    }

    public NutsPlatformLocation findOnePlatform(NutsPlatformFamily type, Predicate<NutsPlatformLocation> filter, NutsSession session) {
        NutsPlatformLocation[] a = this.findPlatforms(type, filter, session);
        return a.length == 0 ? null : a[0];
    }

    public NutsPlatformLocation[] findPlatforms(NutsPlatformFamily type, Predicate<NutsPlatformLocation> filter, NutsSession session) {
        if (filter == null) {
            if (type == null) {
                ArrayList<NutsPlatformLocation> all = new ArrayList<NutsPlatformLocation>();
                for (List<NutsPlatformLocation> value : this.model.getConfigPlatforms().values()) {
                    all.addAll(value);
                }
                return all.toArray(new NutsPlatformLocation[0]);
            }
            List<NutsPlatformLocation> list = this.getPlatforms().get(type);
            if (list == null) {
                return new NutsPlatformLocation[0];
            }
            return list.toArray(new NutsPlatformLocation[0]);
        }
        ArrayList<NutsPlatformLocation> ret = new ArrayList<NutsPlatformLocation>();
        if (type == null) {
            for (List<NutsPlatformLocation> found : this.getPlatforms().values()) {
                for (NutsPlatformLocation location : found) {
                    if (!filter.test(location)) continue;
                    ret.add(location);
                }
            }
        } else {
            List<NutsPlatformLocation> found = this.getPlatforms().get(type);
            if (found != null) {
                for (NutsPlatformLocation location : found) {
                    if (!filter.test(location)) continue;
                    ret.add(location);
                }
            }
        }
        if (!ret.isEmpty()) {
            ret.sort(new NutsPlatformLocationSelectComparator(session));
        }
        return ret.toArray(new NutsPlatformLocation[0]);
    }

    public Map<NutsPlatformFamily, List<NutsPlatformLocation>> getPlatforms() {
        return this.model.getConfigPlatforms();
    }
}

