/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.function.Predicate;
import net.thevpc.nuts.NutsPlatformFamily;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsPlatformManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsPlatformModel;

public class DefaultNutsPlatformManager
implements NutsPlatformManager {
    private DefaultNutsPlatformModel model;
    private NutsSession session;

    public DefaultNutsPlatformManager(DefaultNutsPlatformModel model) {
        this.model = model;
    }

    public DefaultNutsPlatformModel getModel() {
        return this.model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsPlatformManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    public boolean addPlatform(NutsPlatformLocation location) {
        this.checkSession();
        return this.model.addPlatform(location, this.session);
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public boolean updatePlatform(NutsPlatformLocation oldLocation, NutsPlatformLocation newLocation) {
        this.checkSession();
        return this.model.updatePlatform(oldLocation, newLocation, this.session);
    }

    public boolean removePlatform(NutsPlatformLocation location) {
        this.checkSession();
        return this.model.removePlatform(location, this.session);
    }

    public NutsPlatformLocation findPlatformByName(NutsPlatformFamily platformType, String locationName) {
        this.checkSession();
        return this.model.findPlatformByName(platformType, locationName, this.session);
    }

    public NutsPlatformLocation findPlatformByPath(NutsPlatformFamily platformType, String path) {
        this.checkSession();
        return this.model.findPlatformByPath(platformType, path, this.session);
    }

    public NutsPlatformLocation findPlatformByVersion(NutsPlatformFamily platformType, String version) {
        this.checkSession();
        return this.model.findPlatformByVersion(platformType, version, this.session);
    }

    public NutsPlatformLocation findPlatform(NutsPlatformLocation location) {
        this.checkSession();
        return this.model.findPlatform(location, this.session);
    }

    public NutsPlatformLocation findPlatformByVersion(NutsPlatformFamily platformType, NutsVersionFilter requestedVersion) {
        this.checkSession();
        return this.model.findPlatformByVersion(platformType, requestedVersion, this.session);
    }

    public NutsPlatformLocation[] searchSystemPlatforms(NutsPlatformFamily platformType) {
        this.checkSession();
        return this.model.searchSystemPlatforms(platformType, this.session);
    }

    public NutsPlatformLocation[] searchSystemPlatforms(NutsPlatformFamily platformType, String path) {
        this.checkSession();
        return this.model.searchSystemPlatforms(platformType, path, this.session);
    }

    public NutsPlatformLocation resolvePlatform(NutsPlatformFamily platformType, String path, String preferredName) {
        this.checkSession();
        return this.model.resolvePlatform(platformType, path, preferredName, this.session);
    }

    public NutsPlatformLocation findPlatform(NutsPlatformFamily type, Predicate<NutsPlatformLocation> filter) {
        this.checkSession();
        return this.model.findOnePlatform(type, filter, this.session);
    }

    public NutsPlatformLocation[] findPlatforms(NutsPlatformFamily type, Predicate<NutsPlatformLocation> filter) {
        this.checkSession();
        return this.model.findPlatforms(type, filter, this.session);
    }

    public NutsPlatformLocation[] findPlatforms() {
        return this.findPlatforms(null, null);
    }

    public NutsPlatformLocation[] findPlatforms(NutsPlatformFamily type) {
        this.checkSession();
        return this.model.findPlatforms(type, null, this.session);
    }
}

