/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDescribables;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIndexStore;
import net.thevpc.nuts.NutsIndexerNotAccessibleException;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.config.AbstractNutsIndexStore;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsIdFilterToNutsIdPredicate;

public class DefaultNutsIndexStore
extends AbstractNutsIndexStore {
    public DefaultNutsIndexStore(NutsRepository repository) {
        super(repository);
    }

    public NutsIterator<NutsId> searchVersions(NutsId id, NutsSession session) {
        return IteratorBuilder.ofSupplier(() -> {
            if (this.isInaccessible()) {
                return IteratorBuilder.emptyIterator();
            }
            String uu = this.getIndexURL(session).resolve("id").resolve("allVersions") + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&os=%s&osdist=%s&arch=%s&face=%s&", this.getRepository().getUuid(), NutsUtilStrings.trim((String)id.getArtifactId()), NutsUtilStrings.trim((String)id.getRepository()), NutsUtilStrings.trim((String)id.getGroupId()), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getOs())), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getOsDist())), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getArch())), NutsUtilStrings.trim((String)id.getFace()));
            try {
                Map[] array = (Map[])NutsElements.of((NutsSession)session).json().parse((Reader)new InputStreamReader(NutsPath.of((String)uu, (NutsSession)session).getInputStream()), Map[].class);
                return Arrays.stream(array).map(s -> NutsId.of((String)s.get("stringId").toString(), (NutsSession)session)).collect(Collectors.toList()).iterator();
            }
            catch (UncheckedIOException | NutsIOException e) {
                this.setInaccessible();
                return IteratorBuilder.emptyIterator();
            }
        }, e -> e.ofObject().set("type", "SearchIndexVersions").set("source", this.getIndexURL(session).resolve("id").resolve("allVersions").toString()).build(), session).build();
    }

    public NutsIterator<NutsId> search(NutsIdFilter filter, NutsSession session) {
        NutsElements elems = NutsElements.of((NutsSession)session);
        return IteratorBuilder.ofSupplier(() -> {
            if (this.isInaccessible()) {
                throw new NutsIndexerNotAccessibleException(session, NutsMessage.cstyle((String)"index search failed for %s", (Object[])new Object[]{this.getRepository().getName()}));
            }
            String uu = this.getIndexURL(session).resolve("id") + "?repositoryUuid=" + this.getRepository().getUuid();
            try {
                Map[] array = (Map[])elems.json().parse((Reader)new InputStreamReader(NutsPath.of((String)uu, (NutsSession)session).getInputStream()), Map[].class);
                return Arrays.stream(array).map(s -> NutsId.of((String)s.get("stringId").toString(), (NutsSession)session)).filter((Predicate<NutsId>)((Object)(filter != null ? new NutsIdFilterToNutsIdPredicate(filter, session) : NutsPredicates.always()))).iterator();
            }
            catch (UncheckedIOException | NutsIOException e) {
                this.setInaccessible();
                throw new NutsIndexerNotAccessibleException(session, NutsMessage.cstyle((String)"index search failed for %s", (Object[])new Object[]{this.getRepository().getName()}));
            }
        }, e -> e.ofObject().set("type", "SearchIndexPackages").set("source", this.getIndexURL(session).resolve("id").toString()).set("filter", NutsDescribables.resolveOrToString((Object)filter, (NutsElements)elems)).build(), session).build();
    }

    private NutsPath getIndexURL(NutsSession session) {
        return NutsPath.of((String)"http://localhost:7070/indexer/", (NutsSession)session);
    }

    public NutsIndexStore invalidate(NutsId id, NutsSession session) {
        if (this.isInaccessible()) {
            return this;
        }
        String uu = this.getIndexURL(session).resolve("id").resolve("delete") + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&version=%s&os=%s&osdist=%s&arch=%s&face=%s", this.getRepository().getUuid(), NutsUtilStrings.trim((String)id.getArtifactId()), NutsUtilStrings.trim((String)id.getRepository()), NutsUtilStrings.trim((String)id.getGroupId()), NutsUtilStrings.trim((String)id.getVersion().toString()), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getOs())), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getOsDist())), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getArch())), NutsUtilStrings.trim((String)id.getFace()));
        try {
            NutsPath.of((String)uu, (NutsSession)session).getInputStream();
        }
        catch (UncheckedIOException | NutsIOException e) {
            this.setInaccessible();
        }
        return this;
    }

    public NutsIndexStore revalidate(NutsId id, NutsSession session) {
        if (this.isInaccessible()) {
            return this;
        }
        String uu = this.getIndexURL(session).resolve("id").resolve("addData") + String.format("?repositoryUuid=%s&name=%s&repo=%s&group=%s&version=%s&os=%s&osdist=%s&arch=%s&face=%s", this.getRepository().getUuid(), NutsUtilStrings.trim((String)id.getArtifactId()), NutsUtilStrings.trim((String)id.getRepository()), NutsUtilStrings.trim((String)id.getGroupId()), NutsUtilStrings.trim((String)id.getVersion().toString()), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getOs())), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getOsDist())), NutsUtilStrings.trim((String)String.join((CharSequence)",", id.getCondition().getArch())), NutsUtilStrings.trim((String)id.getFace()));
        try {
            NutsPath.of((String)uu, (NutsSession)session).getInputStream();
        }
        catch (UncheckedIOException | NutsIOException e) {
            this.setInaccessible();
        }
        return this;
    }

    public NutsIndexStore subscribe(NutsSession session) {
        String uu = "http://localhost:7070/indexer/subscription/subscribe?workspaceLocation=" + CoreIOUtils.urlEncodeString(session.locations().getWorkspaceLocation().toString(), session) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid(), session);
        try {
            NutsPath.of((String)uu, (NutsSession)session).getInputStream();
        }
        catch (UncheckedIOException | NutsIOException e) {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"unable to subscribe for repository%s", (Object[])new Object[]{this.getRepository().getName()}), e);
        }
        return this;
    }

    public NutsIndexStore unsubscribe(NutsSession session) {
        String uu = "http://localhost:7070/indexer/subscription/unsubscribe?workspaceLocation=" + CoreIOUtils.urlEncodeString(session.locations().getWorkspaceLocation().toString(), session) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid(), session);
        try {
            NutsPath.of((String)uu, (NutsSession)session).getInputStream();
        }
        catch (UncheckedIOException | NutsIOException e) {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"unable to unsubscribe for repository %s", (Object[])new Object[]{this.getRepository().getName()}), e);
        }
        return this;
    }

    public boolean isSubscribed(NutsSession session) {
        String uu = "http://localhost:7070/indexer/subscription/isSubscribed?workspaceLocation=" + CoreIOUtils.urlEncodeString(session.locations().getWorkspaceLocation().toString(), session) + "&repositoryUuid=" + CoreIOUtils.urlEncodeString(this.getRepository().getUuid(), session);
        try {
            return new Scanner(NutsPath.of((String)uu, (NutsSession)session).getInputStream()).nextBoolean();
        }
        catch (UncheckedIOException | NutsIOException e) {
            return false;
        }
    }
}

