/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.Set;
import net.thevpc.nuts.NutsImportManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultImportModel;

public class DefaultImportManager
implements NutsImportManager {
    private DefaultImportModel model;
    private NutsSession session;

    public DefaultImportManager(DefaultImportModel model) {
        this.model = model;
    }

    public NutsImportManager addImports(String ... importExpressions) {
        this.checkSession();
        this.model.add(importExpressions, this.session);
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public NutsImportManager clearImports() {
        this.checkSession();
        this.model.removeAll(this.session);
        return this;
    }

    public NutsImportManager removeImports(String ... importExpressions) {
        this.checkSession();
        this.model.remove(importExpressions, this.session);
        return this;
    }

    public NutsImportManager updateImports(String[] imports) {
        this.checkSession();
        this.model.set(imports, this.session);
        return this;
    }

    public boolean isImportedGroupId(String groupId) {
        this.checkSession();
        return this.model.isImportedGroupId(groupId);
    }

    public Set<String> getAllImports() {
        this.checkSession();
        return this.model.getAll();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public DefaultImportManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    public DefaultImportModel getModel() {
        return this.model;
    }
}

