/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.List;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsCustomCommandManager;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultCustomCommandsModel;

public class DefaultCustomCommandManager
implements NutsCustomCommandManager {
    public DefaultCustomCommandsModel model;
    public NutsSession session;

    public DefaultCustomCommandManager(DefaultCustomCommandsModel model) {
        this.model = model;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public NutsCommandFactoryConfig[] getCommandFactories() {
        this.checkSession();
        return this.model.getFactories(this.session);
    }

    public void addCommandFactory(NutsCommandFactoryConfig commandFactoryConfig) {
        this.checkSession();
        this.model.addFactory(commandFactoryConfig, this.session);
    }

    public void removeCommandFactory(String commandFactoryId) {
        this.checkSession();
        this.model.removeFactory(commandFactoryId, this.session);
    }

    public boolean removeCommandFactoryIfExists(String commandFactoryId) {
        this.checkSession();
        return this.model.removeFactoryIfExists(commandFactoryId, this.session);
    }

    public boolean commandExists(String command) {
        this.checkSession();
        return this.findCommand(command) != null;
    }

    public boolean commandFactoryExists(String factoryId) {
        this.checkSession();
        return this.model.commandFactoryExists(factoryId, this.session);
    }

    public boolean addCommand(NutsCommandConfig command) {
        this.checkSession();
        return this.model.add(command, this.session);
    }

    public boolean updateCommand(NutsCommandConfig command) {
        this.checkSession();
        return this.model.update(command, this.session);
    }

    public void removeCommand(String command) {
        this.checkSession();
        this.model.remove(command, this.session);
    }

    public boolean removeCommandIfExists(String name) {
        this.checkSession();
        if (this.model.find(name, this.session) != null) {
            this.model.remove(name, this.session);
            return true;
        }
        return false;
    }

    public NutsWorkspaceCustomCommand findCommand(String name, NutsId forId, NutsId forOwner) {
        this.checkSession();
        return this.model.find(name, forId, forOwner, this.session);
    }

    public NutsWorkspaceCustomCommand findCommand(String name) {
        this.checkSession();
        return this.model.find(name, this.session);
    }

    public List<NutsWorkspaceCustomCommand> findAllCommands() {
        this.checkSession();
        return this.model.findAll(this.session);
    }

    public List<NutsWorkspaceCustomCommand> findCommandsByOwner(NutsId id) {
        this.checkSession();
        return this.model.findByOwner(id, this.session);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsCustomCommandManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }
}

