/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.config;

import java.util.Date;
import net.thevpc.nuts.NutsIndexStore;
import net.thevpc.nuts.NutsRepository;

public abstract class AbstractNutsIndexStore
implements NutsIndexStore {
    private NutsRepository repository;
    private boolean enabled = true;
    private Date inaccessibleDate = null;

    public AbstractNutsIndexStore(NutsRepository repository) {
        this.repository = repository;
    }

    protected void setInaccessible() {
        this.inaccessibleDate = new Date();
    }

    public boolean isInaccessible() {
        if (this.inaccessibleDate == null) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - this.inaccessibleDate.getTime();
        if (elapsed > 300000L) {
            this.inaccessibleDate = null;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NutsIndexStore setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public NutsRepository getRepository() {
        return this.repository;
    }

    public void setRepository(NutsRepository repository) {
        this.repository = repository;
    }
}

