/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.which;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutableInformation;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.app.util.NutsAppUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultInternalNutsExecutableCommand;

public class DefaultNutsWhichInternalExecutable
extends DefaultInternalNutsExecutableCommand {
    private final NutsExecCommand execCommand;

    public DefaultNutsWhichInternalExecutable(String[] args, NutsSession session, NutsExecCommand execCommand) {
        super("which", args, session);
        this.execCommand = execCommand;
    }

    @Override
    public void execute() {
        if (NutsAppUtils.processHelpOptions(this.args, this.getSession())) {
            this.showDefaultHelp();
            return;
        }
        ArrayList<String> commands = new ArrayList<String>();
        NutsCommandLine commandLine = NutsCommandLine.of((String[])this.args, (NutsSession)this.getSession());
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.peek();
            if (a.isOption()) {
                this.getSession().configureLast(commandLine);
                continue;
            }
            commandLine.skip();
            commands.add(a.toString());
            commands.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skipAll();
        }
        if (commands.isEmpty()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"which: missing commands", (Object[])new Object[0]));
        }
        NutsTexts factory = NutsTexts.of((NutsSession)this.getSession());
        for (String arg : commands) {
            NutsPrintStream out = this.getSession().out();
            NutsElements elem = NutsElements.of((NutsSession)this.getSession());
            try {
                NutsExecutableInformation p = this.execCommand.copy().setSession(this.getSession()).clearCommand().configure(false, new String[]{arg}).which();
                switch (p.getType()) {
                    case SYSTEM: {
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s %s%n", new Object[]{factory.ofStyled(arg, NutsTextStyle.primary4()), factory.ofStyled("system command", NutsTextStyle.primary6()), p.getDescription()});
                            break;
                        }
                        this.getSession().out().printlnf((Object)elem.ofObject().set("name", arg).set("type", "system-command").set("description", p.getDescription()).build());
                        break;
                    }
                    case ALIAS: {
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s (owner %s ) : %s%n", new Object[]{factory.ofStyled(arg, NutsTextStyle.primary4()), factory.ofStyled("nuts alias", NutsTextStyle.primary6()), p.getId(), NutsCommandLine.of((String[])this.getSession().commands().findCommand(p.getName()).getCommand(), (NutsSession)this.getSession())});
                            break;
                        }
                        this.getSession().out().printlnf((Object)elem.ofObject().set("name", arg).set("type", "alias").set("description", p.getDescription()).set("id", p.getId().toString()).build());
                        break;
                    }
                    case ARTIFACT: {
                        if (p.getId() == null) {
                            NutsId nid = NutsId.of((String)arg, (NutsSession)this.getSession());
                            if (nid != null) {
                                throw new NutsNotFoundException(this.getSession(), nid);
                            }
                            throw new NutsNotFoundException(this.getSession(), null, NutsMessage.cstyle((String)"artifact not found: %s%s", (Object[])new Object[]{arg == null ? "<null>" : arg}));
                        }
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s %s%n", new Object[]{factory.ofStyled(arg, NutsTextStyle.primary4()), factory.ofStyled("artifact", NutsTextStyle.primary6()), p.getId()});
                            break;
                        }
                        this.getSession().out().printlnf((Object)elem.ofObject().set("name", arg).set("type", "artifact").set("id", p.getId().toString()).set("description", p.getDescription()).build());
                        break;
                    }
                    case INTERNAL: {
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s %n", new Object[]{factory.ofStyled("internal command", NutsTextStyle.primary6()), factory.ofStyled(arg, NutsTextStyle.primary4())});
                            break;
                        }
                        this.getSession().out().printlnf((Object)elem.ofObject().set("name", arg).set("type", "internal-command").set("description", p.getDescription()).build());
                        break;
                    }
                    case UNKNOWN: {
                        if (this.getSession().isPlainOut()) {
                            out.printf("%s : %s %n", new Object[]{factory.ofStyled("unknown command", NutsTextStyle.primary6()), factory.ofStyled(arg, NutsTextStyle.primary4())});
                            break;
                        }
                        this.getSession().out().printlnf((Object)elem.ofObject().set("name", arg).set("type", "unknown-command").build());
                    }
                }
            }
            catch (NutsNotFoundException ex) {
                if (this.getSession().isPlainOut()) {
                    out.printf("%s : %s%n", new Object[]{factory.ofStyled(arg, NutsTextStyle.primary4()), factory.ofStyled("not found", NutsTextStyle.error())});
                    continue;
                }
                NutsElements e = elem;
                this.getSession().eout().add((NutsElement)e.ofObject().set("name", arg).set("type", "not-found").build());
            }
        }
    }
}

