/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.welcome;

import java.util.LinkedHashMap;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.app.util.NutsAppUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.exec.DefaultInternalNutsExecutableCommand;

public class DefaultNutsWelcomeInternalExecutable
extends DefaultInternalNutsExecutableCommand {
    public DefaultNutsWelcomeInternalExecutable(String[] args, NutsSession session) {
        super("welcome", args, session);
    }

    @Override
    public void execute() {
        if (NutsAppUtils.processHelpOptions(this.args, this.getSession())) {
            this.showDefaultHelp();
            return;
        }
        NutsSession session = this.getSession();
        NutsCommandLine commandLine = NutsCommandLine.of((String[])this.args, (NutsSession)session);
        while (commandLine.hasNext()) {
            NutsArgument a = commandLine.peek();
            if (a.isOption()) {
                switch (a.getKey().getString()) {
                    default: 
                }
                this.getSession().configureLast(commandLine);
                continue;
            }
            this.getSession().configureLast(commandLine);
        }
        if (session.isPlainOut()) {
            session.out().resetLine().println(NutsWorkspaceExt.of(session.getWorkspace()).getWelcomeText(session));
        } else {
            LinkedHashMap<String, String> welcome = new LinkedHashMap<String, String>();
            welcome.put("message", "Welcome to nuts. Yeah, it is working...");
            welcome.put("name", (String)NutsTexts.of((NutsSession)session).ofStyled("nuts", NutsTextStyle.primary((int)1)));
            welcome.put("long-name", "Network Updatable Things Services");
            welcome.put("description", "The Free and Open Source Package Manager for Java (TM) and other Things ...");
            welcome.put("url", (String)NutsPath.of((String)"http://github.com/thevpc/nuts", (NutsSession)session));
            welcome.put("author", "thevpc");
            welcome.put("api-id", (String)session.getWorkspace().getApiId().builder().setVersion("").build());
            welcome.put("api-version", (String)session.getWorkspace().getApiVersion());
            welcome.put("runtime-id", (String)session.getWorkspace().getRuntimeId().builder().setVersion("").build());
            welcome.put("runtime-version", (String)session.getWorkspace().getRuntimeId().getVersion());
            welcome.put("workspace", (String)session.locations().getWorkspaceLocation());
            welcome.put("hash-name", (String)NutsPath.of((String)session.getWorkspace().getHashName(), (NutsSession)session));
            if (session.isPlainOut()) {
                session = session.copy().setOutputFormat(NutsContentType.PROPS);
            }
            session.out().resetLine().printlnf(welcome);
        }
    }
}

