/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.update;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnexpectedException;
import net.thevpc.nuts.NutsUpdateCommand;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceUpdateResult;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsWorkspaceCommandBase;

public abstract class AbstractNutsUpdateCommand
extends NutsWorkspaceCommandBase<NutsUpdateCommand>
implements NutsUpdateCommand {
    protected boolean enableInstall = true;
    protected boolean updateApi = false;
    protected boolean updateRuntime = false;
    protected boolean updateExtensions = false;
    protected boolean updateInstalled = false;
    protected boolean updateCompanions = false;
    protected boolean includeOptional = false;
    protected NutsVersion forceBootAPIVersion;
    protected Instant expireTime;
    protected List<String> args;
    protected final List<NutsDependencyScope> scopes = new ArrayList<NutsDependencyScope>();
    protected final List<NutsId> lockedIds = new ArrayList<NutsId>();
    protected final List<NutsId> ids = new ArrayList<NutsId>();
    protected NutsWorkspaceUpdateResult result;

    public AbstractNutsUpdateCommand(NutsWorkspace ws) {
        super(ws, "update");
    }

    public NutsId[] getIds() {
        return this.ids == null ? new NutsId[]{} : this.ids.toArray(new NutsId[0]);
    }

    public NutsUpdateCommand addId(String id) {
        this.checkSession();
        NutsSession ws = this.getSession();
        return this.addId(id == null ? null : NutsId.of((String)id, (NutsSession)ws));
    }

    public NutsUpdateCommand addId(NutsId id) {
        if (id == null) {
            this.checkSession();
            throw new NutsNotFoundException(this.getSession(), id);
        }
        this.ids.add(id);
        return this;
    }

    public NutsUpdateCommand addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsUpdateCommand addIds(NutsId ... ids) {
        for (NutsId id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsUpdateCommand removeId(NutsId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    public NutsUpdateCommand removeId(String id) {
        this.checkSession();
        NutsSession ws = this.getSession();
        return this.removeId(NutsId.of((String)id, (NutsSession)ws));
    }

    public NutsUpdateCommand addScope(NutsDependencyScope scope) {
        if (scope != null) {
            this.scopes.add(scope);
        }
        return this;
    }

    public NutsUpdateCommand addScopes(NutsDependencyScope ... scopes) {
        if (scopes != null) {
            for (NutsDependencyScope s : scopes) {
                this.addScope(s);
            }
        }
        return this;
    }

    public NutsUpdateCommand addScopes(Collection<NutsDependencyScope> scopes) {
        if (scopes != null) {
            for (NutsDependencyScope s : scopes) {
                this.addScope(s);
            }
        }
        return this;
    }

    public boolean isOptional() {
        return this.includeOptional;
    }

    public NutsUpdateCommand setOptional(boolean includeOptional) {
        this.includeOptional = includeOptional;
        return this;
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : this.args.toArray(new String[0]);
    }

    public NutsUpdateCommand addArg(String arg) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (arg == null) {
            throw new NullPointerException();
        }
        this.args.add(arg);
        return this;
    }

    public NutsUpdateCommand clearArgs() {
        this.args = null;
        return this;
    }

    public NutsUpdateCommand addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    public NutsUpdateCommand addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) {
                    throw new NullPointerException();
                }
                this.args.add(arg);
            }
        }
        return this;
    }

    public NutsId[] getLockedIds() {
        return this.lockedIds == null ? new NutsId[]{} : this.lockedIds.toArray(new NutsId[0]);
    }

    public boolean isEnableInstall() {
        return this.enableInstall;
    }

    public NutsUpdateCommand setEnableInstall(boolean enableInstall) {
        this.enableInstall = enableInstall;
        return this;
    }

    private boolean isUpdateNone() {
        return !this.updateApi && !this.updateRuntime && !this.updateExtensions && !this.updateInstalled && !this.updateCompanions && this.ids.isEmpty();
    }

    public boolean isApi() {
        if (this.updateApi || this.isUpdateNone()) {
            return true;
        }
        for (NutsId id : this.ids) {
            if (!id.getShortName().equals("net.thevpc.nuts:nuts")) continue;
            return true;
        }
        return false;
    }

    public boolean isInstalled() {
        return this.updateInstalled;
    }

    public boolean isCompanions() {
        if (this.isApi()) {
            return true;
        }
        return this.updateCompanions;
    }

    public boolean isRuntime() {
        if (this.isApi()) {
            return true;
        }
        if (this.updateRuntime) {
            return true;
        }
        for (NutsId id : this.ids) {
            if (!id.getShortName().equals(this.ws.getRuntimeId().getShortName())) continue;
            return true;
        }
        return false;
    }

    public NutsUpdateCommand setApi(boolean enableMajorUpdates) {
        this.updateApi = enableMajorUpdates;
        return this;
    }

    public NutsUpdateCommand setCompanions(boolean updateCompanions) {
        this.updateCompanions = updateCompanions;
        return this;
    }

    public boolean isExtensions() {
        if (this.isApi()) {
            return true;
        }
        return this.updateExtensions;
    }

    public NutsUpdateCommand setExtensions(boolean updateExtensions) {
        this.updateExtensions = updateExtensions;
        return this;
    }

    public NutsVersion getApiVersion() {
        return this.forceBootAPIVersion;
    }

    public NutsUpdateCommand setApiVersion(NutsVersion value) {
        this.forceBootAPIVersion = value;
        return this;
    }

    public int getResultCount() {
        return this.getResult().getUpdatesCount();
    }

    public NutsWorkspaceUpdateResult getResult() {
        this.checkSession();
        if (this.result == null) {
            this.checkUpdates();
        }
        if (this.result == null) {
            throw new NutsUnexpectedException(this.getSession());
        }
        return this.result;
    }

    public NutsUpdateCommand run() {
        return this.update();
    }

    public NutsUpdateCommand checkUpdates(boolean applyUpdates) {
        this.checkUpdates();
        if (applyUpdates) {
            this.update();
        }
        return this;
    }

    public NutsUpdateCommand setRuntime(boolean updateRuntime) {
        this.updateRuntime = updateRuntime;
        return this;
    }

    public NutsUpdateCommand setInstalled(boolean enable) {
        this.updateInstalled = enable;
        return this;
    }

    public NutsUpdateCommand setAll() {
        this.setApi(true);
        this.setRuntime(true);
        this.setExtensions(true);
        this.setCompanions(true);
        this.setInstalled(true);
        return this;
    }

    public NutsUpdateCommand clearIds() {
        this.ids.clear();
        return this;
    }

    public NutsUpdateCommand addLockedId(NutsId id) {
        if (id != null) {
            this.lockedIds.add(id);
        }
        return this;
    }

    public NutsUpdateCommand addLockedId(String id) {
        this.checkSession();
        NutsSession ws = this.getSession();
        if (!NutsBlankable.isBlank((String)id)) {
            this.lockedIds.add(NutsId.of((String)id, (NutsSession)ws));
        }
        return this;
    }

    public NutsUpdateCommand addLockedIds(NutsId ... ids) {
        if (ids != null) {
            for (NutsId id : ids) {
                this.addId(id);
            }
        }
        return this;
    }

    public NutsUpdateCommand addLockedIds(String ... ids) {
        if (ids != null) {
            for (String id : ids) {
                this.addId(id);
            }
        }
        return this;
    }

    public NutsUpdateCommand clearLockedIds() {
        this.lockedIds.clear();
        return this;
    }

    public NutsUpdateCommand clearScopes() {
        this.scopes.clear();
        return this;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        this.checkSession();
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "-a": 
            case "--all": {
                cmdLine.skip();
                if (enabled) {
                    this.setAll();
                }
                return true;
            }
            case "-i": 
            case "--installed": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setInstalled(val);
                }
                return true;
            }
            case "-r": 
            case "--runtime": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setRuntime(val);
                }
                return true;
            }
            case "-A": 
            case "--api": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setApi(val);
                }
                return true;
            }
            case "-e": 
            case "--extensions": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setExtensions(val);
                }
                return true;
            }
            case "-c": 
            case "--companions": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setCompanions(val);
                }
                return true;
            }
            case "-v": 
            case "--api-version": 
            case "--to-version": {
                String val = cmdLine.nextString(new String[0]).getValue().getString();
                if (enabled) {
                    this.setApiVersion(NutsVersion.of((String)val, (NutsSession)this.getSession()));
                }
                return true;
            }
            case "-g": 
            case "--args": {
                cmdLine.skip();
                if (enabled) {
                    this.addArgs(cmdLine.toStringArray());
                }
                cmdLine.skipAll();
                return true;
            }
            case "-N": 
            case "--expire": {
                a = cmdLine.next();
                if (enabled) {
                    this.expireTime = a.getValue().getString() != null ? Instant.parse(a.getValue().getString()) : Instant.now();
                }
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (a.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(a.getString());
        return true;
    }
}

