/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.uninstall;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallStatusFilters;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUninstallCommand;
import net.thevpc.nuts.NutsUserCancelException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.event.DefaultNutsInstallEvent;
import net.thevpc.nuts.runtime.standalone.extension.NutsExtensionListHelper;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.uninstall.AbstractNutsUninstallCommand;
import net.thevpc.nuts.runtime.standalone.workspace.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.spi.NutsInstallerComponent;

public class DefaultNutsUninstallCommand
extends AbstractNutsUninstallCommand {
    public DefaultNutsUninstallCommand(NutsWorkspace ws) {
        super(ws);
    }

    public NutsUninstallCommand run() {
        this.checkSession();
        NutsWorkspaceUtils.of(this.getSession()).checkReadOnly();
        this.checkSession();
        NutsSession session = this.getSession();
        NutsWorkspaceExt dws = NutsWorkspaceExt.of(session.getWorkspace());
        session.security().setSession(this.getSession()).checkAllowed("uninstall", "uninstall");
        ArrayList defs = new ArrayList();
        NutsId[] nutsIds = this.getIds();
        if (nutsIds.length == 0) {
            throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)"missing packages to uninstall", (Object[])new Object[0]), 1);
        }
        for (NutsId id : nutsIds) {
            List resultDefinitions = session.search().addId(id).setInstallStatus(NutsInstallStatusFilters.of((NutsSession)session).byInstalled(true)).setSession(session.copy().setTransitive(Boolean.valueOf(false))).setOptional(Boolean.valueOf(false)).setEffective(true).setContent(true).getResultDefinitions().toList();
            resultDefinitions.removeIf(it -> !it.getInstallInformation().isInstalledOrRequired());
            if (resultDefinitions.isEmpty()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not installed : %s", (Object[])new Object[]{id}));
            }
            defs.addAll(resultDefinitions);
        }
        NutsMemoryPrintStream mout = NutsMemoryPrintStream.of((NutsSession)session);
        mout.println("should we proceed?");
        NutsMessage cancelMessage = NutsMessage.cstyle((String)"removal cancelled : %s", (Object[])new Object[]{defs.stream().map(NutsDefinition::getId).map(NutsId::getFullName).collect(Collectors.joining(", "))});
        if (!defs.isEmpty() && !this.getSession().getTerminal().ask().resetLine().setSession(session).forBoolean(mout.toString(), new Object[0]).setDefaultValue((Object)true).setCancelMessage(cancelMessage).getBooleanValue().booleanValue()) {
            throw new NutsUserCancelException(this.getSession(), cancelMessage);
        }
        for (NutsDefinition def : defs) {
            NutsInstallerComponent ii = dws.getInstaller(def, session);
            NutsPrintStream out = CoreIOUtils.resolveOut(session);
            if (ii != null) {
                NutsExecutionContext executionContext = dws.createExecutionContext().setDefinition(def).setArguments(this.getArgs()).setExecSession(session).setSession(session).setWorkspace(session.getWorkspace()).setFailFast(true).setTemporary(false).setExecutionType(session.boot().getBootOptions().getExecutionType()).setRunAs(NutsRunAs.currentUser()).build();
                ii.uninstall(executionContext, this.isErase());
            }
            dws.getInstalledRepository().uninstall(def, session);
            NutsId id = def.getId();
            if (session.locations().getStoreLocation(id, NutsStoreLocation.APPS).exists()) {
                session.locations().getStoreLocation(id, NutsStoreLocation.APPS).deleteTree();
            }
            if (session.locations().getStoreLocation(id, NutsStoreLocation.LOG).exists()) {
                session.locations().getStoreLocation(id, NutsStoreLocation.LOG).deleteTree();
            }
            if (this.isErase()) {
                if (session.locations().getStoreLocation(id, NutsStoreLocation.VAR).exists()) {
                    session.locations().getStoreLocation(id, NutsStoreLocation.VAR).deleteTree();
                }
                if (session.locations().getStoreLocation(id, NutsStoreLocation.CONFIG).exists()) {
                    session.locations().getStoreLocation(id, NutsStoreLocation.CONFIG).deleteTree();
                }
            }
            if (def.getDescriptor().getIdType() == NutsIdType.EXTENSION) {
                NutsWorkspaceConfigManagerExt wcfg = NutsWorkspaceConfigManagerExt.of(session.config());
                NutsExtensionListHelper h = new NutsExtensionListHelper(session.getWorkspace().getApiId(), wcfg.getModel().getStoredConfigBoot().getExtensions()).save();
                h.remove(id);
                wcfg.getModel().getStoredConfigBoot().setExtensions(h.getConfs());
                wcfg.getModel().fireConfigurationChanged("extensions", session, ConfigEventType.BOOT);
            }
            if (this.getSession().isPlainTrace()) {
                out.printf("%s uninstalled %s%n", new Object[]{id, NutsTexts.of((NutsSession)session).ofStyled("successfully", NutsTextStyle.success())});
            }
            NutsWorkspaceUtils.of(session).events().fireOnUninstall(new DefaultNutsInstallEvent(def, session, new NutsId[0], this.isErase()));
        }
        return this;
    }
}

