/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.cmd.undeploy;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUndeployCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.NutsWorkspaceCommandBase;

public abstract class AbstractNutsUndeployCommand
extends NutsWorkspaceCommandBase<NutsUndeployCommand>
implements NutsUndeployCommand {
    protected List<NutsId> result;
    protected final List<NutsId> ids = new ArrayList<NutsId>();
    protected String repository;
    protected boolean offline = true;

    public AbstractNutsUndeployCommand(NutsWorkspace ws) {
        super(ws, "undeploy");
    }

    public NutsId[] getIds() {
        return this.ids.toArray(new NutsId[0]);
    }

    public NutsUndeployCommand addId(NutsId id) {
        if (id != null) {
            this.ids.add(id);
        }
        this.invalidateResult();
        return this;
    }

    public NutsUndeployCommand addId(String id) {
        this.checkSession();
        NutsSession ws = this.getSession();
        return this.addId(NutsBlankable.isBlank((String)id) ? null : NutsId.of((String)id, (NutsSession)ws));
    }

    public NutsUndeployCommand addIds(String ... values) {
        this.checkSession();
        NutsSession ws = this.getSession();
        if (values != null) {
            for (String s : values) {
                if (NutsBlankable.isBlank((String)s)) continue;
                this.ids.add(NutsId.of((String)s, (NutsSession)ws));
            }
        }
        return this;
    }

    public NutsUndeployCommand addIds(NutsId ... value) {
        if (value != null) {
            for (NutsId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    public NutsUndeployCommand clearIds() {
        this.ids.clear();
        return this;
    }

    public String getRepository() {
        return this.repository;
    }

    public NutsUndeployCommand setRepository(String repository) {
        this.repository = repository;
        this.invalidateResult();
        return this;
    }

    protected void addResult(NutsId id) {
        if (this.result == null) {
            this.result = new ArrayList<NutsId>();
        }
        this.result.add(id);
        this.checkSession();
        NutsSession session = this.getSession();
        if (!(!session.isTrace() || session.getOutputFormat() != null && session.getOutputFormat() != NutsContentType.PLAIN || session.getOutputFormat() != null && session.getOutputFormat() != NutsContentType.PLAIN)) {
            session.getTerminal().out().printf("Nuts %s undeployed successfully%n", new Object[]{id});
        }
    }

    public boolean isOffline() {
        return this.offline;
    }

    public NutsUndeployCommand setOffline(boolean offline) {
        this.offline = offline;
        this.invalidateResult();
        return this;
    }

    @Override
    protected void invalidateResult() {
        this.result = null;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--offline": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOffline(val);
                }
                return true;
            }
            case "-r": 
            case "-repository": 
            case "--from": {
                String val = cmdLine.nextString(new String[0]).getValue().getString();
                if (!enabled) break;
                this.setRepository(val);
                break;
            }
            default: {
                if (super.configureFirst(cmdLine)) {
                    return true;
                }
                if (a.isOption()) {
                    return false;
                }
                cmdLine.skip();
                this.addId(a.getString());
                return true;
            }
        }
        return false;
    }
}

